/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.wiki.model.WikiNode"})
public class WikiNodePermissionChecker
implements BaseModelPermissionChecker {
    private static WikiNodeLocalService _wikiNodeLocalService;

    public static void check(PermissionChecker permissionChecker, long nodeId, String actionId) throws PortalException {
        WikiNode node = _wikiNodeLocalService.getNode(nodeId);
        WikiNodePermissionChecker.check(permissionChecker, node, actionId);
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String name, String actionId) throws PortalException {
        WikiNode node = _wikiNodeLocalService.getNode(groupId, name);
        WikiNodePermissionChecker.check(permissionChecker, node, actionId);
    }

    public static void check(PermissionChecker permissionChecker, WikiNode node, String actionId) throws PortalException {
        if (!WikiNodePermissionChecker.contains(permissionChecker, node, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WikiNode.class.getName(), node.getNodeId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String actionId) throws PortalException {
        WikiNode node = _wikiNodeLocalService.getNode(nodeId);
        return WikiNodePermissionChecker.contains(permissionChecker, node, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String name, String actionId) throws PortalException {
        WikiNode node = _wikiNodeLocalService.getNode(groupId, name);
        return WikiNodePermissionChecker.contains(permissionChecker, node, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, WikiNode node, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)node.getGroupId(), (String)WikiNode.class.getName(), (long)node.getNodeId(), (String)"com_liferay_wiki_web_portlet_WikiPortlet", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId(), node.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        WikiNodePermissionChecker.check(permissionChecker, primaryKey, actionId);
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        _wikiNodeLocalService = wikiNodeLocalService;
    }
}

