/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.permission.WikiNodePermissionChecker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.wiki.model.WikiPage"})
public class WikiPagePermissionChecker
implements BaseModelPermissionChecker {
    private static WikiPageLocalService _wikiPageLocalService;

    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException {
        WikiPage page = _wikiPageLocalService.fetchPage(resourcePrimKey);
        if (page == null) {
            page = _wikiPageLocalService.getPageByPageId(resourcePrimKey);
        }
        WikiPagePermissionChecker.check(permissionChecker, page, actionId);
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title2, double version, String actionId) throws PortalException {
        if (!WikiPagePermissionChecker.contains(permissionChecker, nodeId, title2, version, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WikiNode.class.getName(), nodeId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title2, String actionId) throws PortalException {
        if (!WikiPagePermissionChecker.contains(permissionChecker, nodeId, title2, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WikiNode.class.getName(), nodeId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, WikiPage page, String actionId) throws PortalException {
        if (!WikiPagePermissionChecker.contains(permissionChecker, page, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WikiPage.class.getName(), page.getPageId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        WikiPage page = _wikiPageLocalService.fetchPage(classPK);
        if (page == null) {
            page = _wikiPageLocalService.getPageByPageId(classPK);
        }
        return WikiPagePermissionChecker.contains(permissionChecker, page, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title2, double version, String actionId) throws PortalException {
        try {
            WikiPage page = _wikiPageLocalService.getPage(nodeId, title2, version);
            return WikiPagePermissionChecker.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException nspe) {
            return WikiNodePermissionChecker.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title2, String actionId) throws PortalException {
        try {
            WikiPage page = _wikiPageLocalService.getPage(nodeId, title2, null);
            return WikiPagePermissionChecker.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException nspe) {
            return WikiNodePermissionChecker.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getPageId(), (String)"com_liferay_wiki_web_portlet_WikiPortlet", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (page.isDraft()) {
            if (actionId.equals("VIEW") && !WikiPagePermissionChecker.contains(permissionChecker, page, "UPDATE")) {
                return false;
            }
            if (actionId.equals("DELETE") && page.getStatusByUserId() == permissionChecker.getUserId()) {
                return true;
            }
        } else if (page.isPending()) {
            hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (String)actionId);
            if (hasPermission != null && hasPermission.booleanValue()) {
                return true;
            }
        } else if (page.isScheduled() && actionId.equals("VIEW") && !WikiPagePermissionChecker.contains(permissionChecker, page, "UPDATE")) {
            return false;
        }
        if (actionId.equals("VIEW")) {
            WikiPage redirectPage = page.fetchRedirectPage();
            if (redirectPage != null) {
                page = redirectPage;
            }
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                WikiNode node = page.getNode();
                if (!WikiNodePermissionChecker.contains(permissionChecker, node, actionId)) {
                    return false;
                }
                while (page != null) {
                    if (!WikiPagePermissionChecker._hasPermission(permissionChecker, page, actionId)) {
                        return false;
                    }
                    page = page.fetchParentPage();
                }
                return true;
            }
        }
        return WikiPagePermissionChecker._hasPermission(permissionChecker, page, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        WikiPagePermissionChecker.check(permissionChecker, primaryKey, actionId);
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        _wikiPageLocalService = wikiPageLocalService;
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        return permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUserId(), actionId) || permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), actionId);
    }
}

