/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseResourcePermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"resource.name=com.liferay.wiki"}, service={ResourcePermissionChecker.class})
public class WikiResourcePermissionChecker
extends BaseResourcePermissionChecker {
    public static final String RESOURCE_NAME = "com.liferay.wiki";

    public static void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!WikiResourcePermissionChecker.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, RESOURCE_NAME, groupId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        return WikiResourcePermissionChecker.contains((PermissionChecker)permissionChecker, (String)RESOURCE_NAME, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (long)groupId, (String)actionId);
    }

    public Boolean checkResource(PermissionChecker permissionChecker, long classPK, String actionId) {
        return WikiResourcePermissionChecker.contains(permissionChecker, classPK, actionId);
    }
}

