/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.impl.WikiNodeImpl;
import com.liferay.wiki.model.impl.WikiNodeModelImpl;
import com.liferay.wiki.service.persistence.WikiNodePersistence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class WikiNodePersistenceImpl
extends BasePersistenceImpl<WikiNode>
implements WikiNodePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = WikiNodeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 20L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "wikiNode.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "wikiNode.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_UUID_G = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_G = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_G_UUID_1 = "wikiNode.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "wikiNode.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "wikiNode.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 21L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "wikiNode.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "wikiNode.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "wikiNode.companyId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "wikiNode.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_COMPANYID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 5L);
    public static final FinderPath FINDER_PATH_COUNT_BY_COMPANYID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "wikiNode.companyId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_G_N = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N", new String[]{Long.class.getName(), String.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_N = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_G_N_GROUPID_2 = "wikiNode.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_NAME_1 = "wikiNode.name IS NULL";
    private static final String _FINDER_COLUMN_G_N_NAME_2 = "wikiNode.name = ?";
    private static final String _FINDER_COLUMN_G_N_NAME_3 = "(wikiNode.name IS NULL OR wikiNode.name = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_G_S = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, 14L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_S = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()});
    private static final String _FINDER_COLUMN_G_S_GROUPID_2 = "wikiNode.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_S_STATUS_2 = "wikiNode.status = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_S = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_S = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, 13L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_S = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Integer.class.getName()});
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "wikiNode.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_STATUS_2 = "wikiNode.status = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_WIKINODE = "SELECT wikiNode FROM WikiNode wikiNode";
    private static final String _SQL_SELECT_WIKINODE_WHERE_PKS_IN = "SELECT wikiNode FROM WikiNode wikiNode WHERE nodeId IN (";
    private static final String _SQL_SELECT_WIKINODE_WHERE = "SELECT wikiNode FROM WikiNode wikiNode WHERE ";
    private static final String _SQL_COUNT_WIKINODE = "SELECT COUNT(wikiNode) FROM WikiNode wikiNode";
    private static final String _SQL_COUNT_WIKINODE_WHERE = "SELECT COUNT(wikiNode) FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "wikiNode.nodeId";
    private static final String _FILTER_SQL_SELECT_WIKINODE_WHERE = "SELECT DISTINCT {wikiNode.*} FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {WikiNode.*} FROM (SELECT DISTINCT wikiNode.nodeId FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN WikiNode ON TEMP_TABLE.nodeId = WikiNode.nodeId";
    private static final String _FILTER_SQL_COUNT_WIKINODE_WHERE = "SELECT COUNT(DISTINCT wikiNode.nodeId) AS COUNT_VALUE FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "wikiNode";
    private static final String _FILTER_ENTITY_TABLE = "WikiNode";
    private static final String _ORDER_BY_ENTITY_ALIAS = "wikiNode.";
    private static final String _ORDER_BY_ENTITY_TABLE = "WikiNode.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WikiNode exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WikiNode exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(WikiNodePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<WikiNode> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<WikiNode> list = null;
        if (retrieveFromCache && (list = (List<WikiNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (Objects.equals(uuid, wikiNode.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByUuid_First(String uuid, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_First(uuid, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByUuid_First(String uuid, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByUuid_Last(String uuid, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_Last(uuid, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByUuid_Last(String uuid, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByUuid_PrevAndNext(long nodeId, String uuid, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByUuid_PrevAndNext(session, wikiNode, uuid, orderByComparator, true), wikiNode, this.getByUuid_PrevAndNext(session, wikiNode, uuid, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByUuid_PrevAndNext(Session session, WikiNode wikiNode, String uuid, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_WIKINODE_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (WikiNode wikiNode : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByUuid(String uuid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiNode findByUUID_G(String uuid, long groupId) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUUID_G(uuid, groupId);
        if (wikiNode == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchNodeException(msg.toString());
        }
        return wikiNode;
    }

    public WikiNode fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public WikiNode fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        WikiNode wikiNode;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiNode && (!Objects.equals(uuid, (wikiNode = (WikiNode)result).getUuid()) || groupId != wikiNode.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiNode.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiNode.uuid = ? AND ");
            }
            query.append("wikiNode.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q2.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)list);
                } else {
                    WikiNode wikiNode2 = (WikiNode)list.get(0);
                    result = wikiNode2;
                    this.cacheResult(wikiNode2);
                    if (wikiNode2.getUuid() == null || !wikiNode2.getUuid().equals(uuid) || wikiNode2.getGroupId() != groupId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)wikiNode2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiNode)result;
    }

    public WikiNode removeByUUID_G(String uuid, long groupId) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByUUID_G(uuid, groupId);
        return (WikiNode)this.remove((BaseModel)wikiNode);
    }

    public int countByUUID_G(String uuid, long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiNode.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiNode.uuid = ? AND ");
            }
            query.append("wikiNode.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<WikiNode> list = null;
        if (retrieveFromCache && (list = (List<WikiNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (Objects.equals(uuid, wikiNode.getUuid()) && companyId == wikiNode.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiNode.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiNode.uuid = ? AND ");
            }
            query.append("wikiNode.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByUuid_C_PrevAndNext(long nodeId, String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByUuid_C_PrevAndNext(session, wikiNode, uuid, companyId, orderByComparator, true), wikiNode, this.getByUuid_C_PrevAndNext(session, wikiNode, uuid, companyId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByUuid_C_PrevAndNext(Session session, WikiNode wikiNode, String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_WIKINODE_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append("wikiNode.uuid IS NULL AND ");
        } else if (uuid.equals("")) {
            query.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("wikiNode.uuid = ? AND ");
        }
        query.append("wikiNode.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (WikiNode wikiNode : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiNode.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiNode.uuid = ? AND ");
            }
            query.append("wikiNode.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiNode> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<WikiNode> list = null;
        if (retrieveFromCache && (list = (List<WikiNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (groupId == wikiNode.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByGroupId_First(long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByGroupId_First(groupId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByGroupId_First(long groupId, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByGroupId_Last(long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByGroupId_Last(long groupId, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByGroupId_PrevAndNext(long nodeId, long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, true), wikiNode, this.getByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByGroupId_PrevAndNext(Session session, WikiNode wikiNode, long groupId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_WIKINODE_WHERE);
        query.append("wikiNode.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public List<WikiNode> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<WikiNode> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<WikiNode> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("wikiNode.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY wikiNode.name ASC");
        } else {
            query.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q2 = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q2.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
            } else {
                q2.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q2);
            qPos.add(groupId);
            List list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode[] filterFindByGroupId_PrevAndNext(long nodeId, long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId_PrevAndNext(nodeId, groupId, orderByComparator);
        }
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.filterGetByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, true), wikiNode, this.filterGetByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode filterGetByGroupId_PrevAndNext(Session session, WikiNode wikiNode, long groupId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("wikiNode.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY wikiNode.name ASC");
        } else {
            query.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q2 = session.createSynchronizedSQLQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q2.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
        } else {
            q2.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (WikiNode wikiNode : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(groupId);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_WIKINODE_WHERE);
        query.append("wikiNode.groupId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q2 = session.createSynchronizedSQLQuery(sql);
            q2.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q2);
            qPos.add(groupId);
            Long count = (Long)q2.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiNode> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_COMPANYID;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<WikiNode> list = null;
        if (retrieveFromCache && (list = (List<WikiNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (companyId == wikiNode.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append("wikiNode.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByCompanyId_First(long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByCompanyId_First(long companyId, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByCompanyId_Last(long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByCompanyId_Last(long companyId, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByCompanyId_PrevAndNext(long nodeId, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByCompanyId_PrevAndNext(session, wikiNode, companyId, orderByComparator, true), wikiNode, this.getByCompanyId_PrevAndNext(session, wikiNode, companyId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByCompanyId_PrevAndNext(Session session, WikiNode wikiNode, long companyId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_WIKINODE_WHERE);
        query.append("wikiNode.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (WikiNode wikiNode : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_COMPANYID;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            query.append("wikiNode.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(companyId);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiNode findByG_N(long groupId, String name) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByG_N(groupId, name);
        if (wikiNode == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchNodeException(msg.toString());
        }
        return wikiNode;
    }

    public WikiNode fetchByG_N(long groupId, String name) {
        return this.fetchByG_N(groupId, name, true);
    }

    public WikiNode fetchByG_N(long groupId, String name, boolean retrieveFromCache) {
        WikiNode wikiNode;
        Object[] finderArgs = new Object[]{groupId, name};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_G_N, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiNode && (groupId != (wikiNode = (WikiNode)result).getGroupId() || !Objects.equals(name, wikiNode.getName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if ((list = q2.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N, finderArgs, (Object)list);
                } else {
                    WikiNode wikiNode2 = (WikiNode)list.get(0);
                    result = wikiNode2;
                    this.cacheResult(wikiNode2);
                    if (wikiNode2.getGroupId() != groupId || wikiNode2.getName() == null || !wikiNode2.getName().equals(name)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N, finderArgs, (Object)wikiNode2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_N, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiNode)result;
    }

    public WikiNode removeByG_N(long groupId, String name) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByG_N(groupId, name);
        return (WikiNode)this.remove((BaseModel)wikiNode);
    }

    public int countByG_N(long groupId, String name) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_N;
        Object[] finderArgs = new Object[]{groupId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ? AND ");
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiNode> findByG_S(long groupId, int status) {
        return this.findByG_S(groupId, status, -1, -1, null);
    }

    public List<WikiNode> findByG_S(long groupId, int status, int start, int end) {
        return this.findByG_S(groupId, status, start, end, null);
    }

    public List<WikiNode> findByG_S(long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByG_S(groupId, status, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByG_S(long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S;
            finderArgs = new Object[]{groupId, status};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_G_S;
            finderArgs = new Object[]{groupId, status, start, end, orderByComparator};
        }
        List<WikiNode> list = null;
        if (retrieveFromCache && (list = (List<WikiNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (groupId == wikiNode.getGroupId() && status == wikiNode.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ? AND ");
            query.append("wikiNode.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(groupId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByG_S_First(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByG_S_First(groupId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByG_S_First(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByG_S(groupId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByG_S_Last(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByG_S_Last(groupId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByG_S_Last(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByG_S(groupId, status);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByG_S(groupId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByG_S_PrevAndNext(long nodeId, long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, true), wikiNode, this.getByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByG_S_PrevAndNext(Session session, WikiNode wikiNode, long groupId, int status, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_WIKINODE_WHERE);
        query.append("wikiNode.groupId = ? AND ");
        query.append("wikiNode.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        qPos.add(groupId);
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public List<WikiNode> filterFindByG_S(long groupId, int status) {
        return this.filterFindByG_S(groupId, status, -1, -1, null);
    }

    public List<WikiNode> filterFindByG_S(long groupId, int status, int start, int end) {
        return this.filterFindByG_S(groupId, status, start, end, null);
    }

    public List<WikiNode> filterFindByG_S(long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_S(groupId, status, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("wikiNode.groupId = ? AND ");
        query.append("wikiNode.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY wikiNode.name ASC");
        } else {
            query.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q2 = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q2.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
            } else {
                q2.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q2);
            qPos.add(groupId);
            qPos.add(status);
            List list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode[] filterFindByG_S_PrevAndNext(long nodeId, long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_S_PrevAndNext(nodeId, groupId, status, orderByComparator);
        }
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.filterGetByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, true), wikiNode, this.filterGetByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode filterGetByG_S_PrevAndNext(Session session, WikiNode wikiNode, long groupId, int status, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("wikiNode.groupId = ? AND ");
        query.append("wikiNode.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY wikiNode.name ASC");
        } else {
            query.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q2 = session.createSynchronizedSQLQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q2.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
        } else {
            q2.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        qPos.add(groupId);
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByG_S(long groupId, int status) {
        for (WikiNode wikiNode : this.findByG_S(groupId, status, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByG_S(long groupId, int status) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_S;
        Object[] finderArgs = new Object[]{groupId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ? AND ");
            query.append("wikiNode.status = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(groupId);
                qPos.add(status);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_S(long groupId, int status) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_S(groupId, status);
        }
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_WIKINODE_WHERE);
        query.append("wikiNode.groupId = ? AND ");
        query.append("wikiNode.status = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q2 = session.createSynchronizedSQLQuery(sql);
            q2.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q2);
            qPos.add(groupId);
            qPos.add(status);
            Long count = (Long)q2.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiNode> findByC_S(long companyId, int status) {
        return this.findByC_S(companyId, status, -1, -1, null);
    }

    public List<WikiNode> findByC_S(long companyId, int status, int start, int end) {
        return this.findByC_S(companyId, status, start, end, null);
    }

    public List<WikiNode> findByC_S(long companyId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByC_S(companyId, status, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByC_S(long companyId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_S;
            finderArgs = new Object[]{companyId, status};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_S;
            finderArgs = new Object[]{companyId, status, start, end, orderByComparator};
        }
        List<WikiNode> list = null;
        if (retrieveFromCache && (list = (List<WikiNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (companyId == wikiNode.getCompanyId() && status == wikiNode.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            query.append("wikiNode.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(companyId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByC_S_First(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByC_S_First(companyId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByC_S_First(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByC_S(companyId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByC_S_Last(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByC_S_Last(companyId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public WikiNode fetchByC_S_Last(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByC_S(companyId, status);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByC_S(companyId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByC_S_PrevAndNext(long nodeId, long companyId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByC_S_PrevAndNext(session, wikiNode, companyId, status, orderByComparator, true), wikiNode, this.getByC_S_PrevAndNext(session, wikiNode, companyId, status, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByC_S_PrevAndNext(Session session, WikiNode wikiNode, long companyId, int status, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_WIKINODE_WHERE);
        query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        query.append("wikiNode.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        qPos.add(companyId);
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long companyId, int status) {
        for (WikiNode wikiNode : this.findByC_S(companyId, status, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByC_S(long companyId, int status) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_S;
        Object[] finderArgs = new Object[]{companyId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKINODE_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            query.append("wikiNode.status = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(companyId);
                qPos.add(status);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiNodePersistenceImpl() {
        block2: {
            this.setModelClass(WikiNode.class);
            try {
                Field field = ReflectionUtil.getDeclaredField(BasePersistenceImpl.class, (String)"_dbColumnNames");
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("uuid", "uuid_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(WikiNode wikiNode) {
        this.entityCache.putResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (Serializable)wikiNode);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, new Object[]{wikiNode.getUuid(), wikiNode.getGroupId()}, (Object)wikiNode);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N, new Object[]{wikiNode.getGroupId(), wikiNode.getName()}, (Object)wikiNode);
        wikiNode.resetOriginalValues();
    }

    public void cacheResult(List<WikiNode> wikiNodes) {
        for (WikiNode wikiNode : wikiNodes) {
            if (this.entityCache.getResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey())) == null) {
                this.cacheResult(wikiNode);
                continue;
            }
            wikiNode.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(WikiNodeImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(WikiNode wikiNode) {
        this.entityCache.removeResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((WikiNodeModelImpl)wikiNode, true);
    }

    public void clearCache(List<WikiNode> wikiNodes) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (WikiNode wikiNode : wikiNodes) {
            this.entityCache.removeResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()));
            this.clearUniqueFindersCache((WikiNodeModelImpl)wikiNode, true);
        }
    }

    protected void cacheUniqueFindersCache(WikiNodeModelImpl wikiNodeModelImpl) {
        Object[] args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getGroupId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_UUID_G, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, args, (Object)wikiNodeModelImpl, false);
        args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getName()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_G_N, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N, args, (Object)wikiNodeModelImpl, false);
    }

    protected void clearUniqueFindersCache(WikiNodeModelImpl wikiNodeModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        }
        if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiNodeModelImpl.getOriginalUuid(), wikiNodeModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getName()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_N, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_N, args);
        }
        if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_N.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiNodeModelImpl.getOriginalGroupId(), wikiNodeModelImpl.getOriginalName()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_N, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_N, args);
        }
    }

    public WikiNode create(long nodeId) {
        WikiNodeImpl wikiNode = new WikiNodeImpl();
        wikiNode.setNew(true);
        wikiNode.setPrimaryKey(nodeId);
        String uuid = PortalUUIDUtil.generate();
        wikiNode.setUuid(uuid);
        wikiNode.setCompanyId(this.companyProvider.getCompanyId());
        return wikiNode;
    }

    public WikiNode remove(long nodeId) throws NoSuchNodeException {
        return this.remove(Long.valueOf(nodeId));
    }

    public WikiNode remove(Serializable primaryKey) throws NoSuchNodeException {
        Session session = null;
        try {
            session = this.openSession();
            WikiNode wikiNode = (WikiNode)session.get(WikiNodeImpl.class, primaryKey);
            if (wikiNode == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            WikiNode wikiNode2 = (WikiNode)this.remove((BaseModel)wikiNode);
            return wikiNode2;
        }
        catch (NoSuchNodeException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode removeImpl(WikiNode wikiNode) {
        wikiNode = this.toUnwrappedModel(wikiNode);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)wikiNode)) {
                wikiNode = (WikiNode)session.get(WikiNodeImpl.class, wikiNode.getPrimaryKeyObj());
            }
            if (wikiNode != null) {
                session.delete((Object)wikiNode);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (wikiNode != null) {
            this.clearCache(wikiNode);
        }
        return wikiNode;
    }

    public WikiNode updateImpl(WikiNode wikiNode) {
        wikiNode = this.toUnwrappedModel(wikiNode);
        boolean isNew = wikiNode.isNew();
        WikiNodeModelImpl wikiNodeModelImpl = (WikiNodeModelImpl)wikiNode;
        if (Validator.isNull((String)wikiNode.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            wikiNode.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && wikiNode.getCreateDate() == null) {
            if (serviceContext == null) {
                wikiNode.setCreateDate(now);
            } else {
                wikiNode.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!wikiNodeModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                wikiNode.setModifiedDate(now);
            } else {
                wikiNode.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (wikiNode.isNew()) {
                session.save((Object)wikiNode);
                wikiNode.setNew(false);
            } else {
                wikiNode = (WikiNode)session.merge((Object)wikiNode);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!WikiNodeModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{wikiNodeModelImpl.getUuid()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getCompanyId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            args = new Object[]{wikiNodeModelImpl.getGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            args = new Object[]{wikiNodeModelImpl.getCompanyId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
            args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getStatus()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_S, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S, args);
            args = new Object[]{wikiNodeModelImpl.getCompanyId(), wikiNodeModelImpl.getStatus()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_S, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_S, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
                args = new Object[]{wikiNodeModelImpl.getUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalUuid(), wikiNodeModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
                args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
                args = new Object[]{wikiNodeModelImpl.getGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
                args = new Object[]{wikiNodeModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalGroupId(), wikiNodeModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S, args);
                args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_S.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalCompanyId(), wikiNodeModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_S, args);
                args = new Object[]{wikiNodeModelImpl.getCompanyId(), wikiNodeModelImpl.getStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_S, args);
            }
        }
        this.entityCache.putResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (Serializable)wikiNode, false);
        this.clearUniqueFindersCache(wikiNodeModelImpl, false);
        this.cacheUniqueFindersCache(wikiNodeModelImpl);
        wikiNode.resetOriginalValues();
        return wikiNode;
    }

    protected WikiNode toUnwrappedModel(WikiNode wikiNode) {
        if (wikiNode instanceof WikiNodeImpl) {
            return wikiNode;
        }
        WikiNodeImpl wikiNodeImpl = new WikiNodeImpl();
        wikiNodeImpl.setNew(wikiNode.isNew());
        wikiNodeImpl.setPrimaryKey(wikiNode.getPrimaryKey());
        wikiNodeImpl.setUuid(wikiNode.getUuid());
        wikiNodeImpl.setNodeId(wikiNode.getNodeId());
        wikiNodeImpl.setGroupId(wikiNode.getGroupId());
        wikiNodeImpl.setCompanyId(wikiNode.getCompanyId());
        wikiNodeImpl.setUserId(wikiNode.getUserId());
        wikiNodeImpl.setUserName(wikiNode.getUserName());
        wikiNodeImpl.setCreateDate(wikiNode.getCreateDate());
        wikiNodeImpl.setModifiedDate(wikiNode.getModifiedDate());
        wikiNodeImpl.setName(wikiNode.getName());
        wikiNodeImpl.setDescription(wikiNode.getDescription());
        wikiNodeImpl.setLastPostDate(wikiNode.getLastPostDate());
        wikiNodeImpl.setLastPublishDate(wikiNode.getLastPublishDate());
        wikiNodeImpl.setStatus(wikiNode.getStatus());
        wikiNodeImpl.setStatusByUserId(wikiNode.getStatusByUserId());
        wikiNodeImpl.setStatusByUserName(wikiNode.getStatusByUserName());
        wikiNodeImpl.setStatusDate(wikiNode.getStatusDate());
        return wikiNodeImpl;
    }

    public WikiNode findByPrimaryKey(Serializable primaryKey) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByPrimaryKey(primaryKey);
        if (wikiNode == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return wikiNode;
    }

    public WikiNode findByPrimaryKey(long nodeId) throws NoSuchNodeException {
        return this.findByPrimaryKey(Long.valueOf(nodeId));
    }

    public WikiNode fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        WikiNode wikiNode = (WikiNode)serializable;
        if (wikiNode == null) {
            Session session = null;
            try {
                session = this.openSession();
                wikiNode = (WikiNode)session.get(WikiNodeImpl.class, primaryKey);
                if (wikiNode != null) {
                    this.cacheResult(wikiNode);
                } else {
                    this.entityCache.putResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return wikiNode;
    }

    public WikiNode fetchByPrimaryKey(long nodeId) {
        return this.fetchByPrimaryKey(Long.valueOf(nodeId));
    }

    public Map<Serializable, WikiNode> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, WikiNode> map2 = new HashMap<Serializable, WikiNode>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            WikiNode wikiNode = this.fetchByPrimaryKey(primaryKey);
            if (wikiNode != null) {
                map2.put(primaryKey, wikiNode);
            }
            return map2;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map2.put(serializable, (WikiNode)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map2;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_WIKINODE_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q2 = session.createQuery(string);
            for (WikiNode wikiNode : q2.list()) {
                map2.put(wikiNode.getPrimaryKeyObj(), wikiNode);
                this.cacheResult(wikiNode);
                uncachedPrimaryKeys.remove(wikiNode.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map2;
    }

    public List<WikiNode> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<WikiNode> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<WikiNode> findAll(int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<WikiNode> findAll(int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_WIKINODE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_WIKINODE;
                if (pagination) {
                    sql = sql.concat(" ORDER BY wikiNode.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (WikiNode wikiNode : this.findAll()) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(_SQL_COUNT_WIKINODE);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return WikiNodeModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(WikiNodeImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

