/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.wiki.exception.NoSuchPageResourceException;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.model.impl.WikiPageResourceImpl;
import com.liferay.wiki.model.impl.WikiPageResourceModelImpl;
import com.liferay.wiki.service.persistence.WikiPageResourcePersistence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class WikiPageResourcePersistenceImpl
extends BasePersistenceImpl<WikiPageResource>
implements WikiPageResourcePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = WikiPageResourceImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "wikiPageResource.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "wikiPageResource.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_UUID_G = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_G = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_G_UUID_1 = "wikiPageResource.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "wikiPageResource.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "wikiPageResource.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 17L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "wikiPageResource.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "wikiPageResource.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "wikiPageResource.companyId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_N_T = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, WikiPageResourceImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByN_T", new String[]{Long.class.getName(), String.class.getName()}, 12L);
    public static final FinderPath FINDER_PATH_COUNT_BY_N_T = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByN_T", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_N_T_NODEID_2 = "wikiPageResource.nodeId = ? AND ";
    private static final String _FINDER_COLUMN_N_T_TITLE_1 = "wikiPageResource.title IS NULL";
    private static final String _FINDER_COLUMN_N_T_TITLE_2 = "wikiPageResource.title = ?";
    private static final String _FINDER_COLUMN_N_T_TITLE_3 = "(wikiPageResource.title IS NULL OR wikiPageResource.title = '')";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_WIKIPAGERESOURCE = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource";
    private static final String _SQL_SELECT_WIKIPAGERESOURCE_WHERE_PKS_IN = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource WHERE resourcePrimKey IN (";
    private static final String _SQL_SELECT_WIKIPAGERESOURCE_WHERE = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource WHERE ";
    private static final String _SQL_COUNT_WIKIPAGERESOURCE = "SELECT COUNT(wikiPageResource) FROM WikiPageResource wikiPageResource";
    private static final String _SQL_COUNT_WIKIPAGERESOURCE_WHERE = "SELECT COUNT(wikiPageResource) FROM WikiPageResource wikiPageResource WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "wikiPageResource.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WikiPageResource exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WikiPageResource exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(WikiPageResourcePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<WikiPageResource> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end, OrderByComparator<WikiPageResource> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end, OrderByComparator<WikiPageResource> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<WikiPageResource> list = null;
        if (retrieveFromCache && (list = (List<WikiPageResource>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiPageResource wikiPageResource : list) {
                if (Objects.equals(uuid, wikiPageResource.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiPageResource findByUuid_First(String uuid, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_First(uuid, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchPageResourceException(msg.toString());
    }

    public WikiPageResource fetchByUuid_First(String uuid, OrderByComparator<WikiPageResource> orderByComparator) {
        List<WikiPageResource> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource findByUuid_Last(String uuid, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_Last(uuid, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchPageResourceException(msg.toString());
    }

    public WikiPageResource fetchByUuid_Last(String uuid, OrderByComparator<WikiPageResource> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<WikiPageResource> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource[] findByUuid_PrevAndNext(long resourcePrimKey, String uuid, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.findByPrimaryKey(resourcePrimKey);
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource[] array = new WikiPageResourceImpl[]{this.getByUuid_PrevAndNext(session, wikiPageResource, uuid, orderByComparator, true), wikiPageResource, this.getByUuid_PrevAndNext(session, wikiPageResource, uuid, orderByComparator, false)};
            WikiPageResource[] wikiPageResourceArray = array;
            return wikiPageResourceArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource getByUuid_PrevAndNext(Session session, WikiPageResource wikiPageResource, String uuid, OrderByComparator<WikiPageResource> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiPageResource)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiPageResource)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (WikiPageResource wikiPageResource : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countByUuid(String uuid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiPageResource findByUUID_G(String uuid, long groupId) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUUID_G(uuid, groupId);
        if (wikiPageResource == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchPageResourceException(msg.toString());
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public WikiPageResource fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        WikiPageResource wikiPageResource;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiPageResource && (!Objects.equals(uuid, (wikiPageResource = (WikiPageResource)result).getUuid()) || groupId != wikiPageResource.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiPageResource.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiPageResource.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q2.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)list);
                } else {
                    WikiPageResource wikiPageResource2 = (WikiPageResource)list.get(0);
                    result = wikiPageResource2;
                    this.cacheResult(wikiPageResource2);
                    if (wikiPageResource2.getUuid() == null || !wikiPageResource2.getUuid().equals(uuid) || wikiPageResource2.getGroupId() != groupId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)wikiPageResource2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiPageResource)result;
    }

    public WikiPageResource removeByUUID_G(String uuid, long groupId) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.findByUUID_G(uuid, groupId);
        return (WikiPageResource)this.remove((BaseModel)wikiPageResource);
    }

    public int countByUUID_G(String uuid, long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiPageResource.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiPageResource.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiPageResource> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiPageResource> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<WikiPageResource> list = null;
        if (retrieveFromCache && (list = (List<WikiPageResource>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiPageResource wikiPageResource : list) {
                if (Objects.equals(uuid, wikiPageResource.getUuid()) && companyId == wikiPageResource.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiPageResource.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiPageResource.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiPageResource findByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchPageResourceException(msg.toString());
    }

    public WikiPageResource fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) {
        List<WikiPageResource> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource findByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchPageResourceException(msg.toString());
    }

    public WikiPageResource fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<WikiPageResource> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource[] findByUuid_C_PrevAndNext(long resourcePrimKey, String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.findByPrimaryKey(resourcePrimKey);
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource[] array = new WikiPageResourceImpl[]{this.getByUuid_C_PrevAndNext(session, wikiPageResource, uuid, companyId, orderByComparator, true), wikiPageResource, this.getByUuid_C_PrevAndNext(session, wikiPageResource, uuid, companyId, orderByComparator, false)};
            WikiPageResource[] wikiPageResourceArray = array;
            return wikiPageResourceArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource getByUuid_C_PrevAndNext(Session session, WikiPageResource wikiPageResource, String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append("wikiPageResource.uuid IS NULL AND ");
        } else if (uuid.equals("")) {
            query.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("wikiPageResource.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
        }
        String sql = query.toString();
        Query q2 = session.createQuery(sql);
        q2.setFirstResult(0);
        q2.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q2);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)wikiPageResource)) {
                qPos.add(value);
            }
        }
        if ((list = q2.list()).size() == 2) {
            return (WikiPageResource)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (WikiPageResource wikiPageResource : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("wikiPageResource.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("wikiPageResource.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiPageResource findByN_T(long nodeId, String title2) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByN_T(nodeId, title2);
        if (wikiPageResource == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("nodeId=");
            msg.append(nodeId);
            msg.append(", title=");
            msg.append(title2);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchPageResourceException(msg.toString());
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByN_T(long nodeId, String title2) {
        return this.fetchByN_T(nodeId, title2, true);
    }

    public WikiPageResource fetchByN_T(long nodeId, String title2, boolean retrieveFromCache) {
        WikiPageResource wikiPageResource;
        Object[] finderArgs = new Object[]{nodeId, title2};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_N_T, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiPageResource && (nodeId != (wikiPageResource = (WikiPageResource)result).getNodeId() || !Objects.equals(title2, wikiPageResource.getTitle()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            query.append(_FINDER_COLUMN_N_T_NODEID_2);
            boolean bindTitle = false;
            if (title2 == null) {
                query.append(_FINDER_COLUMN_N_T_TITLE_1);
            } else if (title2.equals("")) {
                query.append(_FINDER_COLUMN_N_T_TITLE_3);
            } else {
                bindTitle = true;
                query.append(_FINDER_COLUMN_N_T_TITLE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(nodeId);
                if (bindTitle) {
                    qPos.add(title2);
                }
                if ((list = q2.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_N_T, finderArgs, (Object)list);
                } else {
                    WikiPageResource wikiPageResource2 = (WikiPageResource)list.get(0);
                    result = wikiPageResource2;
                    this.cacheResult(wikiPageResource2);
                    if (wikiPageResource2.getNodeId() != nodeId || wikiPageResource2.getTitle() == null || !wikiPageResource2.getTitle().equals(title2)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_N_T, finderArgs, (Object)wikiPageResource2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_N_T, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiPageResource)result;
    }

    public WikiPageResource removeByN_T(long nodeId, String title2) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.findByN_T(nodeId, title2);
        return (WikiPageResource)this.remove((BaseModel)wikiPageResource);
    }

    public int countByN_T(long nodeId, String title2) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_N_T;
        Object[] finderArgs = new Object[]{nodeId, title2};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            query.append(_FINDER_COLUMN_N_T_NODEID_2);
            boolean bindTitle = false;
            if (title2 == null) {
                query.append(_FINDER_COLUMN_N_T_TITLE_1);
            } else if (title2.equals("")) {
                query.append(_FINDER_COLUMN_N_T_TITLE_3);
            } else {
                bindTitle = true;
                query.append(_FINDER_COLUMN_N_T_TITLE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q2);
                qPos.add(nodeId);
                if (bindTitle) {
                    qPos.add(title2);
                }
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiPageResourcePersistenceImpl() {
        block2: {
            this.setModelClass(WikiPageResource.class);
            try {
                Field field = ReflectionUtil.getDeclaredField(BasePersistenceImpl.class, (String)"_dbColumnNames");
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("uuid", "uuid_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(WikiPageResource wikiPageResource) {
        this.entityCache.putResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (Serializable)wikiPageResource);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, new Object[]{wikiPageResource.getUuid(), wikiPageResource.getGroupId()}, (Object)wikiPageResource);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_N_T, new Object[]{wikiPageResource.getNodeId(), wikiPageResource.getTitle()}, (Object)wikiPageResource);
        wikiPageResource.resetOriginalValues();
    }

    public void cacheResult(List<WikiPageResource> wikiPageResources) {
        for (WikiPageResource wikiPageResource : wikiPageResources) {
            if (this.entityCache.getResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey())) == null) {
                this.cacheResult(wikiPageResource);
                continue;
            }
            wikiPageResource.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(WikiPageResourceImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(WikiPageResource wikiPageResource) {
        this.entityCache.removeResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((WikiPageResourceModelImpl)wikiPageResource, true);
    }

    public void clearCache(List<WikiPageResource> wikiPageResources) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (WikiPageResource wikiPageResource : wikiPageResources) {
            this.entityCache.removeResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()));
            this.clearUniqueFindersCache((WikiPageResourceModelImpl)wikiPageResource, true);
        }
    }

    protected void cacheUniqueFindersCache(WikiPageResourceModelImpl wikiPageResourceModelImpl) {
        Object[] args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getGroupId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_UUID_G, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, args, (Object)wikiPageResourceModelImpl, false);
        args = new Object[]{wikiPageResourceModelImpl.getNodeId(), wikiPageResourceModelImpl.getTitle()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_N_T, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_N_T, args, (Object)wikiPageResourceModelImpl, false);
    }

    protected void clearUniqueFindersCache(WikiPageResourceModelImpl wikiPageResourceModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        }
        if ((wikiPageResourceModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiPageResourceModelImpl.getOriginalUuid(), wikiPageResourceModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{wikiPageResourceModelImpl.getNodeId(), wikiPageResourceModelImpl.getTitle()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_N_T, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_N_T, args);
        }
        if ((wikiPageResourceModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_N_T.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiPageResourceModelImpl.getOriginalNodeId(), wikiPageResourceModelImpl.getOriginalTitle()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_N_T, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_N_T, args);
        }
    }

    public WikiPageResource create(long resourcePrimKey) {
        WikiPageResourceImpl wikiPageResource = new WikiPageResourceImpl();
        wikiPageResource.setNew(true);
        wikiPageResource.setPrimaryKey(resourcePrimKey);
        String uuid = PortalUUIDUtil.generate();
        wikiPageResource.setUuid(uuid);
        wikiPageResource.setCompanyId(this.companyProvider.getCompanyId());
        return wikiPageResource;
    }

    public WikiPageResource remove(long resourcePrimKey) throws NoSuchPageResourceException {
        return this.remove(Long.valueOf(resourcePrimKey));
    }

    public WikiPageResource remove(Serializable primaryKey) throws NoSuchPageResourceException {
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, primaryKey);
            if (wikiPageResource == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchPageResourceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            WikiPageResource wikiPageResource2 = (WikiPageResource)this.remove((BaseModel)wikiPageResource);
            return wikiPageResource2;
        }
        catch (NoSuchPageResourceException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource removeImpl(WikiPageResource wikiPageResource) {
        wikiPageResource = this.toUnwrappedModel(wikiPageResource);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)wikiPageResource)) {
                wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, wikiPageResource.getPrimaryKeyObj());
            }
            if (wikiPageResource != null) {
                session.delete((Object)wikiPageResource);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (wikiPageResource != null) {
            this.clearCache(wikiPageResource);
        }
        return wikiPageResource;
    }

    public WikiPageResource updateImpl(WikiPageResource wikiPageResource) {
        wikiPageResource = this.toUnwrappedModel(wikiPageResource);
        boolean isNew = wikiPageResource.isNew();
        WikiPageResourceModelImpl wikiPageResourceModelImpl = (WikiPageResourceModelImpl)wikiPageResource;
        if (Validator.isNull((String)wikiPageResource.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            wikiPageResource.setUuid(uuid);
        }
        Session session = null;
        try {
            session = this.openSession();
            if (wikiPageResource.isNew()) {
                session.save((Object)wikiPageResource);
                wikiPageResource.setNew(false);
            } else {
                wikiPageResource = (WikiPageResource)session.merge((Object)wikiPageResource);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!WikiPageResourceModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{wikiPageResourceModelImpl.getUuid()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getCompanyId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((wikiPageResourceModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiPageResourceModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
                args = new Object[]{wikiPageResourceModelImpl.getUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            }
            if ((wikiPageResourceModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiPageResourceModelImpl.getOriginalUuid(), wikiPageResourceModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
                args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            }
        }
        this.entityCache.putResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (Serializable)wikiPageResource, false);
        this.clearUniqueFindersCache(wikiPageResourceModelImpl, false);
        this.cacheUniqueFindersCache(wikiPageResourceModelImpl);
        wikiPageResource.resetOriginalValues();
        return wikiPageResource;
    }

    protected WikiPageResource toUnwrappedModel(WikiPageResource wikiPageResource) {
        if (wikiPageResource instanceof WikiPageResourceImpl) {
            return wikiPageResource;
        }
        WikiPageResourceImpl wikiPageResourceImpl = new WikiPageResourceImpl();
        wikiPageResourceImpl.setNew(wikiPageResource.isNew());
        wikiPageResourceImpl.setPrimaryKey(wikiPageResource.getPrimaryKey());
        wikiPageResourceImpl.setUuid(wikiPageResource.getUuid());
        wikiPageResourceImpl.setResourcePrimKey(wikiPageResource.getResourcePrimKey());
        wikiPageResourceImpl.setGroupId(wikiPageResource.getGroupId());
        wikiPageResourceImpl.setCompanyId(wikiPageResource.getCompanyId());
        wikiPageResourceImpl.setNodeId(wikiPageResource.getNodeId());
        wikiPageResourceImpl.setTitle(wikiPageResource.getTitle());
        return wikiPageResourceImpl;
    }

    public WikiPageResource findByPrimaryKey(Serializable primaryKey) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByPrimaryKey(primaryKey);
        if (wikiPageResource == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchPageResourceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return wikiPageResource;
    }

    public WikiPageResource findByPrimaryKey(long resourcePrimKey) throws NoSuchPageResourceException {
        return this.findByPrimaryKey(Long.valueOf(resourcePrimKey));
    }

    public WikiPageResource fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        WikiPageResource wikiPageResource = (WikiPageResource)serializable;
        if (wikiPageResource == null) {
            Session session = null;
            try {
                session = this.openSession();
                wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, primaryKey);
                if (wikiPageResource != null) {
                    this.cacheResult(wikiPageResource);
                } else {
                    this.entityCache.putResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByPrimaryKey(long resourcePrimKey) {
        return this.fetchByPrimaryKey(Long.valueOf(resourcePrimKey));
    }

    public Map<Serializable, WikiPageResource> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, WikiPageResource> map2 = new HashMap<Serializable, WikiPageResource>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            WikiPageResource wikiPageResource = this.fetchByPrimaryKey(primaryKey);
            if (wikiPageResource != null) {
                map2.put(primaryKey, wikiPageResource);
            }
            return map2;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map2.put(serializable, (WikiPageResource)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map2;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q2 = session.createQuery(string);
            for (WikiPageResource wikiPageResource : q2.list()) {
                map2.put(wikiPageResource.getPrimaryKeyObj(), wikiPageResource);
                this.cacheResult(wikiPageResource);
                uncachedPrimaryKeys.remove(wikiPageResource.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map2;
    }

    public List<WikiPageResource> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<WikiPageResource> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<WikiPageResource> findAll(int start, int end, OrderByComparator<WikiPageResource> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<WikiPageResource> findAll(int start, int end, OrderByComparator<WikiPageResource> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_WIKIPAGERESOURCE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_WIKIPAGERESOURCE;
                if (pagination) {
                    sql = sql.concat(" ORDER BY wikiPageResource.resourcePrimKey ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q2, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (WikiPageResource wikiPageResource : this.findAll()) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q2 = session.createQuery(_SQL_COUNT_WIKIPAGERESOURCE);
                count = (Long)q2.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return WikiPageResourceModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(WikiPageResourceImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

