/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.wiki.asset.WikiNodeTrashRenderer;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.permission.WikiNodePermissionChecker;
import com.liferay.wiki.trash.BaseWikiTrashHandler;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Reference;

@Deprecated
public class WikiNodeTrashHandler
extends BaseWikiTrashHandler {
    @Reference
    private Portal _portal;
    private WikiNodeLocalService _wikiNodeLocalService;
    private WikiPageLocalService _wikiPageLocalService;

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        WikiNode duplicateNode;
        WikiNode node = this._wikiNodeLocalService.getNode(trashEntry.getClassPK());
        String originalTitle = trashEntry.getTypeSettingsProperty("title");
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateNode = this._wikiNodeLocalService.fetchNode(node.getGroupId(), originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateNode.getNodeId());
            ree.setOldName(duplicateNode.getName());
            ree.setTrashEntryId(trashEntry.getEntryId());
            throw ree;
        }
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._wikiNodeLocalService.deleteNode(classPK);
    }

    public String getClassName() {
        return WikiNode.class.getName();
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, false);
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.translate("wiki");
    }

    public String getTrashContainedModelName() {
        return "wiki-pages";
    }

    public int getTrashContainedModelsCount(long classPK) {
        return this._wikiPageLocalService.getPagesCount(classPK, true, 8);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        List pages = this._wikiPageLocalService.getPages(classPK, true, 8, start, end);
        for (WikiPage page : pages) {
            WikiPage redirectPage;
            if (page.isInTrashExplicitly() || (redirectPage = page.getRedirectPage()) != null && redirectPage.isInTrash()) continue;
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)WikiPage.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(page.getResourcePrimKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        return node.getTrashEntry();
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        return this._wikiPageLocalService.getPagesCount(classPK, true, 8);
    }

    public List<TrashRenderer> getTrashModelTrashRenderers(long classPK, int start, int end, OrderByComparator<?> obc) throws PortalException {
        List pages = this._wikiPageLocalService.getPages(classPK, true, 8, start, end, obc);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)WikiPage.class.getName());
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>(pages.size());
        for (WikiPage page : pages) {
            trashRenderers.add(trashHandler.getTrashRenderer(page.getResourcePrimKey()));
        }
        return trashRenderers;
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        return new WikiNodeTrashRenderer(node);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        return node.isInTrash();
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        this._wikiNodeLocalService.restoreNodeFromTrash(userId, node);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        node.setName(name);
        this._wikiNodeLocalService.updateWikiNode(node);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean containerModel) throws PortalException {
        Object portletURL = null;
        WikiNode node = this._wikiNodeLocalService.getNode(classPK);
        long plid = this._portal.getPlidFromPortletId(node.getGroupId(), "com_liferay_wiki_web_portlet_WikiPortlet");
        portletURL = plid == 0L ? this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE") : PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"com_liferay_wiki_web_portlet_WikiPortlet", (long)plid, (String)"RENDER_PHASE");
        if (!containerModel) {
            portletURL.setParameter("mvcRenderCommandName", "/wiki/view_pages");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return WikiNodePermissionChecker.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

