/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.util;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.impl.WikiEngineRenderer;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletURL;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WikiCacheHelper.class})
public class WikiCacheHelper {
    private static final String _CACHE_NAME = WikiCacheHelper.class.getName();
    private static final String _OUTGOING_LINKS = "OUTGOING_LINKS";
    private static final Log _log = LogFactoryUtil.getLog(WikiCacheHelper.class);
    private MultiVMPool _multiVMPool;
    private PortalCache<String, Serializable> _portalCache;

    public void clearCache(long nodeId) {
        this._portalCache.removeAll();
    }

    public void clearCache(long nodeId, String title2) {
        this.clearCache(nodeId);
    }

    public WikiPageDisplay getDisplay(long nodeId, String title2, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String key = this._encodeKey(nodeId, title2, viewPageURL.toString());
        WikiPageDisplay pageDisplay = (WikiPageDisplay)this._portalCache.get((Serializable)((Object)key));
        if (pageDisplay == null && (pageDisplay = this._getPageDisplay(nodeId, title2, viewPageURL, editPageURL, attachmentURLPrefix)) != null) {
            this._portalCache.put((Serializable)((Object)key), (Object)pageDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + nodeId + ", " + title2 + ", " + viewPageURL + ", " + editPageURL + "} takes " + stopWatch.getTime() + " ms"));
        }
        return pageDisplay;
    }

    public Map<String, Boolean> getOutgoingLinks(WikiPage page, WikiEngineRenderer wikiEngineRenderer) throws PageContentException {
        String key = this._encodeKey(page.getNodeId(), page.getTitle(), _OUTGOING_LINKS);
        Map links = (Map)this._portalCache.get((Serializable)((Object)key));
        if (links == null) {
            WikiEngine wikiEngine = wikiEngineRenderer.fetchWikiEngine(page.getFormat());
            links = wikiEngine != null ? wikiEngine.getOutgoingLinks(page) : Collections.emptyMap();
            this._portalCache.put((Serializable)((Object)key), (Object)((Serializable)((Object)links)));
        }
        return links;
    }

    @Activate
    protected void activate() {
        this._portalCache = this._multiVMPool.getPortalCache(_CACHE_NAME);
        this._portalCache.removeAll();
    }

    @Deactivate
    protected void deactivate() {
        this._portalCache.removeAll();
        this._multiVMPool.removePortalCache(_CACHE_NAME);
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private String _encodeKey(long nodeId, String title2, String postfix) {
        StringBundler sb = new StringBundler(6);
        sb.append(_CACHE_NAME);
        sb.append("#");
        sb.append(StringUtil.toHexString((long)nodeId));
        sb.append(title2);
        if (postfix != null) {
            sb.append("#");
            sb.append(postfix);
        }
        return sb.toString();
    }

    private WikiPageDisplay _getPageDisplay(long nodeId, String title2, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get page display for {" + nodeId + ", " + title2 + ", " + viewPageURL + ", " + editPageURL + "}"));
            }
            return WikiPageLocalServiceUtil.getPageDisplay((long)nodeId, (String)title2, (PortletURL)viewPageURL, (PortletURL)editPageURL, (String)attachmentURLPrefix);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get page display for {" + nodeId + ", " + title2 + ", " + viewPageURL + ", " + editPageURL + "}"));
            }
            return null;
        }
    }
}

