/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.util;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.impl.WikiEngineRenderer;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletURL;
import org.apache.commons.lang.time.StopWatch;

@Deprecated
public class WikiCacheUtil {
    private static final String _CACHE_NAME = WikiCacheUtil.class.getName();
    private static final String _OUTGOING_LINKS = "OUTGOING_LINKS";
    private static final Log _log = LogFactoryUtil.getLog(WikiCacheUtil.class);
    private static final PortalCache<String, Serializable> _portalCache = MultiVMPoolUtil.getPortalCache((String)_CACHE_NAME);

    public static void clearCache(long nodeId) {
        _portalCache.removeAll();
    }

    public static void clearCache(long nodeId, String title2) {
        WikiCacheUtil.clearCache(nodeId);
    }

    public static WikiPageDisplay getDisplay(long nodeId, String title2, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String key = WikiCacheUtil._encodeKey(nodeId, title2, viewPageURL.toString());
        WikiPageDisplay pageDisplay = (WikiPageDisplay)_portalCache.get((Serializable)((Object)key));
        if (pageDisplay == null && (pageDisplay = WikiCacheUtil._getPageDisplay(nodeId, title2, viewPageURL, editPageURL, attachmentURLPrefix)) != null) {
            _portalCache.put((Serializable)((Object)key), (Object)pageDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + nodeId + ", " + title2 + ", " + viewPageURL + ", " + editPageURL + "} takes " + stopWatch.getTime() + " ms"));
        }
        return pageDisplay;
    }

    public static Map<String, Boolean> getOutgoingLinks(WikiPage page, WikiEngineRenderer wikiEngineRenderer) throws PageContentException {
        String key = WikiCacheUtil._encodeKey(page.getNodeId(), page.getTitle(), _OUTGOING_LINKS);
        Map links = (Map)_portalCache.get((Serializable)((Object)key));
        if (links == null) {
            WikiEngine wikiEngine = wikiEngineRenderer.fetchWikiEngine(page.getFormat());
            links = wikiEngine != null ? wikiEngine.getOutgoingLinks(page) : Collections.emptyMap();
            _portalCache.put((Serializable)((Object)key), (Object)((Serializable)((Object)links)));
        }
        return links;
    }

    private static String _encodeKey(long nodeId, String title2, String postfix) {
        StringBundler sb = new StringBundler(6);
        sb.append(_CACHE_NAME);
        sb.append("#");
        sb.append(StringUtil.toHexString((long)nodeId));
        sb.append(title2);
        if (postfix != null) {
            sb.append("#");
            sb.append(postfix);
        }
        return sb.toString();
    }

    private static WikiPageDisplay _getPageDisplay(long nodeId, String title2, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get page display for {" + nodeId + ", " + title2 + ", " + viewPageURL + ", " + editPageURL + "}"));
            }
            return WikiPageLocalServiceUtil.getPageDisplay((long)nodeId, (String)title2, (PortletURL)viewPageURL, (PortletURL)editPageURL, (String)attachmentURLPrefix);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get page display for {" + nodeId + ", " + title2 + ", " + viewPageURL + ", " + editPageURL + "}"));
            }
            return null;
        }
    }

    static {
        _portalCache.removeAll();
    }
}

