/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.util;

import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.service.permission.WikiNodePermissionChecker;
import com.liferay.wiki.util.comparator.PageVersionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WikiUtil {
    public static String getAttachmentURLPrefix(String mainPath, long plid, long nodeId, String title2) {
        StringBundler sb = new StringBundler(8);
        sb.append(mainPath);
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(plid);
        sb.append("&nodeId=");
        sb.append(nodeId);
        sb.append("&title=");
        sb.append(URLCodec.encodeURL((String)title2));
        sb.append("&fileName=");
        return sb.toString();
    }

    public static DiffVersionsInfo getDiffVersionsInfo(long nodeId, String title2, double sourceVersion, double targetVersion, HttpServletRequest request) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List pages = WikiPageLocalServiceUtil.getPages((long)nodeId, (String)title2, (int)-1, (int)-1, (OrderByComparator)new PageVersionComparator(true));
        for (WikiPage page : pages) {
            if (page.getVersion() < sourceVersion && page.getVersion() > previousVersion) {
                previousVersion = page.getVersion();
            }
            if (!(page.getVersion() > targetVersion) || !(page.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = page.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (WikiPage page : pages) {
            String extraInfo = "";
            if (page.isMinorEdit()) {
                extraInfo = LanguageUtil.get((HttpServletRequest)request, (String)"minor-edit");
            }
            DiffVersion diffVersion = new DiffVersion(page.getUserId(), page.getVersion(), page.getModifiedDate(), page.getSummary(), extraInfo);
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public static List<String> getNodeNames(List<WikiNode> nodes) {
        ArrayList<String> nodeNames = new ArrayList<String>(nodes.size());
        for (WikiNode node : nodes) {
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    public static List<WikiNode> getNodes(List<WikiNode> nodes, String[] hiddenNodes, PermissionChecker permissionChecker) {
        nodes = ListUtil.copy(nodes);
        Arrays.sort(hiddenNodes);
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            WikiNode node = (WikiNode)itr.next();
            if (Arrays.binarySearch(hiddenNodes, node.getName()) < 0 && WikiNodePermissionChecker.contains(permissionChecker, node, "VIEW")) continue;
            itr.remove();
        }
        return nodes;
    }

    public static List<WikiNode> orderNodes(List<WikiNode> nodes, String[] visibleNodeNames) {
        if (ArrayUtil.isEmpty((Object[])visibleNodeNames)) {
            return nodes;
        }
        nodes = ListUtil.copy(nodes);
        ArrayList<WikiNode> orderedNodes = new ArrayList<WikiNode>(nodes.size());
        block0: for (String visibleNodeName : visibleNodeNames) {
            for (WikiNode node : nodes) {
                if (!node.getName().equals(visibleNodeName)) continue;
                orderedNodes.add(node);
                nodes.remove(node);
                continue block0;
            }
        }
        orderedNodes.addAll(nodes);
        return orderedNodes;
    }

    public static String processContent(String content) {
        content = StringUtil.replace((String)content, (String)"</p>", (String)"</p>\n");
        content = StringUtil.replace((String)content, (String)"</br>", (String)"</br>\n");
        content = StringUtil.replace((String)content, (String)"</div>", (String)"</div>\n");
        return content;
    }
}

