/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.HTMLElementTerminatingTagNameSets;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;

    StartTag(Source source, int n, int n2, StartTagType startTagType, String string, Attributes attributes) {
        super(source, n, n2, string);
        this.attributes = attributes;
        this.startTagType = startTagType;
    }

    StartTag() {
        this.attributes = null;
        this.startTagType = null;
    }

    @Override
    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag = this.getEndTagInternal();
            this.element = new Element(this.source, this, endTag);
            if (endTag != null) {
                if (endTag.element != Element.NOT_CACHED && this.source.logger.isInfoEnabled() && !this.element.equals(endTag.element)) {
                    this.source.logger.info(this.source.getRowColumnVector(endTag.begin).appendTo(new StringBuilder(200).append("End tag ").append(endTag).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.isSyntacticalEmptyElementTag() && !HTMLElements.isClosingSlashIgnored(this.name);
    }

    public boolean isSyntacticalEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    @Override
    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string) {
        return this.attributes == null ? null : this.attributes.getValue(string);
    }

    @Override
    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int n2 = this.end - this.startTagType.getClosingDelimiter().length();
        int n3 = this.begin + 1 + this.name.length();
        while (!StartTag.isXMLNameStartChar(this.source.charAt(n3))) {
            if (++n3 != n2) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, n3, n2, this.startTagType, this.name, n);
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isSyntacticalEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isSyntacticalEmptyElementTag();
    }

    @Override
    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean bl) {
        if (this.attributes == null || this.attributes.containsServerTagOutsideOfAttributeValue) {
            return this.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        if (bl && this.startTagType == StartTagType.NORMAL) {
            stringBuilder.append(this.name);
        } else {
            int n;
            int n2 = n + this.name.length();
            for (n = this.begin + this.startTagType.startDelimiterPrefix.length(); n < n2; ++n) {
                stringBuilder.append(this.source.charAt(n));
            }
        }
        try {
            this.attributes.appendTidy(stringBuilder, this.getNextTag());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            stringBuilder.append(" /");
        }
        stringBuilder.append(this.startTagType.getClosingDelimiter());
        return stringBuilder.toString();
    }

    public static String generateHTML(String string, Map<String, String> map2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(string);
        try {
            Attributes.appendHTML(stringBuilder, map2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (bl) {
            stringBuilder.append(" />");
        } else {
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendDebugTag(stringBuilder);
        stringBuilder.append(' ');
        this.appendDebugTagType(stringBuilder);
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    StringBuilder appendDebugTag(StringBuilder stringBuilder) {
        if (this.startTagType == StartTagType.NORMAL && this.getAttributes().isEmpty()) {
            stringBuilder.append(this);
        } else {
            stringBuilder.append('<').append(this.getNameSegment()).append(' ');
            if (this.isSyntacticalEmptyElementTag()) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.startTagType.getClosingDelimiter());
        }
        return stringBuilder;
    }

    StringBuilder appendDebugTagType(StringBuilder stringBuilder) {
        if (this.startTagType != StartTagType.NORMAL) {
            stringBuilder.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return stringBuilder;
    }

    private EndTag getEndTagInternal() {
        Object object2;
        boolean bl = true;
        EndTagType endTagType = this.startTagType.getCorrespondingEndTagType();
        if (this.startTagType == StartTagType.NORMAL) {
            object2 = HTMLElements.getTerminatingTagNameSets(this.name);
            if (object2 != null) {
                return this.getOptionalEndTag((HTMLElementTerminatingTagNameSets)object2);
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            boolean bl2 = bl = !HTMLElements.getEndTagRequiredElementNames().contains(this.name);
            if (bl && this.isSyntacticalEmptyElementTag()) {
                return null;
            }
        } else if (endTagType == null) {
            return null;
        }
        if ((object2 = this.source.getNextEndTag(this.end, endTagType.getEndTagName(this.name), endTagType)) != null) {
            if (this.startTagType == StartTagType.NORMAL && HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag startTag = this.source.getNextStartTag(this.end, this.name);
                if (startTag == null || startTag.begin > ((EndTag)object2).begin) {
                    return object2;
                }
                if (this.source.logger.isInfoEnabled()) {
                    this.source.logger.info(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, startTag.begin, startTag.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] segmentArray = this.getEndTag((EndTag)object2, bl, Tag.isXMLName(this.name));
            if (segmentArray != null) {
                return (EndTag)segmentArray[0];
            }
        }
        if (this.source.logger.isInfoEnabled()) {
            this.source.logger.info(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag getOptionalEndTag(HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets) {
        Tag tag;
        int n = this.end;
        while (n < this.source.end && (tag = Tag.getNextTag(this.source, n)) != null) {
            Set<String> set;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                set = hTMLElementTerminatingTagNameSets.NonterminatingElementNameSet;
                if (set != null && set.contains(tag.name)) {
                    Element element = ((StartTag)tag).getElement();
                    n = element.end;
                    continue;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (set != null && set.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            n = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static String getStartDelimiter(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        String string2 = "<" + string;
        if (string2.charAt("<".length()) == '/') {
            throw new IllegalArgumentException("searchName argument \"" + string + "\" must not start with '/'");
        }
        return string2;
    }

    static StartTag getPrevious(Source source, int n, String string, StartTagType startTagType) {
        return StartTag.getPrevious(source, n, string, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string) : true);
    }

    static StartTag getPrevious(Source source, int n, String string, StartTagType startTagType, boolean bl) {
        if (string == null) {
            return (StartTag)source.getPreviousTag(n, startTagType);
        }
        String string2 = StartTag.getStartDelimiter(string);
        ParseText parseText = source.getParseText();
        int n2 = n;
        do {
            char c;
            if ((n2 = parseText.lastIndexOf(string2, n2)) == -1) {
                return null;
            }
            StartTag startTag = (StartTag)Tag.getTagAt(source, n2, false);
            if (startTag == null || startTagType != startTag.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag.isUnregistered()) || startTag.getStartTagType().isNameAfterPrefixRequired() && startTag.getName().length() > string.length() && (c = string.charAt(string.length() - 1)) != ':' && StartTag.isXMLNameChar(c)) continue;
            return startTag;
        } while ((n2 -= 2) >= 0);
        return null;
    }

    static StartTag getNext(Source source, int n, String string, StartTagType startTagType) {
        return StartTag.getNext(source, n, string, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string) : true);
    }

    static StartTag getNext(Source source, int n, String string, StartTagType startTagType, boolean bl) {
        if (string == null) {
            return (StartTag)source.getNextTag(n, startTagType);
        }
        String string2 = StartTag.getStartDelimiter(string);
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            do {
                char c;
                if ((n2 = parseText.indexOf(string2, n2)) == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, n2, false);
                if (startTag == null || startTagType != startTag.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag.isUnregistered()) || startTag.getStartTagType().isNameAfterPrefixRequired() && startTag.getName().length() > string.length() && (c = string.charAt(string.length() - 1)) != ':' && StartTag.isXMLNameChar(c)) continue;
                return startTag;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static StartTag getPrevious(Source source, int n) {
        Tag tag = Tag.getPreviousTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getPreviousStartTag();
    }

    static StartTag getNext(Source source, int n) {
        Tag tag = Tag.getNextTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getNextStartTag();
    }

    static StartTag getNext(Source source, int n, String string, String string2, boolean bl) {
        if (string2 == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        String string3 = string2.length() >= 3 || string2.length() > 0 && string.length() < 3 ? string2 : string;
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            String string4;
            StartTag startTag;
            n2 = parseText.indexOf(string3.toLowerCase(), n2);
            if (n2 == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag = (StartTag)tag).getAttributes() != null && (string4 = startTag.getAttributes().getValue(string)) != null) {
                if (string2.equals(string4)) {
                    return startTag;
                }
                if (string2.equalsIgnoreCase(string4)) {
                    if (!bl) {
                        return startTag;
                    }
                    if (source.logger.isInfoEnabled()) {
                        source.logger.info(source.getRowColumnVector(n2).appendTo(new StringBuilder(200)).append(": StartTag with attribute ").append(string).append("=\"").append(string4).append("\" ignored during search because its case does not match search value \"").append(string2).append('\"').toString());
                    }
                }
            }
            n2 = tag.end;
        }
        return null;
    }

    static StartTag getNext(Source source, int n, String string, Pattern pattern) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        String string2 = string;
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            Attribute attribute;
            StartTag startTag;
            n2 = parseText.indexOf(string2.toLowerCase(), n2);
            if (n2 == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag = (StartTag)tag).getAttributes() != null && (attribute = startTag.getAttributes().get(string)) != null) {
                if (pattern == null) {
                    return startTag;
                }
                String string3 = attribute.getValue();
                if (string3 != null && pattern.matcher(string3).matches()) {
                    return startTag;
                }
            }
            n2 = tag.end;
        }
        return null;
    }

    private Segment[] getEndTag(EndTag endTag, boolean bl, boolean bl2) {
        assert (endTag != null);
        StartTag startTag = StartTag.getNext(this.source, this.end, this.name, this.startTagType, bl2);
        if (bl) {
            while (startTag != null && startTag.isSyntacticalEmptyElementTag()) {
                startTag = StartTag.getNext(this.source, startTag.end, this.name, this.startTagType, bl2);
            }
        }
        return this.getEndTag(this.end, startTag, endTag, bl, bl2);
    }

    private Segment[] getEndTag(int n, StartTag startTag, EndTag endTag, boolean bl, boolean bl2) {
        if (endTag == null) {
            return null;
        }
        Segment[] segmentArray = new Segment[]{endTag, startTag};
        if (startTag == null || startTag.begin > endTag.begin) {
            return segmentArray;
        }
        Segment[] segmentArray2 = startTag.getEndTag(endTag, bl, bl2);
        if (segmentArray2 == null) {
            return null;
        }
        EndTag endTag2 = (EndTag)segmentArray2[0];
        EndTag endTag3 = EndTag.getNext(this.source, endTag2.end, endTag.getName(), endTag.getEndTagType());
        return this.getEndTag(endTag2.end, (StartTag)segmentArray2[1], endTag3, bl, bl2);
    }
}

