/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;

public class SimpleDiff
implements DiffAlgorithm {
    static final int NOT_FOUND_i = -2;
    static final int NOT_FOUND_j = -1;
    static final int EOS = Integer.MAX_VALUE;

    protected int scan(int[] ndx, int i2, int target) {
        while (ndx[i2] < target) {
            ++i2;
        }
        return i2;
    }

    public Revision diff(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        Map eqs = this.buildEqSet(orig, rev);
        int[] indx = this.buildIndex(eqs, orig, -2);
        int[] jndx = this.buildIndex(eqs, rev, -1);
        eqs = null;
        Revision deltas = new Revision();
        int i2 = 0;
        int j = 0;
        while (indx[i2] != Integer.MAX_VALUE && indx[i2] == jndx[j]) {
            ++i2;
            ++j;
        }
        while (indx[i2] != jndx[j]) {
            int ia = i2;
            int ja = j;
            while (true) {
                if (jndx[j] < 0 || jndx[j] < indx[i2]) {
                    ++j;
                    continue;
                }
                while (indx[i2] < 0 || indx[i2] < jndx[j]) {
                    ++i2;
                }
                if (indx[i2] == jndx[j]) break;
            }
            while (i2 > ia && j > ja && indx[i2 - 1] == jndx[j - 1]) {
                --i2;
                --j;
            }
            deltas.addDelta(Delta.newDelta(new Chunk(orig, ia, i2 - ia), new Chunk(rev, ja, j - ja)));
            while (indx[i2] != Integer.MAX_VALUE && indx[i2] == jndx[j]) {
                ++i2;
                ++j;
            }
        }
        return deltas;
    }

    protected Map buildEqSet(Object[] orig, Object[] rev) {
        HashSet<Object> items = new HashSet<Object>(Arrays.asList(orig));
        items.retainAll(Arrays.asList(rev));
        HashMap<Object, Integer> eqs = new HashMap<Object, Integer>();
        for (int i2 = 0; i2 < orig.length; ++i2) {
            if (!items.contains(orig[i2])) continue;
            eqs.put(orig[i2], new Integer(i2));
            items.remove(orig[i2]);
        }
        return eqs;
    }

    protected int[] buildIndex(Map eqs, Object[] seq, int NF) {
        int[] result = new int[seq.length + 1];
        for (int i2 = 0; i2 < seq.length; ++i2) {
            Integer value = (Integer)eqs.get(seq[i2]);
            result[i2] = value == null || value < 0 ? NF : value;
        }
        result[seq.length] = Integer.MAX_VALUE;
        return result;
    }
}

