/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.asset.validator;

import com.liferay.asset.kernel.validator.AssetEntryValidatorExclusionRule;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.wiki.configuration.WikiGroupServiceConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"model.class.name=com.liferay.wiki.model.WikiPage"}, service={AssetEntryValidatorExclusionRule.class})
public class FrontPageAssetEntryValidatorExclusionRule
implements AssetEntryValidatorExclusionRule {
    private static final Log _log = LogFactoryUtil.getLog(FrontPageAssetEntryValidatorExclusionRule.class);
    private WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    @Reference(unbind="-")
    private WikiPageLocalService _wikiPageLocalService;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        this._wikiGroupServiceConfiguration = (WikiGroupServiceConfiguration)ConfigurableUtil.createConfigurable(WikiGroupServiceConfiguration.class, properties);
    }

    public boolean isValidationExcluded(long groupId, String className, long classPK, long classTypePK, long[] categoryIds, String[] tagNames) {
        WikiPage wikiPage = this._wikiPageLocalService.fetchWikiPage(classPK);
        if (wikiPage == null) {
            wikiPage = this._wikiPageLocalService.fetchPage(classPK);
        }
        if (wikiPage == null) {
            try {
                wikiPage = this._wikiPageLocalService.getPage(classPK, Boolean.valueOf(false));
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)portalException, (Throwable)portalException);
                }
                return false;
            }
        }
        return StringUtil.equals((String)wikiPage.getTitle(), (String)this._wikiGroupServiceConfiguration.frontPageName()) && wikiPage.getVersion() == 1.0;
    }
}

