/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.WikiFormatException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.service.WikiPageLocalService;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"related.entry.indexer.class.name=com.liferay.wiki.model.WikiPage"}, service={Indexer.class, RelatedEntryIndexer.class})
public class WikiPageIndexer
extends BaseIndexer<WikiPage>
implements RelatedEntryIndexer {
    public static final String CLASS_NAME = WikiPage.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(WikiPageIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    private final RelatedEntryIndexer _relatedEntryIndexer = new BaseRelatedEntryIndexer();
    @Reference
    private TrashHelper _trashHelper;
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiNodeLocalService _wikiNodeLocalService;
    private WikiNodeService _wikiNodeService;
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;

    public WikiPageIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "content", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedClassNames(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this._relatedEntryIndexer.addRelatedClassNames(contextBooleanFilter, searchContext);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        long classPK = 0L;
        if (obj instanceof Comment) {
            Comment comment2 = (Comment)obj;
            classPK = comment2.getClassPK();
        } else if (obj instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)obj;
            RelatedModelCapability relatedModelCapability = (RelatedModelCapability)fileEntry.getRepositoryCapability(RelatedModelCapability.class);
            classPK = relatedModelCapability.getClassPK(fileEntry);
        }
        WikiPage page = null;
        try {
            page = this._wikiPageLocalService.getPage(classPK);
        }
        catch (Exception exception) {
            return;
        }
        document.addKeyword("nodeId", page.getNodeId());
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._wikiPageModelResourcePermission.contains(permissionChecker, (ClassedModel)this._wikiPageLocalService.getPage(entryClassPK), "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        WikiPage page = this._wikiPageLocalService.getPage(classPK);
        return this.isVisible(page.getStatus(), status);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
        long[] nodeIds = searchContext.getNodeIds();
        if (ArrayUtil.isNotEmpty((long[])nodeIds)) {
            TermsFilter nodesIdTermsFilter = new TermsFilter("nodeId");
            for (long nodeId : nodeIds) {
                try {
                    this._wikiNodeService.getNode(nodeId);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get wiki node " + nodeId), (Throwable)exception);
                    continue;
                }
                nodesIdTermsFilter.addValue(String.valueOf(nodeId));
            }
            if (!nodesIdTermsFilter.isEmpty()) {
                contextBooleanFilter.add((Filter)nodesIdTermsFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
    }

    public void updateFullQuery(SearchContext searchContext) {
    }

    protected void doDelete(WikiPage wikiPage) throws Exception {
        this.deleteDocument(wikiPage.getCompanyId(), wikiPage.getResourcePrimKey());
    }

    protected Document doGetDocument(WikiPage wikiPage) throws Exception {
        String content;
        Document document;
        block4: {
            document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)wikiPage);
            content = null;
            try {
                content = HtmlUtil.extractText((String)this._wikiEngineRenderer.convert(wikiPage, null, null, null));
                document.addText("content", content);
            }
            catch (WikiFormatException wikiFormatException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("Unable to get wiki engine for " + wikiPage.getFormat()));
            }
        }
        document.addKeyword("nodeId", wikiPage.getNodeId());
        String title2 = wikiPage.getTitle();
        if (wikiPage.isInTrash()) {
            title2 = this._trashHelper.getOriginalTitle(title2);
        }
        document.addText("title", title2);
        for (Locale locale : LanguageUtil.getAvailableLocales((long)wikiPage.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(LocalizationUtil.getLocalizedName((String)"content", (String)languageId), content);
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), title2);
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        String content = LocalizationUtil.getLocalizedName((String)"content", (String)languageId);
        String title2 = LocalizationUtil.getLocalizedName((String)"title", (String)languageId);
        Summary summary = this.createSummary(document, title2, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage page = this._wikiPageLocalService.fetchWikiPage(classPK);
        if (page == null) {
            page = this._wikiPageLocalService.getPage(classPK, (Boolean)null);
        }
        this.doReindex(page);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexNodes(companyId);
    }

    protected void doReindex(WikiPage wikiPage) throws Exception {
        if (!wikiPage.isHead() || !wikiPage.isApproved() && !wikiPage.isInTrash()) {
            return;
        }
        if (Validator.isNotNull((String)wikiPage.getRedirectTitle())) {
            return;
        }
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), wikiPage.getCompanyId(), this.getDocument(wikiPage), this.isCommitImmediately());
        this.reindexAttachments(wikiPage);
    }

    protected void reindexAttachments(WikiPage wikiPage) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        for (FileEntry attachmentsFileEntry : wikiPage.getAttachmentsFileEntries()) {
            indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
        }
    }

    protected void reindexNodes(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._wikiNodeLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(node -> this.reindexPages(companyId, node.getGroupId(), node.getNodeId()));
        actionableDynamicQuery.performActions();
    }

    protected void reindexPages(long companyId, long groupId, long nodeId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._wikiPageLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nodeIdProperty = PropertyFactoryUtil.forName((String)"nodeId");
            dynamicQuery.add(nodeIdProperty.eq((Object)nodeId));
            Property headProperty = PropertyFactoryUtil.forName((String)"head");
            dynamicQuery.add(headProperty.eq((Object)true));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod(page -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(page)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index wiki page " + page.getPageId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setWikiEngineRenderer(WikiEngineRenderer wikiEngineRenderer) {
        this._wikiEngineRenderer = wikiEngineRenderer;
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

