/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeService;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.wiki.model.WikiPage"}, service={BaseSearcher.class})
public class WikiPageTitleSearcher
extends BaseSearcher {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(WikiPageTitleSearcher.class);
    private WikiNodeService _wikiNodeService;

    public WikiPageTitleSearcher() {
        this.setDefaultSelectedFieldNames(new String[]{"title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getSearchClassNames() {
        return CLASS_NAMES;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
        long[] nodeIds = searchContext.getNodeIds();
        if (ArrayUtil.isNotEmpty((long[])nodeIds)) {
            TermsFilter nodesIdTermsFilter = new TermsFilter("nodeId");
            for (long nodeId : nodeIds) {
                try {
                    this._wikiNodeService.getNode(nodeId);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get wiki node " + nodeId), (Throwable)exception);
                    continue;
                }
                nodesIdTermsFilter.addValue(String.valueOf(nodeId));
            }
            if (!nodesIdTermsFilter.isEmpty()) {
                contextBooleanFilter.add((Filter)nodesIdTermsFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        MatchQuery matchQuery = new MatchQuery("title", StringUtil.toLowerCase((String)searchContext.getKeywords()));
        matchQuery.setType(MatchQuery.Type.PHRASE_PREFIX);
        searchQuery.add((Query)matchQuery, BooleanClauseOccur.MUST);
    }

    protected Map<String, Query> addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        return Collections.emptyMap();
    }

    @Reference(unbind="-")
    protected void setWikiNodeService(WikiNodeService wikiNodeService) {
        this._wikiNodeService = wikiNodeService;
    }
}

