/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.DateOverrideIncrement;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.util.LayoutURLUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import com.liferay.wiki.configuration.WikiFileUploadConfiguration;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.escape.WikiEscapeUtil;
import com.liferay.wiki.exception.DuplicatePageException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.exception.PageTitleException;
import com.liferay.wiki.exception.PageVersionException;
import com.liferay.wiki.exception.WikiAttachmentMimeTypeException;
import com.liferay.wiki.internal.util.WikiCacheThreadLocal;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.model.impl.WikiPageDisplayImpl;
import com.liferay.wiki.model.impl.WikiPageImpl;
import com.liferay.wiki.processor.WikiPageRenameContentProcessor;
import com.liferay.wiki.service.WikiPageResourceLocalService;
import com.liferay.wiki.service.base.WikiPageLocalServiceBaseImpl;
import com.liferay.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.wiki.util.comparator.PageVersionComparator;
import com.liferay.wiki.validator.WikiPageTitleValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.wiki.configuration.WikiFileUploadConfiguration"}, property={"model.class.name=com.liferay.wiki.model.WikiPage"}, service={AopService.class})
public class WikiPageLocalServiceImpl
extends WikiPageLocalServiceBaseImpl {
    private static final String _OUTGOING_LINKS = "OUTGOING_LINKS";
    private static final Log _log = LogFactoryUtil.getLog(WikiPageLocalServiceImpl.class);
    @Reference
    private CommentManager _commentManager;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private MimeTypes _mimeTypes;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private Portal _portal;
    private PortalCache<String, Serializable> _portalCache;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private PortletURLFactory _portletURLFactory;
    private ServiceTrackerMap<String, WikiPageRenameContentProcessor> _serviceTrackerMap;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private WikiEngineRenderer _wikiEngineRenderer;
    private WikiFileUploadConfiguration _wikiFileUploadConfiguration;
    @Reference
    private WikiPageResourceLocalService _wikiPageResourceLocalService;
    @Reference
    private WikiPageTitleValidator _wikiPageTitleValidator;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, WikiPageRenameContentProcessor.class, (String)"wiki.format.name");
        this._portalCache = this._multiVMPool.getPortalCache(WikiPageDisplay.class.getName());
        this._wikiFileUploadConfiguration = (WikiFileUploadConfiguration)ConfigurableUtil.createConfigurable(WikiFileUploadConfiguration.class, properties);
    }

    public WikiPage addPage(long userId, long nodeId, String title2, double version, String content, String summary, boolean minorEdit, String format, boolean head2, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        Date now = new Date();
        long pageId = this.counterLocalService.increment();
        content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)node.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)pageId, (String)("text/" + format), (String)content);
        title2 = StringUtil.replace((String)title2, (char)'\u00a0', (char)' ');
        this._validate(title2, nodeId, content, format);
        long resourcePrimKey = this._wikiPageResourceLocalService.getPageResourcePrimKey(node.getGroupId(), nodeId, title2);
        WikiPage page = this.wikiPagePersistence.create(pageId);
        page.setUuid(serviceContext.getUuid());
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(node.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setNodeId(nodeId);
        page.setTitle(title2);
        page.setVersion(version);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        page.setSummary(summary);
        page.setFormat(format);
        page.setHead(head2);
        page.setParentTitle(parentTitle);
        page.setRedirectTitle(redirectTitle);
        page.setStatus(2);
        page.setStatusByUserId(userId);
        page.setStatusDate(serviceContext.getModifiedDate(now));
        page.setExpandoBridgeAttributes(serviceContext);
        page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addPageResources(page, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addPageResources(page, serviceContext.getModelPermissions());
        }
        this.wikiPageLocalService.updateLastPostDate(node.getNodeId(), serviceContext.getModifiedDate(now));
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return this._startWorkflowInstance(userId, page, serviceContext);
    }

    public WikiPage addPage(long userId, long nodeId, String title2, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException {
        double version = 1.0;
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = (WikiGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(WikiGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(node.getGroupId(), "com.liferay.wiki"));
        String format = wikiGroupServiceOverriddenConfiguration.defaultFormat();
        boolean head2 = false;
        String parentTitle = null;
        String redirectTitle = null;
        return this.addPage(userId, nodeId, title2, version, content, summary, minorEdit, format, head2, parentTitle, redirectTitle, serviceContext);
    }

    public FileEntry addPageAttachment(long userId, long nodeId, String title2, String fileName, File file, String mimeType) throws PortalException {
        List wikiAttachmentMimeTypes = ListUtil.fromArray((Object[])this._wikiFileUploadConfiguration.attachmentMimeTypes());
        if (ListUtil.isNull((List)wikiAttachmentMimeTypes) || !wikiAttachmentMimeTypes.contains("*") && !wikiAttachmentMimeTypes.contains(mimeType)) {
            throw new WikiAttachmentMimeTypeException();
        }
        WikiPage page = this.getPage(nodeId, title2);
        Folder folder = page.addAttachmentsFolder();
        fileName = this._portletFileRepository.getUniqueFileName(page.getGroupId(), folder.getFolderId(), fileName);
        FileEntry fileEntry = this._portletFileRepository.addPortletFileEntry(page.getGroupId(), userId, WikiPage.class.getName(), page.getResourcePrimKey(), "com.liferay.wiki", folder.getFolderId(), file, fileName, mimeType, true);
        if (userId == 0L) {
            userId = page.getUserId();
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"fileEntryId", (Object)fileEntry.getFileEntryId()).put("fileEntryTitle", fileEntry.getTitle()).put("title", page.getTitle()).put("version", page.getVersion());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)10006, (String)extraDataJSONObject.toString(), (long)0L);
        return fileEntry;
    }

    public FileEntry addPageAttachment(long userId, long nodeId, String title2, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        Folder folder = page.addAttachmentsFolder();
        fileName = this._portletFileRepository.getUniqueFileName(page.getGroupId(), folder.getFolderId(), fileName);
        FileEntry fileEntry = this._portletFileRepository.addPortletFileEntry(page.getGroupId(), userId, WikiPage.class.getName(), page.getResourcePrimKey(), "com.liferay.wiki", folder.getFolderId(), inputStream, fileName, mimeType, true);
        if (userId == 0L) {
            userId = page.getUserId();
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"fileEntryId", (Object)fileEntry.getFileEntryId()).put("fileEntryTitle", fileEntry.getTitle()).put("title", page.getTitle()).put("version", page.getVersion());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)10006, (String)extraDataJSONObject.toString(), (long)0L);
        return fileEntry;
    }

    public List<FileEntry> addPageAttachments(long userId, long nodeId, String title2, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        if (inputStreamOVPs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
            String fileName = (String)inputStreamOVP.getKey();
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            File file = null;
            try {
                file = FileUtil.createTempFile((InputStream)inputStream);
                String mimeType = this._mimeTypes.getContentType(file, fileName);
                FileEntry fileEntry = this.addPageAttachment(userId, nodeId, title2, fileName, file, mimeType);
                fileEntries.add(fileEntry);
            }
            catch (IOException ioException) {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            finally {
                FileUtil.delete((File)file);
            }
        }
        return fileEntries;
    }

    public void addPageResources(long nodeId, String title2, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        this.addPageResources(page, addGroupPermissions, addGuestPermissions);
    }

    @Deprecated
    public void addPageResources(long nodeId, String title2, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        this.addPageResources(page, groupPermissions, guestPermissions);
    }

    public void addPageResources(WikiPage page, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addPageResources(WikiPage page, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), modelPermissions);
    }

    @Deprecated
    public void addPageResources(WikiPage page, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public FileEntry addTempFileEntry(long groupId, long userId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    @Deprecated
    public void addTempPageAttachment(long groupId, long userId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException {
        this.addTempFileEntry(groupId, userId, tempFolderName, fileName, inputStream, mimeType);
    }

    public WikiPage changeParent(long userId, long nodeId, String title2, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        WikiPage parentPage;
        if (Validator.isNotNull((String)newParentTitle) && Validator.isNotNull((String)(parentPage = this.getPage(nodeId, newParentTitle)).getRedirectTitle())) {
            newParentTitle = parentPage.getRedirectTitle();
        }
        WikiPage page = this.getPage(nodeId, title2);
        String originalParentTitle = page.getParentTitle();
        double version = page.getVersion();
        String content = page.getContent();
        String summary = serviceContext.translate("changed-parent-from-x", new Object[]{originalParentTitle});
        boolean minorEdit = false;
        String format = page.getFormat();
        String redirectTitle = page.getRedirectTitle();
        this._populateServiceContext(serviceContext, page);
        serviceContext.setCommand("change_parent");
        return this.updatePage(userId, nodeId, title2, version, content, summary, minorEdit, format, newParentTitle, redirectTitle, serviceContext);
    }

    public void copyPageAttachments(long userId, long templateNodeId, String templateTitle, long nodeId, String title2) throws PortalException {
        WikiPage templatePage = this.getPage(templateNodeId, templateTitle);
        List templateFileEntries = templatePage.getAttachmentsFileEntries();
        for (FileEntry templateFileEntry : templateFileEntries) {
            this.addPageAttachment(userId, nodeId, title2, templateFileEntry.getTitle(), templateFileEntry.getContentStream(), templateFileEntry.getMimeType());
        }
    }

    @Deactivate
    public void deactivate() {
        this._serviceTrackerMap.close();
        this._portalCache.removeAll();
    }

    public void deletePage(long nodeId, String title2) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title2, true, 0, 1);
        if (!pages.isEmpty()) {
            this.wikiPageLocalService.deletePage((WikiPage)pages.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemEvent(action=1, send=false, type=1)
    public void deletePage(WikiPage page) throws PortalException {
        long folderId;
        List childPages = this.wikiPagePersistence.findByN_P(page.getNodeId(), page.getTitle());
        for (Object childPage : childPages) {
            if (childPage.isApproved() || childPage.isInTrashImplicitly()) {
                this.wikiPageLocalService.deletePage((WikiPage)childPage);
                continue;
            }
            childPage.setParentTitle("");
            this.wikiPagePersistence.update((BaseModel)childPage);
        }
        List<WikiPage> redirectorPages = this.getRedirectorPages(page.getNodeId(), page.getTitle());
        for (WikiPage redirectorPage : redirectorPages) {
            if (redirectorPage.isApproved() || redirectorPage.isInTrashImplicitly()) {
                this.wikiPageLocalService.deletePage(redirectorPage);
                continue;
            }
            redirectorPage.setRedirectTitle("");
            this.wikiPagePersistence.update((BaseModel)redirectorPage);
        }
        List versionPages = this.wikiPagePersistence.findByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_R(page.getNodeId(), page.getTitle());
        this.resourceLocalService.deleteResource(page.getCompanyId(), WikiPage.class.getName(), 4, page.getResourcePrimKey());
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByN_T(page.getNodeId(), page.getTitle());
        if (pageResource != null) {
            this.wikiPageResourcePersistence.remove((BaseModel)pageResource);
        }
        if ((folderId = page.getAttachmentsFolderId()) != 0L) {
            this._portletFileRepository.deletePortletFolder(folderId);
        }
        this._subscriptionLocalService.deleteSubscriptions(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey());
        SystemEventHierarchyEntryThreadLocal.pop((Class)page.getModelClass(), (long)page.getPageId());
        try {
            for (WikiPage versionPage : versionPages) {
                this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), versionPage.getPrimaryKey());
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.push((Class)page.getModelClass(), (long)page.getPageId());
        }
        this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this._commentManager.deleteDiscussion(WikiPage.class.getName(), page.getResourcePrimKey());
        this.expandoRowLocalService.deleteRows(page.getPrimaryKey());
        this.ratingsStatsLocalService.deleteStats(WikiPage.class.getName(), page.getResourcePrimKey());
        if (page.isInTrash()) {
            if (page.isInTrashExplicitly()) {
                page.setTitle(this._trashHelper.getOriginalTitle(page.getTitle()));
                this._trashEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
            } else {
                for (WikiPage versionPage : versionPages) {
                    this._trashVersionLocalService.deleteTrashVersion(WikiPage.class.getName(), versionPage.getPageId());
                }
            }
        }
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiPage.class);
        indexer.delete((Object)page);
        this.clearPageCache(page);
        for (WikiPage versionPage : versionPages) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(versionPage.getCompanyId(), versionPage.getGroupId(), WikiPage.class.getName(), versionPage.getPageId());
        }
        if (pageResource != null) {
            this.systemEventLocalService.addSystemEvent(0L, page.getGroupId(), page.getModelClassName(), page.getPrimaryKey(), pageResource.getUuid(), null, 1, "");
        }
    }

    public void deletePageAttachment(long nodeId, String title2, String fileName) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        long folderId = page.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(page.getGroupId(), folderId, fileName);
        this._deletePageAttachment(fileEntry.getFileEntryId());
    }

    public void deletePageAttachments(long nodeId, String title2) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        long folderId = page.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        this._portletFileRepository.deletePortletFileEntries(page.getGroupId(), folderId);
    }

    public void deletePages(long nodeId) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_H_P(nodeId, true, "");
        for (WikiPage page : pages) {
            this.wikiPageLocalService.deletePage(page);
        }
        pages = this.wikiPagePersistence.findByN_H_P(nodeId, false, "");
        for (WikiPage page : pages) {
            this.wikiPageLocalService.deletePage(page);
        }
    }

    public void deleteTempFileEntry(long groupId, long userId, String folderName, String fileName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName);
    }

    public void deleteTrashPageAttachments(long nodeId, String title2) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        long folderId = page.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        this._portletFileRepository.deletePortletFileEntries(page.getGroupId(), folderId, 8);
    }

    public void discardDraft(long nodeId, String title2, double version) throws PortalException {
        this.wikiPagePersistence.removeByN_T_V(nodeId, title2, version);
    }

    public WikiPage fetchLatestPage(long resourcePrimKey, int status, boolean preferApproved) {
        PageVersionComparator orderByComparator = new PageVersionComparator();
        if (status != -1) {
            return this.wikiPagePersistence.fetchByR_S_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        WikiPage page = null;
        if (preferApproved) {
            page = this.wikiPagePersistence.fetchByR_S_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
        }
        if (page != null) {
            return page;
        }
        return this.wikiPagePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
    }

    public WikiPage fetchLatestPage(long resourcePrimKey, long nodeId, int status, boolean preferApproved) {
        PageVersionComparator orderByComparator = new PageVersionComparator();
        if (status != -1) {
            return this.wikiPagePersistence.fetchByR_N_S_First(resourcePrimKey, nodeId, status, (OrderByComparator)orderByComparator);
        }
        WikiPage page = null;
        if (preferApproved) {
            page = this.wikiPagePersistence.fetchByR_N_S_First(resourcePrimKey, nodeId, 0, (OrderByComparator)orderByComparator);
        }
        if (page != null) {
            return page;
        }
        return this.wikiPagePersistence.fetchByR_N_First(resourcePrimKey, nodeId, (OrderByComparator)orderByComparator);
    }

    public WikiPage fetchLatestPage(long nodeId, String title2, int status, boolean preferApproved) {
        PageVersionComparator orderByComparator = new PageVersionComparator();
        if (status != -1) {
            return this.wikiPagePersistence.fetchByN_T_S_First(nodeId, title2, status, (OrderByComparator)orderByComparator);
        }
        WikiPage page = null;
        if (preferApproved) {
            page = this.wikiPagePersistence.fetchByN_T_S_First(nodeId, title2, 0, (OrderByComparator)orderByComparator);
        }
        if (page != null) {
            return page;
        }
        return this.wikiPagePersistence.fetchByN_T_First(nodeId, title2, (OrderByComparator)orderByComparator);
    }

    public WikiPage fetchPage(long resourcePrimKey) {
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByPrimaryKey(resourcePrimKey);
        if (pageResource == null) {
            return null;
        }
        return this.fetchPage(pageResource.getNodeId(), pageResource.getTitle());
    }

    public WikiPage fetchPage(long nodeId, String title2) {
        return this.wikiPagePersistence.fetchByN_T_H_First(nodeId, title2, true, null);
    }

    public WikiPage fetchPage(long nodeId, String title2, double version) {
        if (version == 0.0) {
            return this.fetchPage(nodeId, title2);
        }
        return this.wikiPagePersistence.fetchByN_T_V(nodeId, title2, version);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head2, String parentTitle) {
        return this.getChildren(nodeId, head2, parentTitle, 0);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head2, String parentTitle, int status) {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head2, parentTitle, status);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head2, String parentTitle, int start, int end) {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head2, parentTitle, 0, start, end);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head2, String parentTitle, int status, int start, int end, OrderByComparator obc) {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head2, parentTitle, status, start, end, obc);
    }

    public int getChildrenCount(long nodeId, boolean head2, String parentTitle) {
        return this.getChildrenCount(nodeId, head2, parentTitle, 0);
    }

    public int getChildrenCount(long nodeId, boolean head2, String parentTitle, int status) {
        return this.wikiPagePersistence.countByN_H_P_S(nodeId, head2, parentTitle, status);
    }

    public List<WikiPage> getDependentPages(long nodeId, boolean head2, String title2, int status) {
        ArrayList<WikiPage> dependentPages = new ArrayList<WikiPage>(this.getChildren(nodeId, head2, title2, status));
        dependentPages.addAll(this.getRedirectorPages(nodeId, head2, title2, status));
        return dependentPages;
    }

    public WikiPageDisplay getDisplay(long nodeId, String title2, PortletURL viewPageURL, Supplier<PortletURL> editPageURLSupplier, String attachmentURLPrefix) throws PortalException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String key = this._encodeKey(nodeId, title2, viewPageURL.toString());
        WikiPageDisplay pageDisplay = (WikiPageDisplay)this._portalCache.get((Serializable)((Object)key));
        if (pageDisplay == null) {
            pageDisplay = this.getPageDisplay(nodeId, title2, viewPageURL, editPageURLSupplier.get(), attachmentURLPrefix);
            this._portalCache.put((Serializable)((Object)key), (Object)pageDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"getDisplay for {", nodeId, ", ", title2, ", ", viewPageURL, ", ", editPageURLSupplier.get(), "} takes ", stopWatch.getTime(), " ms"}));
        }
        return pageDisplay;
    }

    public WikiPage getDraftPage(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPagePersistence.fetchByN_T_S_First(nodeId, title2, 2, null);
        if (page != null) {
            return page;
        }
        return this.wikiPagePersistence.findByN_T_S_First(nodeId, title2, 1, null);
    }

    public List<WikiPage> getIncomingLinks(long nodeId, String title2) throws PortalException {
        HashSet<WikiPage> links = new HashSet<WikiPage>();
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!this._isLinkedTo(page, title2)) continue;
            links.add(page);
        }
        List<WikiPage> redirectorPages = this.getRedirectorPages(nodeId, title2);
        for (WikiPage redirectorPage : redirectorPages) {
            for (WikiPage page : pages) {
                if (!this._isLinkedTo(page, redirectorPage.getTitle())) continue;
                links.add(page);
            }
        }
        return ListUtil.sort(new ArrayList(links));
    }

    public WikiPage getLatestPage(long resourcePrimKey, int status, boolean preferApproved) throws PortalException {
        WikiPage page = this.fetchLatestPage(resourcePrimKey, status, preferApproved);
        if (page != null) {
            return page;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("{resourcePrimKey=");
        sb.append(resourcePrimKey);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public WikiPage getLatestPage(long resourcePrimKey, long nodeId, int status, boolean preferApproved) throws PortalException {
        WikiPage page = this.fetchLatestPage(resourcePrimKey, nodeId, status, preferApproved);
        if (page != null) {
            return page;
        }
        StringBundler sb = new StringBundler(7);
        sb.append("{resourcePrimKey=");
        sb.append(resourcePrimKey);
        sb.append(", nodeId=");
        sb.append(nodeId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public WikiPage getLatestPage(long nodeId, String title2, int status, boolean preferApproved) throws PortalException {
        WikiPage page = this.fetchLatestPage(nodeId, title2, status, preferApproved);
        if (page != null) {
            return page;
        }
        StringBundler sb = new StringBundler(7);
        sb.append("{nodeId=");
        sb.append(nodeId);
        sb.append(", title=");
        sb.append(title2);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    @Deprecated
    public List<WikiPage> getNoAssetPages() {
        return this.wikiPageFinder.findByNoAssets();
    }

    public List<WikiPage> getOrphans(List<WikiPage> pages) throws PortalException {
        ArrayList<Map<String, Boolean>> pageTitles = new ArrayList<Map<String, Boolean>>();
        for (WikiPage wikiPage : pages) {
            pageTitles.add(this._getOutgoingLinks(wikiPage));
        }
        HashSet<WikiPage> notOrphans = new HashSet<WikiPage>();
        block1: for (WikiPage page : pages) {
            for (Map map2 : pageTitles) {
                String pageTitleLowerCase = page.getTitle();
                if (map2.get(pageTitleLowerCase = StringUtil.toLowerCase((String)pageTitleLowerCase)) == null) continue;
                notOrphans.add(page);
                continue block1;
            }
        }
        ArrayList<WikiPage> arrayList = new ArrayList<WikiPage>();
        for (WikiPage page : pages) {
            if (notOrphans.contains(page)) continue;
            arrayList.add(page);
        }
        return ListUtil.sort(arrayList);
    }

    public List<WikiPage> getOrphans(long nodeId) throws PortalException {
        List pages = this.wikiPagePersistence.findByN_H_S(nodeId, true, 0);
        return this.getOrphans(pages);
    }

    public List<WikiPage> getOutgoingLinks(long nodeId, String title2) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        LinkedHashMap<String, WikiPage> pages = new LinkedHashMap<String, WikiPage>();
        Map<String, Boolean> links = this._getOutgoingLinks(page);
        for (Map.Entry<String, Boolean> entry : links.entrySet()) {
            String curTitle = entry.getKey();
            Boolean exists = entry.getValue();
            if (exists.booleanValue()) {
                WikiPage curPage = this.getPage(nodeId, curTitle);
                if (pages.containsKey(curPage.getTitle())) continue;
                pages.put(curPage.getTitle(), curPage);
                continue;
            }
            WikiPageImpl wikiPageImpl = new WikiPageImpl();
            wikiPageImpl.setNew(true);
            wikiPageImpl.setNodeId(nodeId);
            wikiPageImpl.setTitle(curTitle);
            if (pages.containsKey(curTitle)) continue;
            pages.put(curTitle, wikiPageImpl);
        }
        return ListUtil.fromMapValues(pages);
    }

    public WikiPage getPage(long resourcePrimKey) throws PortalException {
        return this.getPage(resourcePrimKey, Boolean.TRUE);
    }

    public WikiPage getPage(long resourcePrimKey, Boolean head2) throws PortalException {
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        return this.getPage(pageResource.getNodeId(), pageResource.getTitle(), head2);
    }

    public WikiPage getPage(long nodeId, String title2) throws PortalException {
        return this.wikiPagePersistence.findByN_T_H_First(nodeId, title2, true, null);
    }

    public WikiPage getPage(long nodeId, String title2, Boolean head2) throws PortalException {
        if (head2 == null) {
            return this.wikiPagePersistence.findByN_T_First(nodeId, title2, null);
        }
        return this.wikiPagePersistence.findByN_T_H_First(nodeId, title2, head2.booleanValue(), null);
    }

    public WikiPage getPage(long nodeId, String title2, double version) throws PortalException {
        if (version == 0.0) {
            return this.getPage(nodeId, title2);
        }
        return this.wikiPagePersistence.findByN_T_V(nodeId, title2, version);
    }

    public WikiPage getPageByPageId(long pageId) throws PortalException {
        return this.wikiPagePersistence.findByPrimaryKey(pageId);
    }

    public WikiPageDisplay getPageDisplay(long nodeId, String title2, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        return this.getPageDisplay(page, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public WikiPageDisplay getPageDisplay(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException {
        String formattedContent = this._wikiEngineRenderer.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        return new WikiPageDisplayImpl(page.getUserId(), page.getNodeId(), page.getTitle(), page.getVersion(), page.getContent(), formattedContent, page.getFormat(), page.isHead(), page.getAttachmentsFileEntries());
    }

    public WikiPageDisplay getPageDisplay(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix, ServiceContext serviceContext) throws PortalException {
        return this.getPageDisplay(page, viewPageURL, () -> editPageURL, attachmentURLPrefix, serviceContext);
    }

    public WikiPageDisplay getPageDisplay(WikiPage page, PortletURL viewPageURL, Supplier<PortletURL> editPageURLSupplier, String attachmentURLPrefix, ServiceContext serviceContext) throws PortalException {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        boolean workflowAssetPreview = false;
        if (httpServletRequest != null) {
            workflowAssetPreview = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("WORKFLOW_ASSET_PREVIEW"));
        }
        if (!workflowAssetPreview && page.isApproved()) {
            return this.getDisplay(page.getNodeId(), page.getTitle(), viewPageURL, editPageURLSupplier, attachmentURLPrefix);
        }
        return this.getPageDisplay(page, viewPageURL, editPageURLSupplier.get(), attachmentURLPrefix);
    }

    public List<WikiPage> getPages(long nodeId, boolean head2, int start, int end) {
        return this.getPages(nodeId, head2, start, end, (OrderByComparator<WikiPage>)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, boolean head2, int status, int start, int end) {
        return this.getPages(nodeId, head2, status, start, end, (OrderByComparator<WikiPage>)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, boolean head2, int status, int start, int end, OrderByComparator<WikiPage> obc) {
        if (status == -1) {
            return this.wikiPagePersistence.findByN_H(nodeId, head2, start, end, obc);
        }
        return this.wikiPagePersistence.findByN_H_S(nodeId, head2, status, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, boolean head2, int start, int end, OrderByComparator<WikiPage> obc) {
        return this.getPages(nodeId, head2, 0, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, int start, int end) {
        return this.getPages(nodeId, start, end, (OrderByComparator<WikiPage>)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, int start, int end, OrderByComparator<WikiPage> obc) {
        return this.wikiPagePersistence.findByNodeId(nodeId, start, end, obc);
    }

    public List<WikiPage> getPages(long resourcePrimKey, long nodeId, int status) {
        return this.wikiPagePersistence.findByR_N_S(resourcePrimKey, nodeId, status);
    }

    public List<WikiPage> getPages(long userId, long nodeId, int status, int start, int end) {
        if (userId > 0L) {
            return this.wikiPagePersistence.findByU_N_S(userId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
        }
        return this.wikiPagePersistence.findByN_S(nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title2, boolean head2, int start, int end) {
        return this.wikiPagePersistence.findByN_T_H(nodeId, title2, head2, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title2, int start, int end) {
        return this.wikiPagePersistence.findByN_T(nodeId, title2, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title2, int start, int end, OrderByComparator<WikiPage> obc) {
        return this.wikiPagePersistence.findByN_T(nodeId, title2, start, end, obc);
    }

    public List<WikiPage> getPages(String format) {
        return this.wikiPagePersistence.findByFormat(format);
    }

    public int getPagesCount(long nodeId) {
        return this.wikiPagePersistence.countByNodeId(nodeId);
    }

    public int getPagesCount(long nodeId, boolean head2) {
        return this.wikiPagePersistence.countByN_H_S(nodeId, head2, 0);
    }

    public int getPagesCount(long nodeId, boolean head2, int status) {
        if (status == -1) {
            return this.wikiPagePersistence.countByN_H_NotS(nodeId, head2, 8);
        }
        return this.wikiPagePersistence.countByN_H_S(nodeId, head2, status);
    }

    public int getPagesCount(long nodeId, int status) {
        return this.wikiPagePersistence.countByN_S(nodeId, status);
    }

    public int getPagesCount(long userId, long nodeId, int status) {
        if (userId > 0L) {
            return this.wikiPagePersistence.countByU_N_S(userId, nodeId, status);
        }
        return this.wikiPagePersistence.countByN_S(nodeId, status);
    }

    public int getPagesCount(long nodeId, String title2) {
        return this.wikiPagePersistence.countByN_T(nodeId, title2);
    }

    public int getPagesCount(long nodeId, String title2, boolean head2) {
        return this.wikiPagePersistence.countByN_T_H(nodeId, title2, head2);
    }

    public int getPagesCount(String format) {
        return this.wikiPagePersistence.countByFormat(format);
    }

    public WikiPage getPreviousVersionPage(WikiPage page) throws PortalException {
        double previousVersion = MathUtil.format((double)(page.getVersion() - 0.1), (int)1, (int)1);
        if (previousVersion < 1.0) {
            return null;
        }
        return this.getPage(page.getNodeId(), page.getTitle(), previousVersion);
    }

    public List<WikiPage> getRecentChanges(long groupId, long nodeId, int start, int end) {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.findByModifiedDate(groupId, nodeId, cal.getTime(), false, start, end);
    }

    public int getRecentChangesCount(long groupId, long nodeId) {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.countByModifiedDate(groupId, nodeId, cal.getTime(), false);
    }

    public List<WikiPage> getRedirectorPages(long nodeId, boolean head2, String redirectTitle, int status) {
        return this.wikiPagePersistence.findByN_H_R_S(nodeId, head2, redirectTitle, status);
    }

    public List<WikiPage> getRedirectorPages(long nodeId, String redirectTitle) {
        return this.wikiPagePersistence.findByN_R(nodeId, redirectTitle);
    }

    public String[] getTempFileNames(long groupId, long userId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public boolean hasDraftPage(long nodeId, String title2) {
        int count = this.wikiPagePersistence.countByN_T_S(nodeId, title2, 2);
        return count > 0;
    }

    public void moveDependentToTrash(WikiPage page, long trashEntryId) throws PortalException {
        this._moveDependentToTrash(page, trashEntryId, false);
    }

    @Deprecated
    public void movePage(long userId, long nodeId, String title2, String newTitle, ServiceContext serviceContext) throws PortalException {
        this.renamePage(userId, nodeId, title2, newTitle, true, serviceContext);
    }

    public FileEntry movePageAttachmentToTrash(long userId, long nodeId, String title2, String fileName) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(page.getGroupId(), page.getAttachmentsFolderId(), fileName);
        fileEntry = this._portletFileRepository.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"fileEntryId", (Object)fileEntry.getFileEntryId()).put("fileEntryTitle", this._trashHelper.getOriginalTitle(fileEntry.getTitle())).put("title", page.getTitle()).put("version", page.getVersion());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)10009, (String)extraDataJSONObject.toString(), (long)0L);
        return fileEntry;
    }

    public WikiPage movePageFromTrash(long userId, long nodeId, String title2, long newNodeId, String newParentTitle) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        if (!page.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (page.isInTrashExplicitly()) {
            this._movePageFromTrash(userId, page, newNodeId, newParentTitle);
        } else {
            this._moveDependentFromTrash(page, newNodeId, newParentTitle);
        }
        return page;
    }

    @Deprecated
    public WikiPage movePageFromTrash(long userId, long nodeId, String title2, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        return this.movePageFromTrash(userId, nodeId, title2, nodeId, newParentTitle);
    }

    public WikiPage movePageToTrash(long userId, long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPagePersistence.fetchByN_T_H_First(nodeId, title2, true, null);
        if (page != null) {
            return this.movePageToTrash(userId, page);
        }
        return null;
    }

    public WikiPage movePageToTrash(long userId, long nodeId, String title2, double version) throws PortalException {
        WikiPage page = this.wikiPagePersistence.findByN_T_V(nodeId, title2, version);
        return this.movePageToTrash(userId, page);
    }

    public WikiPage movePageToTrash(long userId, WikiPage page) throws PortalException {
        if (page.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = page.getStatus();
        String oldTitle = page.getTitle();
        if (oldStatus == 1) {
            page.setStatus(2);
            page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        }
        List pageVersions = this.wikiPagePersistence.findByR_N_H(page.getResourcePrimKey(), page.getNodeId(), false);
        pageVersions = ListUtil.sort((List)pageVersions, (Comparator)new PageVersionComparator());
        List<Object> pageVersionStatusOVPs = new ArrayList();
        if (pageVersions != null && !pageVersions.isEmpty()) {
            pageVersionStatusOVPs = this._getPageVersionStatuses(pageVersions);
        }
        page = this.updateStatus(userId, page, 8, new ServiceContext(), new HashMap<String, Serializable>());
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByPrimaryKey(page.getResourcePrimKey());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", page.getTitle());
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), null, oldStatus, pageVersionStatusOVPs, typeSettingsProperties);
        String trashTitle = this._trashHelper.getTrashTitle(trashEntry.getEntryId());
        for (WikiPage pageVersion : pageVersions) {
            pageVersion.setTitle(trashTitle);
            pageVersion.setStatus(8);
            this.wikiPagePersistence.update((BaseModel)pageVersion);
        }
        pageResource.setTitle(trashTitle);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        page.setTitle(trashTitle);
        page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        this._moveDependentChildPagesToTrash(page.getNodeId(), oldTitle, trashTitle, trashEntry.getEntryId(), true);
        this._moveDependentRedirectorPagesToTrash(page.getNodeId(), oldTitle, trashTitle, trashEntry.getEntryId(), true);
        this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), false);
        for (FileEntry fileEntry : page.getAttachmentsFileEntries()) {
            this._portletFileRepository.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
        }
        this._commentManager.moveDiscussionToTrash(WikiPage.class.getName(), page.getResourcePrimKey());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)this._trashHelper.getOriginalTitle(page.getTitle())).put("version", page.getVersion());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getPageId());
        }
        return page;
    }

    public void renamePage(long userId, long nodeId, String title2, String newTitle, boolean strict, ServiceContext serviceContext) throws PortalException {
        WikiPage page;
        WikiPage latestWikiPage = this.fetchLatestPage(nodeId, title2, -1, false);
        if (latestWikiPage != null && !latestWikiPage.isApproved()) {
            throw new PageVersionException();
        }
        newTitle = StringUtil.replace((String)newTitle, (char)'\u00a0', (char)' ');
        this._wikiPageTitleValidator.validate(newTitle);
        if (StringUtil.equalsIgnoreCase((String)title2, (String)newTitle)) {
            throw new DuplicatePageException(newTitle);
        }
        if (this._isUsedTitle(nodeId, newTitle)) {
            page = this.getPage(nodeId, newTitle);
            String content = page.getContent();
            if (page.getVersion() == 1.0 && content.length() < 200 || !strict) {
                this.deletePage(nodeId, newTitle);
            } else {
                throw new DuplicatePageException(newTitle);
            }
        }
        page = this.getPage(nodeId, title2);
        String summary = page.getSummary();
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            page.setRedirectTitle("");
            summary = "";
        }
        this._populateServiceContext(serviceContext, page);
        serviceContext.setCommand("rename");
        WikiPageRenameContentProcessor wikiPageRenameContentProcessor = (WikiPageRenameContentProcessor)this._serviceTrackerMap.getService((Object)page.getFormat());
        String content = page.getContent();
        if (wikiPageRenameContentProcessor != null) {
            List versionPages = this.wikiPagePersistence.findByN_T_H(nodeId, title2, false);
            for (WikiPage curPage : versionPages) {
                curPage.setTitle(newTitle);
                curPage.setContent(wikiPageRenameContentProcessor.processContent(curPage.getNodeId(), title2, newTitle, curPage.getContent()));
                this.wikiPagePersistence.update((BaseModel)curPage);
            }
            content = wikiPageRenameContentProcessor.processContent(page.getNodeId(), title2, newTitle, content);
        }
        this._updatePage(userId, page, newTitle, content, summary, page.isMinorEdit(), page.getFormat(), page.getParentTitle(), page.getRedirectTitle(), serviceContext);
    }

    public void renamePage(long userId, long nodeId, String title2, String newTitle, ServiceContext serviceContext) throws PortalException {
        this.renamePage(userId, nodeId, title2, newTitle, true, serviceContext);
    }

    public void restorePageAttachmentFromTrash(long userId, long nodeId, String title2, String fileName) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(page.getGroupId(), page.getAttachmentsFolderId(), fileName);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"fileEntryId", (Object)fileEntry.getFileEntryId()).put("fileEntryTitle", this._trashHelper.getOriginalTitle(fileEntry.getTitle())).put("title", page.getTitle()).put("version", page.getVersion());
        this._portletFileRepository.restorePortletFileEntryFromTrash(userId, fileEntry.getFileEntryId());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)10010, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public void restorePageFromTrash(long userId, WikiPage page) throws PortalException {
        if (!page.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (page.isInTrashExplicitly()) {
            this._movePageFromTrash(userId, page, page.getNodeId(), page.getParentTitle());
        } else {
            this._moveDependentFromTrash(page, page.getNodeId(), page.getParentTitle());
        }
    }

    public WikiPage revertPage(long userId, long nodeId, String title2, double version, ServiceContext serviceContext) throws PortalException {
        WikiPage oldPage = this.getPage(nodeId, title2, version);
        this._populateServiceContext(serviceContext, oldPage);
        return this.updatePage(userId, nodeId, title2, 0.0, oldPage.getContent(), "Reverted to " + version, false, oldPage.getFormat(), this._getParentPageTitle(oldPage), oldPage.getRedirectTitle(), serviceContext);
    }

    public void subscribePage(long userId, long nodeId, String title2) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        this._subscriptionLocalService.addSubscription(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void unsubscribePage(long userId, long nodeId, String title2) throws PortalException {
        WikiPage page = this.getPage(nodeId, title2);
        this._subscriptionLocalService.deleteSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void updateAsset(long userId, WikiPage page, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        int approvedPagesCount;
        boolean addDraftAssetEntry = false;
        if (!page.isApproved() && page.getVersion() != 1.0 && (approvedPagesCount = this.wikiPagePersistence.countByN_T_S(page.getNodeId(), page.getTitle(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        Date publishDate = null;
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), page.getCreateDate(), page.getModifiedDate(), WikiPage.class.getName(), page.getPrimaryKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, publishDate, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, priority);
        } else {
            if (page.isApproved()) {
                publishDate = page.getCreateDate();
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), page.getCreateDate(), page.getModifiedDate(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, true, page.isApproved(), null, null, publishDate, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, priority);
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @BufferedIncrement(configuration="WikiNode", incrementClass=DateOverrideIncrement.class)
    public void updateLastPostDate(long nodeId, Date lastPostDate) {
        block3: {
            WikiNode node = this.wikiNodePersistence.fetchByPrimaryKey(nodeId);
            Date oldLastPostDate = node.getLastPostDate();
            if (node == null || oldLastPostDate != null && lastPostDate.before(oldLastPostDate)) {
                return;
            }
            node.setLastPostDate(lastPostDate);
            try {
                this.wikiNodePersistence.update((BaseModel)node);
            }
            catch (SystemException systemException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)systemException, (Throwable)systemException);
            }
        }
    }

    public WikiPage updatePage(long userId, long nodeId, String title2, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        try {
            WikiPage oldPage = this.wikiPagePersistence.findByN_T_First(nodeId, title2, null);
            if (version > 0.0 && version != oldPage.getVersion()) {
                throw new PageVersionException();
            }
            return this._updatePage(userId, oldPage, "", content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
        }
        catch (NoSuchPageException noSuchPageException) {
            return this.addPage(userId, nodeId, title2, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
        }
    }

    public WikiPage updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException {
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        WikiPage page = this.wikiPagePersistence.findByN_T_First(pageResource.getNodeId(), pageResource.getTitle(), (OrderByComparator)new PageVersionComparator());
        return this.updateStatus(userId, page, status, serviceContext, new HashMap<String, Serializable>());
    }

    @Deprecated
    public WikiPage updateStatus(long userId, WikiPage page, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, page, status, serviceContext, new HashMap<String, Serializable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiPage updateStatus(long userId, WikiPage page, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        List pages;
        User user = this.userLocalService.getUser(userId);
        int oldStatus = page.getStatus();
        page.setStatus(status);
        page.setStatusByUserId(userId);
        page.setStatusByUserName(user.getFullName());
        page.setStatusDate(new Date());
        page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        if (status == 0) {
            AssetEntry draftAssetEntry;
            String cmd = GetterUtil.getString((Object)workflowContext.get("command"));
            if (cmd.equals("change_parent")) {
                List pageVersions = this.wikiPagePersistence.findByN_T(page.getNodeId(), page.getTitle());
                for (WikiPage pageVersion : pageVersions) {
                    pageVersion.setParentTitle(page.getParentTitle());
                    if (!(pageVersion = (WikiPage)this.wikiPagePersistence.update((BaseModel)pageVersion)).equals(page)) continue;
                    page = pageVersion;
                }
            } else if (cmd.equals("rename")) {
                WikiPage oldPage = this.getPage(page.getResourcePrimKey(), true);
                page = this._renamePage(userId, page.getNodeId(), oldPage.getTitle(), page.getTitle(), serviceContext);
            }
            if (oldStatus != 0 && page.getVersion() != 1.0 && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(WikiPage.class.getName(), page.getPrimaryKey())) != null) {
                long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                String[] assetTagNames = draftAssetEntry.getTagNames();
                List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0, false);
                long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), page.getCreateDate(), page.getModifiedDate(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, page.getCreateDate(), null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null);
                this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                SystemEventHierarchyEntryThreadLocal.push(WikiPage.class);
                try {
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry.getEntryId());
                }
                finally {
                    SystemEventHierarchyEntryThreadLocal.pop(WikiPage.class);
                }
            }
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
            WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = (WikiGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(WikiGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(page.getGroupId(), "com.liferay.wiki"));
            if (oldStatus != 8 && (!page.isMinorEdit() || wikiGroupServiceOverriddenConfiguration.pageMinorEditAddSocialActivity())) {
                JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)page.getTitle()).put("version", page.getVersion());
                int type = 2;
                if (serviceContext.isCommandAdd()) {
                    type = 1;
                }
                SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)type, (String)extraDataJSONObject.toString(), (long)0L);
            }
            if (NotificationThreadLocal.isEnabled() && (!page.isMinorEdit() || wikiGroupServiceOverriddenConfiguration.pageMinorEditSendEmail())) {
                this._notifySubscribers(userId, page, (String)((Object)workflowContext.get("url")), serviceContext);
            }
            this.clearPageCache(page);
        }
        if (status == 0) {
            page.setHead(true);
            pages = this.wikiPagePersistence.findByN_T_H(page.getNodeId(), page.getTitle(), true);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(false);
                this.wikiPagePersistence.update((BaseModel)curPage);
            }
        } else if (status != 8) {
            page.setHead(false);
            pages = this.wikiPagePersistence.findByN_T_S(page.getNodeId(), page.getTitle(), 0);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(true);
                this.wikiPagePersistence.update((BaseModel)curPage);
                break;
            }
        }
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
    }

    public WikiPage updateWikiPage(WikiPage wikiPage, ServiceContext serviceContext) {
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)wikiPage, serviceContext);
    }

    @Deprecated
    public void validateTitle(String title2) throws PortalException {
        this._wikiPageTitleValidator.validate(title2);
    }

    protected void clearPageCache(WikiPage page) {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        this._portalCache.removeAll();
    }

    private void _deletePageAttachment(long fileEntryId) throws PortalException {
        this._portletFileRepository.deletePortletFileEntry(fileEntryId);
    }

    private String _encodeKey(long nodeId, String title2, String postfix) {
        StringBundler sb = new StringBundler(5);
        sb.append(StringUtil.toHexString((long)nodeId));
        sb.append("#");
        sb.append(title2);
        if (postfix != null) {
            sb.append("#");
            sb.append(postfix);
        }
        return sb.toString();
    }

    private String _formatContent(String content) {
        return StringUtil.replace((String)content, (String[])new String[]{"</p>", "</br>", "</div>"}, (String[])new String[]{"</p>\n", "</br>\n", "</div>\n"});
    }

    private String _getDiffsURL(WikiPage page, WikiPage previousVersionPage, ServiceContext serviceContext) throws PortalException {
        if (previousVersionPage == null) {
            return "";
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return "";
        }
        Object portletURL = null;
        long plid = serviceContext.getPlid();
        portletURL = plid == 0L ? this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE") : this._portletURLFactory.create(httpServletRequest, "com_liferay_wiki_web_portlet_WikiPortlet", plid, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/wiki/compare_versions");
        portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()));
        portletURL.setParameter("title", page.getTitle());
        portletURL.setParameter("sourceVersion", String.valueOf(previousVersionPage.getVersion()));
        portletURL.setParameter("targetVersion", String.valueOf(page.getVersion()));
        portletURL.setParameter("type", "html");
        return portletURL.toString();
    }

    private Map<String, Boolean> _getOutgoingLinks(WikiPage page) throws PageContentException {
        String key = this._encodeKey(page.getNodeId(), page.getTitle(), _OUTGOING_LINKS);
        Map links = (Map)this._portalCache.get((Serializable)((Object)key));
        if (links == null) {
            WikiEngine wikiEngine = this._wikiEngineRenderer.fetchWikiEngine(page.getFormat());
            links = wikiEngine != null ? wikiEngine.getOutgoingLinks(page) : Collections.emptyMap();
            this._portalCache.put((Serializable)((Object)key), (Object)((Serializable)((Object)links)));
        }
        return links;
    }

    private String _getPageURL(WikiPage page, ServiceContext serviceContext) throws PortalException {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return "";
        }
        String layoutFullURL = LayoutURLUtil.getLayoutURL((long)page.getGroupId(), (String)"com_liferay_wiki_web_portlet_WikiPortlet", (ServiceContext)serviceContext);
        if (Validator.isNotNull((String)layoutFullURL)) {
            return StringBundler.concat((Object[])new Object[]{layoutFullURL, "/-/", "wiki/", page.getNodeId(), "/", URLCodec.encodeURL((String)WikiEscapeUtil.escapeName((String)page.getTitle()))});
        }
        PortletURL portletURL = this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_wiki_web_portlet_WikiAdminPortlet", "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/wiki/view_page_activities");
        portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()));
        portletURL.setParameter("title", page.getTitle());
        return portletURL.toString();
    }

    private List<ObjectValuePair<Long, Integer>> _getPageVersionStatuses(List<WikiPage> pages) {
        ArrayList<ObjectValuePair<Long, Integer>> pageVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(pages.size());
        for (WikiPage page : pages) {
            int status = page.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair pageVersionStatusOVP = new ObjectValuePair((Object)page.getPageId(), (Object)status);
            pageVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)pageVersionStatusOVP);
        }
        return pageVersionStatusOVPs;
    }

    private String _getParentPageTitle(WikiPage page) {
        try {
            WikiPage parentPage = this.getPage(page.getNodeId(), page.getParentTitle());
            return parentPage.getTitle();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean _isLinkedTo(WikiPage page, String targetTitle) throws PortalException {
        Map<String, Boolean> links = this._getOutgoingLinks(page);
        Boolean link2 = links.get(StringUtil.toLowerCase((String)targetTitle));
        return link2 != null;
    }

    private boolean _isUsedTitle(long nodeId, String title2) {
        return this.getPagesCount(nodeId, title2) > 0;
    }

    private void _moveDependentChildPagesFromTrash(WikiPage newParentPage, long oldParentPageNodeId, String oldParentPageTitle) throws PortalException {
        List<WikiPage> childPages = this.getChildren(oldParentPageNodeId, true, oldParentPageTitle, 8);
        for (WikiPage childPage : childPages) {
            childPage = this.getPageByPageId(childPage.getPageId());
            childPage.setParentTitle(newParentPage.getTitle());
            if (!(childPage = (WikiPage)this.wikiPagePersistence.update((BaseModel)childPage)).isInTrashImplicitly()) continue;
            this._moveDependentFromTrash(childPage, newParentPage.getNodeId(), newParentPage.getTitle());
        }
    }

    private void _moveDependentChildPagesToTrash(long parentNodeId, String parentTitle, String parentTrashTitle, long trashEntryId, boolean createTrashVersion) throws PortalException {
        List childPages = this.wikiPagePersistence.findByN_H_P(parentNodeId, true, parentTitle);
        for (WikiPage childPage : childPages) {
            childPage = this.getPageByPageId(childPage.getPageId());
            childPage.setParentTitle(parentTrashTitle);
            if ((childPage = (WikiPage)this.wikiPagePersistence.update((BaseModel)childPage)).isInTrash()) continue;
            this._moveDependentToTrash(childPage, trashEntryId, createTrashVersion);
        }
    }

    private void _moveDependentFromTrash(WikiPage page, long newNodeId, String newParentTitle) throws PortalException {
        String trashTitle = page.getTitle();
        TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(WikiPage.class.getName(), page.getPageId());
        long oldNodeId = page.getNodeId();
        if (newNodeId == 0L) {
            newNodeId = oldNodeId;
        }
        page.setNodeId(newNodeId);
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(page.getResourcePrimKey());
        pageResource.setNodeId(newNodeId);
        if (trashVersion != null) {
            String originalTitle = this._trashHelper.getOriginalTitle(page.getTitle());
            pageResource.setTitle(originalTitle);
            page.setTitle(originalTitle);
        }
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        page.setParentTitle(newParentTitle);
        page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        int oldStatus = 0;
        if (trashVersion != null) {
            oldStatus = trashVersion.getStatus();
        }
        List versionPages = this.wikiPagePersistence.findByR_N(page.getResourcePrimKey(), page.getNodeId());
        for (Object versionPage : versionPages) {
            versionPage.setNodeId(newNodeId);
            versionPage.setTitle(page.getTitle());
            versionPage.setParentTitle(newParentTitle);
            trashVersion = this._trashVersionLocalService.fetchVersion(WikiPage.class.getName(), versionPage.getPageId());
            int versionPageOldStatus = 0;
            if (trashVersion != null) {
                versionPageOldStatus = trashVersion.getStatus();
            }
            versionPage.setStatus(versionPageOldStatus);
            this.wikiPagePersistence.update((BaseModel)versionPage);
            if (trashVersion == null) continue;
            this._trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
        }
        WikiNode node = page.getNode();
        for (FileEntry fileEntry : page.getAttachmentsFileEntries()) {
            this._portletFileRepository.restorePortletFileEntryFromTrash(node.getStatusByUserId(), fileEntry.getFileEntryId());
        }
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        this._moveDependentChildPagesFromTrash(page, oldNodeId, trashTitle);
        this._moveDependentRedirectorPagesFromTrash(page, oldNodeId, trashTitle);
    }

    private void _moveDependentRedirectorPagesFromTrash(WikiPage newRedirectPage, long oldRedirectPageNodeId, String oldRedirectPageTrashTitle) throws PortalException {
        List<WikiPage> redirectorPages = this.getRedirectorPages(oldRedirectPageNodeId, true, oldRedirectPageTrashTitle, 8);
        for (WikiPage redirectorPage : redirectorPages) {
            redirectorPage = this.getPageByPageId(redirectorPage.getPageId());
            redirectorPage.setRedirectTitle(newRedirectPage.getTitle());
            if (!(redirectorPage = (WikiPage)this.wikiPagePersistence.update((BaseModel)redirectorPage)).isInTrashImplicitly()) continue;
            this._moveDependentFromTrash(redirectorPage, newRedirectPage.getNodeId(), redirectorPage.getParentTitle());
        }
    }

    private void _moveDependentRedirectorPagesToTrash(long redirectPageNodeId, String redirectPageTitle, String redirectPageTrashTitle, long trashEntryId, boolean createTrashVersion) throws PortalException {
        List redirectorPages = this.wikiPagePersistence.findByN_H_R(redirectPageNodeId, true, redirectPageTitle);
        for (WikiPage redirectorPage : redirectorPages) {
            redirectorPage = this.getPageByPageId(redirectorPage.getPageId());
            redirectorPage.setRedirectTitle(redirectPageTrashTitle);
            if ((redirectorPage = (WikiPage)this.wikiPagePersistence.update((BaseModel)redirectorPage)).isInTrash()) continue;
            this._moveDependentToTrash(redirectorPage, trashEntryId, createTrashVersion);
        }
    }

    private void _moveDependentToTrash(WikiPage page, long trashEntryId, boolean createTrashVersion) throws PortalException {
        int oldStatus;
        String oldTitle;
        String trashTitle = oldTitle = page.getTitle();
        if (createTrashVersion) {
            UnicodeProperties typeSettingsProperties = new UnicodeProperties();
            typeSettingsProperties.put("title", oldTitle);
            TrashVersion trashVersion = this._trashVersionLocalService.addTrashVersion(trashEntryId, WikiPage.class.getName(), page.getPageId(), page.getStatus(), typeSettingsProperties);
            trashTitle = this._trashHelper.getTrashTitle(trashVersion.getVersionId());
            WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(page.getResourcePrimKey());
            pageResource.setTitle(trashTitle);
            this.wikiPageResourcePersistence.update((BaseModel)pageResource);
            page.setTitle(trashTitle);
            page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        }
        if ((oldStatus = page.getStatus()) == 8) {
            return;
        }
        List versionPages = this.wikiPagePersistence.findByR_N(page.getResourcePrimKey(), page.getNodeId());
        for (Object versionPage : versionPages) {
            versionPage.setTitle(page.getTitle());
            int versionPageOldStatus = versionPage.getStatus();
            versionPage.setStatus(8);
            versionPage = (WikiPage)this.wikiPagePersistence.update((BaseModel)versionPage);
            int status = versionPageOldStatus;
            if (versionPageOldStatus == 1) {
                status = 2;
            }
            if (versionPageOldStatus == 0) continue;
            this._trashVersionLocalService.addTrashVersion(trashEntryId, WikiPage.class.getName(), versionPage.getPageId(), status, null);
        }
        if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), false);
        }
        WikiNode node = page.getNode();
        for (FileEntry fileEntry : page.getAttachmentsFileEntries()) {
            this._portletFileRepository.movePortletFileEntryToTrash(node.getStatusByUserId(), fileEntry.getFileEntryId());
        }
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
        if (WikiCacheThreadLocal.isClearCache()) {
            this._portalCache.removeAll();
        }
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
        }
        this._moveDependentChildPagesToTrash(page.getNodeId(), oldTitle, trashTitle, trashEntryId, createTrashVersion);
        this._moveDependentRedirectorPagesToTrash(page.getNodeId(), oldTitle, trashTitle, trashEntryId, createTrashVersion);
    }

    private void _movePageFromTrash(long userId, WikiPage page, long newNodeId, String newParentTitle) throws PortalException {
        WikiPage redirectPage;
        WikiPage newParentPage;
        String trashTitle = page.getTitle();
        String originalTitle = this._trashHelper.getOriginalTitle(trashTitle);
        long oldNodeId = page.getNodeId();
        if (newNodeId == 0L) {
            newNodeId = oldNodeId;
        }
        List pageVersions = this.wikiPagePersistence.findByR_N_H(page.getResourcePrimKey(), oldNodeId, false);
        for (WikiPage pageVersion : pageVersions) {
            pageVersion.setNodeId(newNodeId);
            pageVersion.setTitle(originalTitle);
            pageVersion.setParentTitle(newParentTitle);
            this.wikiPagePersistence.update((BaseModel)pageVersion);
        }
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByPrimaryKey(page.getResourcePrimKey());
        pageResource.setNodeId(newNodeId);
        pageResource.setTitle(originalTitle);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        page.setNodeId(newNodeId);
        page.setTitle(originalTitle);
        WikiPage parentPage = page.getParentPage();
        if (parentPage != null && parentPage.isInTrash()) {
            page.setParentTitle("");
        }
        if (Validator.isNotNull((String)newParentTitle) && !(newParentPage = this.getPage(newNodeId, newParentTitle)).isInTrash()) {
            page.setParentTitle(newParentTitle);
        }
        if ((redirectPage = page.getRedirectPage()) != null && redirectPage.isInTrash()) {
            page.setRedirectTitle("");
        }
        page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this.updateStatus(userId, page, trashEntry.getStatus(), new ServiceContext(), new HashMap<String, Serializable>());
        for (Object fileEntry : page.getDeletedAttachmentsFileEntries()) {
            this._portletFileRepository.restorePortletFileEntryFromTrash(userId, fileEntry.getFileEntryId());
        }
        this._moveDependentChildPagesFromTrash(page, oldNodeId, trashTitle);
        this._moveDependentRedirectorPagesFromTrash(page, oldNodeId, trashTitle);
        List trashVersions = this._trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            WikiPage trashArticleVersion = this.wikiPagePersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashArticleVersion.setStatus(trashVersion.getStatus());
            this.wikiPagePersistence.update((BaseModel)trashArticleVersion);
        }
        this._trashEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this._commentManager.restoreDiscussionFromTrash(WikiPage.class.getName(), page.getResourcePrimKey());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)page.getTitle()).put("version", page.getVersion());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)page, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiPage.class);
        indexer.reindex((Object)page);
    }

    private void _notifySubscribers(long userId, WikiPage page, String pageURL, ServiceContext serviceContext) throws PortalException {
        if (!page.isApproved() || Validator.isNull((String)pageURL)) {
            return;
        }
        WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = (WikiGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(WikiGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(page.getGroupId(), "com.liferay.wiki"));
        boolean update = false;
        if (page.getVersion() > 1.0) {
            update = true;
        }
        if (!(!update && wikiGroupServiceOverriddenConfiguration.emailPageAddedEnabled() || update && wikiGroupServiceOverriddenConfiguration.emailPageUpdatedEnabled())) {
            return;
        }
        WikiPage previousVersionPage = this.getPreviousVersionPage(page);
        StringBundler sb = new StringBundler(9);
        sb.append(serviceContext.getPortalURL());
        sb.append(serviceContext.getPathMain());
        sb.append("/wiki/get_page_attachment?p_l_id=");
        sb.append(serviceContext.getPlid());
        sb.append("&nodeId=");
        sb.append(page.getNodeId());
        sb.append("&title=");
        sb.append(URLCodec.encodeURL((String)page.getTitle()));
        sb.append("&fileName=");
        String attachmentURLPrefix = sb.toString();
        String pageDiffs = "";
        try {
            pageDiffs = this._wikiEngineRenderer.diffHtml(previousVersionPage, page, null, null, attachmentURLPrefix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String pageContent = null;
        pageContent = Objects.equals(page.getFormat(), "creole") ? this._wikiEngineRenderer.convert(page, null, null, attachmentURLPrefix) : this._formatContent(page.getContent());
        String pageTitle = page.getTitle();
        String fromName = wikiGroupServiceOverriddenConfiguration.emailFromName();
        String fromAddress = wikiGroupServiceOverriddenConfiguration.emailFromAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (update) {
            subjectLocalizedValuesMap = wikiGroupServiceOverriddenConfiguration.emailPageUpdatedSubject();
            bodyLocalizedValuesMap = wikiGroupServiceOverriddenConfiguration.emailPageUpdatedBody();
        } else {
            subjectLocalizedValuesMap = wikiGroupServiceOverriddenConfiguration.emailPageAddedSubject();
            bodyLocalizedValuesMap = wikiGroupServiceOverriddenConfiguration.emailPageAddedBody();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setClassName(page.getModelClassName());
        subscriptionSender.setClassPK(page.getPageId());
        subscriptionSender.setCompanyId(page.getCompanyId());
        subscriptionSender.setContextAttribute("[$PAGE_CONTENT$]", (Object)pageContent, false);
        subscriptionSender.setContextAttribute("[$PAGE_DIFFS$]", (Object)DiffHtmlUtil.replaceStyles((String)pageDiffs), false);
        WikiNode node = page.getNode();
        subscriptionSender.setContextAttributes(new Object[]{"[$DIFFS_URL$]", this._getDiffsURL(page, previousVersionPage, serviceContext), "[$NODE_NAME$]", node.getName(), "[$PAGE_DATE_UPDATE$]", page.getModifiedDate(), "[$PAGE_ID$]", page.getPageId(), "[$PAGE_SUMMARY$]", page.getSummary(), "[$PAGE_TITLE$]", pageTitle, "[$PAGE_URL$]", pageURL});
        subscriptionSender.setContextCreatorUserPrefix("PAGE");
        subscriptionSender.setCreatorUserId(page.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(pageTitle);
        subscriptionSender.setEntryURL(pageURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        if (bodyLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        }
        if (subjectLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        }
        subscriptionSender.setMailId("wiki_page", new Object[]{page.getNodeId(), page.getPageId()});
        int notificationType = 0;
        if (update) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId("com_liferay_wiki_web_portlet_WikiPortlet");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(page.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addPersistedSubscribers(WikiNode.class.getName(), page.getNodeId());
        subscriptionSender.addPersistedSubscribers(WikiPage.class.getName(), page.getResourcePrimKey());
        subscriptionSender.flushNotificationsAsync();
    }

    private void _populateServiceContext(ServiceContext serviceContext, WikiPage page) throws PortalException {
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(WikiPage.class.getName(), page.getResourcePrimKey());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        List assetLinks = this.assetLinkLocalService.getLinks(assetEntry.getEntryId());
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        String[] assetTagNames = this.assetTagLocalService.getTagNames(WikiPage.class.getName(), page.getResourcePrimKey());
        serviceContext.setAssetTagNames(assetTagNames);
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
    }

    private WikiPage _renamePage(long userId, long nodeId, String title2, String newTitle, ServiceContext serviceContext) throws PortalException {
        List versionPages = this.wikiPagePersistence.findByN_T(nodeId, title2, -1, -1, (OrderByComparator)new PageVersionComparator());
        WikiPage page = this.fetchLatestPage(nodeId, newTitle, -1, false);
        if (page == null) {
            page = this.getLatestPage(nodeId, title2, -1, false);
        }
        for (WikiPage versionPage : versionPages) {
            versionPage.setTitle(newTitle);
            versionPage.setRedirectTitle(page.getRedirectTitle());
            if (!(versionPage = (WikiPage)this.wikiPagePersistence.update((BaseModel)versionPage)).equals(page)) continue;
            page = versionPage;
        }
        WikiPageResource pageResource = this.wikiPageResourcePersistence.findByPrimaryKey(page.getResourcePrimKey());
        pageResource.setTitle(newTitle);
        this.wikiPageResourcePersistence.update((BaseModel)pageResource);
        double version = 1.0;
        String summary = LanguageUtil.format((Locale)serviceContext.getLocale(), (String)"renamed-as-x", (Object)newTitle);
        String format = page.getFormat();
        boolean head2 = true;
        String parentTitle = page.getParentTitle();
        String redirectTitle = page.getTitle();
        String content = "[[" + redirectTitle + "]]";
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        this._populateServiceContext(serviceContext, page);
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        WorkflowThreadLocal.setEnabled((boolean)false);
        serviceContext.setCommand("add");
        this.addPage(userId, nodeId, title2, version, content, summary, false, format, head2, parentTitle, redirectTitle, serviceContext);
        WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        List childPages = this.wikiPagePersistence.findByN_P(nodeId, title2);
        for (WikiPage childPage : childPages) {
            childPage.setParentTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)childPage);
        }
        List<WikiPage> redirectorPages = this.getRedirectorPages(nodeId, title2);
        for (WikiPage redirectorPage : redirectorPages) {
            redirectorPage.setRedirectTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)redirectorPage);
        }
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return page;
    }

    private WikiPage _startWorkflowInstance(long userId, WikiPage page, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = HashMapBuilder.put((Object)"command", (Object)serviceContext.getCommand()).put((Object)"url", (Object)this._getPageURL(page, serviceContext)).build();
        return (WikiPage)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)page.getCompanyId(), (long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getPageId(), (Object)page, (ServiceContext)serviceContext, (Map)workflowContext);
    }

    private WikiPage _updatePage(long userId, WikiPage oldPage, String newTitle, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long pageId = 0L;
        pageId = oldPage.isApproved() ? this.counterLocalService.increment() : oldPage.getPageId();
        content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)oldPage.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)pageId, (String)("text/" + format), (String)content);
        long nodeId = oldPage.getNodeId();
        if (!format.equals(oldPage.getFormat())) {
            this._validate(nodeId, content, format);
        }
        serviceContext.validateModifiedDate((AuditedModel)oldPage, PageVersionException.class);
        long resourcePrimKey = this._wikiPageResourceLocalService.getPageResourcePrimKey(oldPage.getGroupId(), oldPage.getNodeId(), oldPage.getTitle());
        Date now = new Date();
        WikiPage page = oldPage;
        double newVersion = oldPage.getVersion();
        if (oldPage.isApproved()) {
            newVersion = MathUtil.format((double)(oldPage.getVersion() + 0.1), (int)1, (int)1);
            page = this.wikiPagePersistence.create(pageId);
            page.setUuid(serviceContext.getUuid());
        }
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(oldPage.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(oldPage.getCreateDate());
        page.setNodeId(nodeId);
        page.setTitle(Validator.isNull((String)newTitle) ? oldPage.getTitle() : newTitle);
        page.setVersion(newVersion);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        if (oldPage.isPending()) {
            page.setStatus(oldPage.getStatus());
        } else {
            page.setStatus(2);
        }
        page.setSummary(summary);
        page.setFormat(format);
        if (Validator.isNotNull((String)parentTitle)) {
            page.setParentTitle(parentTitle);
        }
        if (Validator.isNotNull((String)redirectTitle)) {
            page.setRedirectTitle(redirectTitle);
        }
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)oldPage.getExpandoBridge(), (ExpandoBridge)page.getExpandoBridge(), (ServiceContext)serviceContext);
        page = (WikiPage)this.wikiPagePersistence.update((BaseModel)page);
        this.wikiPageLocalService.updateLastPostDate(nodeId, serviceContext.getModifiedDate(now));
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return this._startWorkflowInstance(userId, page, serviceContext);
    }

    private void _validate(long nodeId, String content, String format) throws PortalException {
        WikiEngine wikiEngine = this._wikiEngineRenderer.fetchWikiEngine(format);
        if (!wikiEngine.validate(nodeId, content)) {
            throw new PageContentException();
        }
    }

    private void _validate(String title2, long nodeId, String content, String format) throws PortalException {
        if (Validator.isNull((String)title2)) {
            throw new PageTitleException();
        }
        if (this._isUsedTitle(nodeId, title2)) {
            throw new DuplicatePageException("{nodeId=" + nodeId + "}");
        }
        this._wikiPageTitleValidator.validate(title2);
        this._validate(nodeId, content, format);
    }
}

