/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.impl.WikiNodeImpl;
import com.liferay.wiki.model.impl.WikiNodeModelImpl;
import com.liferay.wiki.service.persistence.WikiNodePersistence;
import com.liferay.wiki.service.persistence.impl.constants.WikiPersistenceConstants;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WikiNodePersistence.class})
public class WikiNodePersistenceImpl
extends BasePersistenceImpl<WikiNode>
implements WikiNodePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = WikiNodeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "wikiNode.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "wikiNode.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "wikiNode.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "wikiNode.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "wikiNode.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "wikiNode.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "wikiNode.companyId = ?";
    private FinderPath _finderPathFetchByG_N;
    private FinderPath _finderPathCountByG_N;
    private static final String _FINDER_COLUMN_G_N_GROUPID_2 = "wikiNode.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_NAME_2 = "wikiNode.name = ?";
    private static final String _FINDER_COLUMN_G_N_NAME_3 = "(wikiNode.name IS NULL OR wikiNode.name = '')";
    private FinderPath _finderPathWithPaginationFindByG_S;
    private FinderPath _finderPathWithoutPaginationFindByG_S;
    private FinderPath _finderPathCountByG_S;
    private static final String _FINDER_COLUMN_G_S_GROUPID_2 = "wikiNode.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_S_STATUS_2 = "wikiNode.status = ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "wikiNode.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_STATUS_2 = "wikiNode.status = ?";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_WIKINODE = "SELECT wikiNode FROM WikiNode wikiNode";
    private static final String _SQL_SELECT_WIKINODE_WHERE = "SELECT wikiNode FROM WikiNode wikiNode WHERE ";
    private static final String _SQL_COUNT_WIKINODE = "SELECT COUNT(wikiNode) FROM WikiNode wikiNode";
    private static final String _SQL_COUNT_WIKINODE_WHERE = "SELECT COUNT(wikiNode) FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "wikiNode.nodeId";
    private static final String _FILTER_SQL_SELECT_WIKINODE_WHERE = "SELECT DISTINCT {wikiNode.*} FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {WikiNode.*} FROM (SELECT DISTINCT wikiNode.nodeId FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN WikiNode ON TEMP_TABLE.nodeId = WikiNode.nodeId";
    private static final String _FILTER_SQL_COUNT_WIKINODE_WHERE = "SELECT COUNT(DISTINCT wikiNode.nodeId) AS COUNT_VALUE FROM WikiNode wikiNode WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "wikiNode";
    private static final String _FILTER_ENTITY_TABLE = "WikiNode";
    private static final String _ORDER_BY_ENTITY_ALIAS = "wikiNode.";
    private static final String _ORDER_BY_ENTITY_TABLE = "WikiNode.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WikiNode exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WikiNode exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(WikiNodePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<WikiNode> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (uuid.equals(wikiNode.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByUuid_First(String uuid, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_First(uuid, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByUuid_First(String uuid, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByUuid_Last(String uuid, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_Last(uuid, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByUuid_Last(String uuid, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByUuid_PrevAndNext(long nodeId, String uuid, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        uuid = Objects.toString(uuid, "");
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByUuid_PrevAndNext(session, wikiNode, uuid, orderByComparator, true), wikiNode, this.getByUuid_PrevAndNext(session, wikiNode, uuid, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByUuid_PrevAndNext(Session session, WikiNode wikiNode, String uuid, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_WIKINODE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (WikiNode wikiNode : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiNode findByUUID_G(String uuid, long groupId) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUUID_G(uuid, groupId);
        if (wikiNode == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchNodeException(sb.toString());
        }
        return wikiNode;
    }

    public WikiNode fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public WikiNode fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        WikiNode wikiNode;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiNode && (!Objects.equals(uuid, (wikiNode = (WikiNode)result).getUuid()) || groupId != wikiNode.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiNode.uuid = ? AND ");
            }
            sb.append("wikiNode.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    WikiNode wikiNode2 = (WikiNode)list.get(0);
                    result = wikiNode2;
                    this.cacheResult(wikiNode2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiNode)result;
    }

    public WikiNode removeByUUID_G(String uuid, long groupId) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByUUID_G(uuid, groupId);
        return (WikiNode)this.remove((BaseModel)wikiNode);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiNode.uuid = ? AND ");
            }
            sb.append("wikiNode.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (uuid.equals(wikiNode.getUuid()) && companyId == wikiNode.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiNode.uuid = ? AND ");
            }
            sb.append("wikiNode.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByUuid_C_PrevAndNext(long nodeId, String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        uuid = Objects.toString(uuid, "");
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByUuid_C_PrevAndNext(session, wikiNode, uuid, companyId, orderByComparator, true), wikiNode, this.getByUuid_C_PrevAndNext(session, wikiNode, uuid, companyId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByUuid_C_PrevAndNext(Session session, WikiNode wikiNode, String uuid, long companyId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_WIKINODE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("wikiNode.uuid = ? AND ");
        }
        sb.append("wikiNode.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (WikiNode wikiNode : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiNode.uuid IS NULL OR wikiNode.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiNode.uuid = ? AND ");
            }
            sb.append("wikiNode.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiNode> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (groupId == wikiNode.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            sb.append("wikiNode.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByGroupId_First(long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByGroupId_First(groupId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByGroupId_First(long groupId, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByGroupId_Last(long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByGroupId_Last(long groupId, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByGroupId_PrevAndNext(long nodeId, long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, true), wikiNode, this.getByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByGroupId_PrevAndNext(Session session, WikiNode wikiNode, long groupId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_WIKINODE_WHERE);
        sb.append("wikiNode.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public List<WikiNode> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<WikiNode> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<WikiNode> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("wikiNode.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY wikiNode.name ASC");
        } else {
            sb.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode[] filterFindByGroupId_PrevAndNext(long nodeId, long groupId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId_PrevAndNext(nodeId, groupId, orderByComparator);
        }
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.filterGetByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, true), wikiNode, this.filterGetByGroupId_PrevAndNext(session, wikiNode, groupId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode filterGetByGroupId_PrevAndNext(Session session, WikiNode wikiNode, long groupId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("wikiNode.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i2], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i2], true));
                }
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i3], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i3], true));
                }
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY wikiNode.name ASC");
        } else {
            sb.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (WikiNode wikiNode : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            sb.append("wikiNode.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_WIKINODE_WHERE);
        sb.append("wikiNode.groupId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiNode> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (companyId == wikiNode.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            sb.append("wikiNode.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByCompanyId_First(long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByCompanyId_First(long companyId, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByCompanyId_Last(long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByCompanyId_Last(long companyId, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByCompanyId_PrevAndNext(long nodeId, long companyId, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByCompanyId_PrevAndNext(session, wikiNode, companyId, orderByComparator, true), wikiNode, this.getByCompanyId_PrevAndNext(session, wikiNode, companyId, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByCompanyId_PrevAndNext(Session session, WikiNode wikiNode, long companyId, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_WIKINODE_WHERE);
        sb.append("wikiNode.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (WikiNode wikiNode : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            sb.append("wikiNode.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiNode findByG_N(long groupId, String name) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByG_N(groupId, name);
        if (wikiNode == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", name=");
            sb.append(name);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchNodeException(sb.toString());
        }
        return wikiNode;
    }

    public WikiNode fetchByG_N(long groupId, String name) {
        return this.fetchByG_N(groupId, name, true);
    }

    public WikiNode fetchByG_N(long groupId, String name, boolean useFinderCache) {
        WikiNode wikiNode;
        name = Objects.toString(name, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId, name};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_N, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiNode && (groupId != (wikiNode = (WikiNode)result).getGroupId() || !Objects.equals(name, wikiNode.getName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            sb.append("wikiNode.groupId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                sb.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindName) {
                    queryPos.add(name);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByG_N, finderArgs, (Object)list);
                    }
                } else {
                    WikiNode wikiNode2 = (WikiNode)list.get(0);
                    result = wikiNode2;
                    this.cacheResult(wikiNode2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByG_N, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiNode)result;
    }

    public WikiNode removeByG_N(long groupId, String name) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByG_N(groupId, name);
        return (WikiNode)this.remove((BaseModel)wikiNode);
    }

    public int countByG_N(long groupId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathCountByG_N;
        Object[] finderArgs = new Object[]{groupId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            sb.append("wikiNode.groupId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                sb.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindName) {
                    queryPos.add(name);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiNode> findByG_S(long groupId, int status) {
        return this.findByG_S(groupId, status, -1, -1, null);
    }

    public List<WikiNode> findByG_S(long groupId, int status, int start, int end) {
        return this.findByG_S(groupId, status, start, end, null);
    }

    public List<WikiNode> findByG_S(long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByG_S(groupId, status, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByG_S(long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_S;
                finderArgs = new Object[]{groupId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_S;
            finderArgs = new Object[]{groupId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (groupId == wikiNode.getGroupId() && status == wikiNode.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            sb.append("wikiNode.groupId = ? AND ");
            sb.append("wikiNode.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByG_S_First(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByG_S_First(groupId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByG_S_First(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByG_S(groupId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByG_S_Last(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByG_S_Last(groupId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByG_S_Last(long groupId, int status, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByG_S(groupId, status);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByG_S(groupId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByG_S_PrevAndNext(long nodeId, long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, true), wikiNode, this.getByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByG_S_PrevAndNext(Session session, WikiNode wikiNode, long groupId, int status, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_WIKINODE_WHERE);
        sb.append("wikiNode.groupId = ? AND ");
        sb.append("wikiNode.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public List<WikiNode> filterFindByG_S(long groupId, int status) {
        return this.filterFindByG_S(groupId, status, -1, -1, null);
    }

    public List<WikiNode> filterFindByG_S(long groupId, int status, int start, int end) {
        return this.filterFindByG_S(groupId, status, start, end, null);
    }

    public List<WikiNode> filterFindByG_S(long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_S(groupId, status, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("wikiNode.groupId = ? AND ");
        sb.append("wikiNode.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY wikiNode.name ASC");
        } else {
            sb.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(status);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode[] filterFindByG_S_PrevAndNext(long nodeId, long groupId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_S_PrevAndNext(nodeId, groupId, status, orderByComparator);
        }
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.filterGetByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, true), wikiNode, this.filterGetByG_S_PrevAndNext(session, wikiNode, groupId, status, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode filterGetByG_S_PrevAndNext(Session session, WikiNode wikiNode, long groupId, int status, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("wikiNode.groupId = ? AND ");
        sb.append("wikiNode.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_WIKINODE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i2], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i2], true));
                }
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i3], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i3], true));
                }
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY wikiNode.name ASC");
        } else {
            sb.append(" ORDER BY WikiNode.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, WikiNodeImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, WikiNodeImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(groupId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByG_S(long groupId, int status) {
        for (WikiNode wikiNode : this.findByG_S(groupId, status, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByG_S(long groupId, int status) {
        FinderPath finderPath = this._finderPathCountByG_S;
        Object[] finderArgs = new Object[]{groupId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            sb.append("wikiNode.groupId = ? AND ");
            sb.append("wikiNode.status = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_S(long groupId, int status) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_S(groupId, status);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_WIKINODE_WHERE);
        sb.append("wikiNode.groupId = ? AND ");
        sb.append("wikiNode.status = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)WikiNode.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(status);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiNode> findByC_S(long companyId, int status) {
        return this.findByC_S(companyId, status, -1, -1, null);
    }

    public List<WikiNode> findByC_S(long companyId, int status, int start, int end) {
        return this.findByC_S(companyId, status, start, end, null);
    }

    public List<WikiNode> findByC_S(long companyId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findByC_S(companyId, status, start, end, orderByComparator, true);
    }

    public List<WikiNode> findByC_S(long companyId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{companyId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{companyId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiNode wikiNode : list) {
                if (companyId == wikiNode.getCompanyId() && status == wikiNode.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_WIKINODE_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            sb.append("wikiNode.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiNode findByC_S_First(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByC_S_First(companyId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByC_S_First(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) {
        List<WikiNode> list = this.findByC_S(companyId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode findByC_S_Last(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.fetchByC_S_Last(companyId, status, orderByComparator);
        if (wikiNode != null) {
            return wikiNode;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchNodeException(sb.toString());
    }

    public WikiNode fetchByC_S_Last(long companyId, int status, OrderByComparator<WikiNode> orderByComparator) {
        int count = this.countByC_S(companyId, status);
        if (count == 0) {
            return null;
        }
        List<WikiNode> list = this.findByC_S(companyId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiNode[] findByC_S_PrevAndNext(long nodeId, long companyId, int status, OrderByComparator<WikiNode> orderByComparator) throws NoSuchNodeException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        Session session = null;
        try {
            session = this.openSession();
            WikiNode[] array = new WikiNodeImpl[]{this.getByC_S_PrevAndNext(session, wikiNode, companyId, status, orderByComparator, true), wikiNode, this.getByC_S_PrevAndNext(session, wikiNode, companyId, status, orderByComparator, false)};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode getByC_S_PrevAndNext(Session session, WikiNode wikiNode, long companyId, int status, OrderByComparator<WikiNode> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_WIKINODE_WHERE);
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        sb.append("wikiNode.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiNode.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiNode)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiNode)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long companyId, int status) {
        for (WikiNode wikiNode : this.findByC_S(companyId, status, -1, -1, null)) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countByC_S(long companyId, int status) {
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{companyId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKINODE_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            sb.append("wikiNode.status = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiNodePersistenceImpl() {
        this.setModelClass(WikiNode.class);
        this.setModelImplClass(WikiNodeImpl.class);
        this.setModelPKClass(Long.TYPE);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
    }

    public void cacheResult(WikiNode wikiNode) {
        this.entityCache.putResult(this.entityCacheEnabled, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (Serializable)wikiNode);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{wikiNode.getUuid(), wikiNode.getGroupId()}, (Object)wikiNode);
        this.finderCache.putResult(this._finderPathFetchByG_N, new Object[]{wikiNode.getGroupId(), wikiNode.getName()}, (Object)wikiNode);
        wikiNode.resetOriginalValues();
    }

    public void cacheResult(List<WikiNode> wikiNodes) {
        for (WikiNode wikiNode : wikiNodes) {
            if (this.entityCache.getResult(this.entityCacheEnabled, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey())) == null) {
                this.cacheResult(wikiNode);
                continue;
            }
            wikiNode.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(WikiNodeImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(WikiNode wikiNode) {
        this.entityCache.removeResult(this.entityCacheEnabled, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((WikiNodeModelImpl)wikiNode, true);
    }

    public void clearCache(List<WikiNode> wikiNodes) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (WikiNode wikiNode : wikiNodes) {
            this.entityCache.removeResult(this.entityCacheEnabled, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()));
            this.clearUniqueFindersCache((WikiNodeModelImpl)wikiNode, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, WikiNodeImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(WikiNodeModelImpl wikiNodeModelImpl) {
        Object[] args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)wikiNodeModelImpl, false);
        args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getName()};
        this.finderCache.putResult(this._finderPathCountByG_N, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByG_N, args, (Object)wikiNodeModelImpl, false);
    }

    protected void clearUniqueFindersCache(WikiNodeModelImpl wikiNodeModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiNodeModelImpl.getOriginalUuid(), wikiNodeModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getName()};
            this.finderCache.removeResult(this._finderPathCountByG_N, args);
            this.finderCache.removeResult(this._finderPathFetchByG_N, args);
        }
        if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathFetchByG_N.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiNodeModelImpl.getOriginalGroupId(), wikiNodeModelImpl.getOriginalName()};
            this.finderCache.removeResult(this._finderPathCountByG_N, args);
            this.finderCache.removeResult(this._finderPathFetchByG_N, args);
        }
    }

    public WikiNode create(long nodeId) {
        WikiNodeImpl wikiNode = new WikiNodeImpl();
        wikiNode.setNew(true);
        wikiNode.setPrimaryKey(nodeId);
        String uuid = PortalUUIDUtil.generate();
        wikiNode.setUuid(uuid);
        wikiNode.setCompanyId(CompanyThreadLocal.getCompanyId());
        return wikiNode;
    }

    public WikiNode remove(long nodeId) throws NoSuchNodeException {
        return this.remove(Long.valueOf(nodeId));
    }

    public WikiNode remove(Serializable primaryKey) throws NoSuchNodeException {
        Session session = null;
        try {
            session = this.openSession();
            WikiNode wikiNode = (WikiNode)session.get(WikiNodeImpl.class, primaryKey);
            if (wikiNode == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            WikiNode wikiNode2 = (WikiNode)this.remove((BaseModel)wikiNode);
            return wikiNode2;
        }
        catch (NoSuchNodeException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiNode removeImpl(WikiNode wikiNode) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)wikiNode)) {
                wikiNode = (WikiNode)session.get(WikiNodeImpl.class, wikiNode.getPrimaryKeyObj());
            }
            if (wikiNode != null) {
                session.delete((Object)wikiNode);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (wikiNode != null) {
            this.clearCache(wikiNode);
        }
        return wikiNode;
    }

    public WikiNode updateImpl(WikiNode wikiNode) {
        boolean isNew = wikiNode.isNew();
        if (!(wikiNode instanceof WikiNodeModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(wikiNode.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)wikiNode);
                throw new IllegalArgumentException("Implement ModelWrapper in wikiNode proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom WikiNode implementation " + wikiNode.getClass());
        }
        WikiNodeModelImpl wikiNodeModelImpl = (WikiNodeModelImpl)wikiNode;
        if (Validator.isNull((String)wikiNode.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            wikiNode.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && wikiNode.getCreateDate() == null) {
            if (serviceContext == null) {
                wikiNode.setCreateDate(now);
            } else {
                wikiNode.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!wikiNodeModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                wikiNode.setModifiedDate(now);
            } else {
                wikiNode.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (wikiNode.isNew()) {
                session.save((Object)wikiNode);
                wikiNode.setNew(false);
            } else {
                wikiNode = (WikiNode)session.merge((Object)wikiNode);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{wikiNodeModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{wikiNodeModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{wikiNodeModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getStatus()};
            this.finderCache.removeResult(this._finderPathCountByG_S, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_S, args);
            args = new Object[]{wikiNodeModelImpl.getCompanyId(), wikiNodeModelImpl.getStatus()};
            this.finderCache.removeResult(this._finderPathCountByC_S, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{wikiNodeModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalUuid(), wikiNodeModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{wikiNodeModelImpl.getUuid(), wikiNodeModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{wikiNodeModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{wikiNodeModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_S.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalGroupId(), wikiNodeModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(this._finderPathCountByG_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_S, args);
                args = new Object[]{wikiNodeModelImpl.getGroupId(), wikiNodeModelImpl.getStatus()};
                this.finderCache.removeResult(this._finderPathCountByG_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_S, args);
            }
            if ((wikiNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_S.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiNodeModelImpl.getOriginalCompanyId(), wikiNodeModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(this._finderPathCountByC_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
                args = new Object[]{wikiNodeModelImpl.getCompanyId(), wikiNodeModelImpl.getStatus()};
                this.finderCache.removeResult(this._finderPathCountByC_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (Serializable)wikiNode, false);
        this.clearUniqueFindersCache(wikiNodeModelImpl, false);
        this.cacheUniqueFindersCache(wikiNodeModelImpl);
        wikiNode.resetOriginalValues();
        return wikiNode;
    }

    public WikiNode findByPrimaryKey(Serializable primaryKey) throws NoSuchNodeException {
        WikiNode wikiNode = (WikiNode)this.fetchByPrimaryKey(primaryKey);
        if (wikiNode == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return wikiNode;
    }

    public WikiNode findByPrimaryKey(long nodeId) throws NoSuchNodeException {
        return this.findByPrimaryKey(Long.valueOf(nodeId));
    }

    public WikiNode fetchByPrimaryKey(long nodeId) {
        return (WikiNode)this.fetchByPrimaryKey(Long.valueOf(nodeId));
    }

    public List<WikiNode> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<WikiNode> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<WikiNode> findAll(int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<WikiNode> findAll(int start, int end, OrderByComparator<WikiNode> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_WIKINODE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_WIKINODE;
                sql = sql.concat(" ORDER BY wikiNode.name ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (WikiNode wikiNode : this.findAll()) {
            this.remove((BaseModel)wikiNode);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_WIKINODE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "nodeId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_WIKINODE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return WikiNodeModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        WikiNodeModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        WikiNodeModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 20L);
        this._finderPathCountByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
        this._finderPathCountByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 21L);
        this._finderPathCountByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByGroupId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 6L);
        this._finderPathCountByGroupId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 5L);
        this._finderPathCountByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathFetchByG_N = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N", new String[]{Long.class.getName(), String.class.getName()}, 6L);
        this._finderPathCountByG_N = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByG_S = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_S = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, 14L);
        this._finderPathCountByG_S = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()});
        this._finderPathWithPaginationFindByC_S = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_S = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Integer.class.getName()}, 13L);
        this._finderPathCountByC_S = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Integer.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(WikiNodeImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.wiki.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.wiki.model.WikiNode"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.wiki.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.wiki.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    static {
        try {
            Class.forName(WikiPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }
}

