/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.stringtemplate.language.GroupLexer;
import org.antlr.stringtemplate.language.GroupParser;

public class StringTemplateGroup {
    protected String name;
    protected Map templates = new HashMap();
    protected Map maps = new HashMap();
    protected Class templateLexerClass = null;
    protected static Class defaultTemplateLexerClass = DefaultTemplateLexer.class;
    protected String rootDir = null;
    protected static Map nameToGroupMap = Collections.synchronizedMap(new HashMap());
    protected static Map nameToInterfaceMap = Collections.synchronizedMap(new HashMap());
    protected StringTemplateGroup superGroup = null;
    protected List interfaces = null;
    protected boolean templatesDefinedInGroupFile = false;
    protected Class userSpecifiedWriter;
    protected boolean debugTemplateOutput = false;
    protected Set noDebugStartStopStrings;
    protected Map attributeRenderers;
    private static StringTemplateGroupLoader groupLoader = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String string, Throwable throwable) {
            System.err.println(string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }

        public void warning(String string) {
            System.out.println(string);
        }
    };
    protected static final StringTemplate NOT_FOUND_ST = new StringTemplate();
    protected int refreshIntervalInSeconds = 2147483;
    protected long lastCheckedDisk = 0L;
    String fileCharEncoding = System.getProperty("file.encoding");

    public StringTemplateGroup(String string, String string2) {
        this(string, string2, DefaultTemplateLexer.class);
    }

    public StringTemplateGroup(String string, String string2, Class clazz) {
        this.name = string;
        this.rootDir = string2;
        this.lastCheckedDisk = System.currentTimeMillis();
        nameToGroupMap.put(string, this);
        this.templateLexerClass = clazz;
    }

    public StringTemplateGroup(String string) {
        this(string, null, null);
    }

    public StringTemplateGroup(String string, Class clazz) {
        this(string, null, clazz);
    }

    public StringTemplateGroup(Reader reader) {
        this(reader, AngleBracketTemplateLexer.class, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroup(Reader reader, StringTemplateErrorListener stringTemplateErrorListener) {
        this(reader, AngleBracketTemplateLexer.class, stringTemplateErrorListener, null);
    }

    public StringTemplateGroup(Reader reader, Class clazz) {
        this(reader, clazz, null, null);
    }

    public StringTemplateGroup(Reader reader, Class clazz, StringTemplateErrorListener stringTemplateErrorListener) {
        this(reader, clazz, stringTemplateErrorListener, null);
    }

    public StringTemplateGroup(Reader reader, Class clazz, StringTemplateErrorListener stringTemplateErrorListener, StringTemplateGroup stringTemplateGroup) {
        this.templatesDefinedInGroupFile = true;
        this.templateLexerClass = clazz;
        if (stringTemplateErrorListener != null) {
            this.listener = stringTemplateErrorListener;
        }
        this.setSuperGroup(stringTemplateGroup);
        this.parseGroup(reader);
        this.verifyInterfaceImplementations();
    }

    public Class getTemplateLexerClass() {
        if (this.templateLexerClass != null) {
            return this.templateLexerClass;
        }
        return defaultTemplateLexerClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSuperGroup(StringTemplateGroup stringTemplateGroup) {
        this.superGroup = stringTemplateGroup;
    }

    public void setSuperGroup(String string) {
        StringTemplateGroup stringTemplateGroup = (StringTemplateGroup)nameToGroupMap.get(string);
        if (stringTemplateGroup != null) {
            this.setSuperGroup(stringTemplateGroup);
            return;
        }
        stringTemplateGroup = StringTemplateGroup.loadGroup(string);
        if (stringTemplateGroup != null) {
            nameToGroupMap.put(string, stringTemplateGroup);
            this.setSuperGroup(stringTemplateGroup);
        } else if (groupLoader == null) {
            this.listener.error("no group loader registered", null);
        }
    }

    public void implementInterface(StringTemplateGroupInterface stringTemplateGroupInterface) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList();
        }
        this.interfaces.add(stringTemplateGroupInterface);
    }

    public void implementInterface(String string) {
        StringTemplateGroupInterface stringTemplateGroupInterface = (StringTemplateGroupInterface)nameToInterfaceMap.get(string);
        if (stringTemplateGroupInterface != null) {
            this.implementInterface(stringTemplateGroupInterface);
            return;
        }
        stringTemplateGroupInterface = StringTemplateGroup.loadInterface(string);
        if (stringTemplateGroupInterface != null) {
            nameToInterfaceMap.put(string, stringTemplateGroupInterface);
            this.implementInterface(stringTemplateGroupInterface);
        } else if (groupLoader == null) {
            this.listener.error("no group loader registered", null);
        }
    }

    public StringTemplateGroup getSuperGroup() {
        return this.superGroup;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String string) {
        this.rootDir = string;
    }

    public StringTemplate createStringTemplate() {
        StringTemplate stringTemplate = new StringTemplate();
        return stringTemplate;
    }

    protected StringTemplate getInstanceOf(StringTemplate stringTemplate, String string) throws IllegalArgumentException {
        StringTemplate stringTemplate2 = this.lookupTemplate(stringTemplate, string);
        if (stringTemplate2 != null) {
            StringTemplate stringTemplate3 = stringTemplate2.getInstanceOf();
            return stringTemplate3;
        }
        return null;
    }

    public StringTemplate getInstanceOf(String string) {
        return this.getInstanceOf(null, string);
    }

    public StringTemplate getInstanceOf(String string, Map map2) {
        StringTemplate stringTemplate = this.getInstanceOf(string);
        stringTemplate.attributes = map2;
        return stringTemplate;
    }

    public StringTemplate getEmbeddedInstanceOf(StringTemplate stringTemplate, String string) throws IllegalArgumentException {
        StringTemplate stringTemplate2 = null;
        stringTemplate2 = string.startsWith("super.") ? stringTemplate.getNativeGroup().getInstanceOf(stringTemplate, string) : this.getInstanceOf(stringTemplate, string);
        stringTemplate2.setGroup(this);
        stringTemplate2.setEnclosingInstance(stringTemplate);
        return stringTemplate2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized StringTemplate lookupTemplate(StringTemplate stringTemplate, String string) throws IllegalArgumentException {
        if (string.startsWith("super.")) {
            if (this.superGroup == null) throw new IllegalArgumentException(this.getName() + " has no super group; invalid template: " + string);
            int n = string.indexOf(46);
            string = string.substring(n + 1, string.length());
            return this.superGroup.lookupTemplate(stringTemplate, string);
        }
        this.checkRefreshInterval();
        StringTemplate stringTemplate2 = (StringTemplate)this.templates.get(string);
        if (stringTemplate2 == null) {
            if (!this.templatesDefinedInGroupFile) {
                stringTemplate2 = this.loadTemplateFromBeneathRootDirOrCLASSPATH(this.getFileNameFromTemplateName(string));
            }
            if (stringTemplate2 == null && this.superGroup != null && (stringTemplate2 = this.superGroup.getInstanceOf(string)) != null) {
                stringTemplate2.setGroup(this);
            }
            if (stringTemplate2 == null) {
                this.templates.put(string, NOT_FOUND_ST);
                String string2 = "";
                if (stringTemplate == null) throw new IllegalArgumentException("Can't find template " + this.getFileNameFromTemplateName(string) + string2);
                string2 = "; context is " + stringTemplate.getEnclosingInstanceStackString();
                throw new IllegalArgumentException("Can't find template " + this.getFileNameFromTemplateName(string) + string2);
            }
        } else {
            if (stringTemplate2 != NOT_FOUND_ST) return stringTemplate2;
            return null;
        }
        this.templates.put(string, stringTemplate2);
        return stringTemplate2;
    }

    public StringTemplate lookupTemplate(String string) {
        return this.lookupTemplate(null, string);
    }

    protected void checkRefreshInterval() {
        boolean bl;
        if (this.templatesDefinedInGroupFile) {
            return;
        }
        boolean bl2 = bl = this.refreshIntervalInSeconds == 0 || System.currentTimeMillis() - this.lastCheckedDisk >= (long)(this.refreshIntervalInSeconds * 1000);
        if (bl) {
            this.templates.clear();
            this.lastCheckedDisk = System.currentTimeMillis();
        }
    }

    protected StringTemplate loadTemplate(String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(300);
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string3);
        }
        String string4 = stringBuffer.toString().trim();
        if (string4.length() == 0) {
            this.error("no text in template '" + string + "'");
            return null;
        }
        return this.defineTemplate(string, string4);
    }

    protected StringTemplate loadTemplateFromBeneathRootDirOrCLASSPATH(String string) {
        StringTemplate stringTemplate = null;
        String string2 = this.getTemplateNameFromFileName(string);
        if (this.rootDir == null) {
            block7: {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    classLoader = this.getClass().getClassLoader();
                    inputStream = classLoader.getResourceAsStream(string);
                }
                if (inputStream == null) {
                    return null;
                }
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(this.getInputStreamReader(inputStream));
                    stringTemplate = this.loadTemplate(string2, bufferedReader);
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    if (bufferedReader == null) break block7;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        this.error("Cannot close template file: " + string);
                    }
                }
            }
            return stringTemplate;
        }
        stringTemplate = this.loadTemplate(string2, this.rootDir + "/" + string);
        return stringTemplate;
    }

    public String getFileNameFromTemplateName(String string) {
        return string + ".st";
    }

    public String getTemplateNameFromFileName(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(".st");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected StringTemplate loadTemplate(String string, String string2) {
        StringTemplate stringTemplate;
        block4: {
            BufferedReader bufferedReader = null;
            stringTemplate = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                InputStreamReader inputStreamReader = this.getInputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                stringTemplate = this.loadTemplate(string, bufferedReader);
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException) {
                if (bufferedReader == null) break block4;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    this.error("Cannot close template file: " + string2);
                }
            }
        }
        return stringTemplate;
    }

    protected InputStreamReader getInputStreamReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return inputStreamReader;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String string) {
        this.fileCharEncoding = string;
    }

    public synchronized StringTemplate defineTemplate(String string, String string2) {
        if (string != null && string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in template names");
        }
        StringTemplate stringTemplate = this.createStringTemplate();
        stringTemplate.setName(string);
        stringTemplate.setGroup(this);
        stringTemplate.setNativeGroup(this);
        stringTemplate.setTemplate(string2);
        stringTemplate.setErrorListener(this.listener);
        this.templates.put(string, stringTemplate);
        return stringTemplate;
    }

    public StringTemplate defineRegionTemplate(String string, String string2, String string3, int n) {
        String string4 = this.getMangledRegionName(string, string2);
        StringTemplate stringTemplate = this.defineTemplate(string4, string3);
        stringTemplate.setIsRegion(true);
        stringTemplate.setRegionDefType(n);
        return stringTemplate;
    }

    public StringTemplate defineRegionTemplate(StringTemplate stringTemplate, String string, String string2, int n) {
        StringTemplate stringTemplate2 = this.defineRegionTemplate(stringTemplate.getOutermostName(), string, string2, n);
        stringTemplate.getOutermostEnclosingInstance().addRegionName(string);
        return stringTemplate2;
    }

    public StringTemplate defineImplicitRegionTemplate(StringTemplate stringTemplate, String string) {
        return this.defineRegionTemplate(stringTemplate, string, "", 1);
    }

    public String getMangledRegionName(String string, String string2) {
        return "region__" + string + "__" + string2;
    }

    public String getUnMangledTemplateName(String string) {
        return string.substring("region__".length(), string.lastIndexOf("__"));
    }

    public synchronized StringTemplate defineTemplateAlias(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateDefinition(string2);
        if (stringTemplate == null) {
            this.error("cannot alias " + string + " to undefined template: " + string2);
            return null;
        }
        this.templates.put(string, stringTemplate);
        return stringTemplate;
    }

    public synchronized boolean isDefinedInThisGroup(String string) {
        StringTemplate stringTemplate = (StringTemplate)this.templates.get(string);
        if (stringTemplate != null) {
            return !stringTemplate.isRegion() || stringTemplate.getRegionDefType() != 1;
        }
        return false;
    }

    public synchronized StringTemplate getTemplateDefinition(String string) {
        return (StringTemplate)this.templates.get(string);
    }

    public boolean isDefined(String string) {
        try {
            return this.lookupTemplate(string) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    protected void parseGroup(Reader reader) {
        try {
            GroupLexer groupLexer = new GroupLexer(reader);
            GroupParser groupParser = new GroupParser(groupLexer);
            groupParser.group(this);
        }
        catch (Exception exception) {
            String string = "<unknown>";
            if (this.getName() != null) {
                string = this.getName();
            }
            this.error("problem parsing group " + string + ": " + exception, exception);
        }
    }

    protected void verifyInterfaceImplementations() {
        for (int j = 0; this.interfaces != null && j < this.interfaces.size(); ++j) {
            StringTemplateGroupInterface stringTemplateGroupInterface = (StringTemplateGroupInterface)this.interfaces.get(j);
            List list = stringTemplateGroupInterface.getMissingTemplates(this);
            List list2 = stringTemplateGroupInterface.getMismatchedTemplates(this);
            if (list != null) {
                this.error("group " + this.getName() + " does not satisfy interface " + stringTemplateGroupInterface.getName() + ": missing templates " + list);
            }
            if (list2 == null) continue;
            this.error("group " + this.getName() + " does not satisfy interface " + stringTemplateGroupInterface.getName() + ": mismatched arguments on these templates " + list2);
        }
    }

    public int getRefreshInterval() {
        return this.refreshIntervalInSeconds;
    }

    public void setRefreshInterval(int n) {
        this.refreshIntervalInSeconds = n;
    }

    public void setErrorListener(StringTemplateErrorListener stringTemplateErrorListener) {
        this.listener = stringTemplateErrorListener;
    }

    public StringTemplateErrorListener getErrorListener() {
        return this.listener;
    }

    public void setStringTemplateWriter(Class clazz) {
        this.userSpecifiedWriter = clazz;
    }

    public StringTemplateWriter getStringTemplateWriter(Writer writer) {
        StringTemplateWriter stringTemplateWriter = null;
        if (this.userSpecifiedWriter != null) {
            try {
                Constructor constructor = this.userSpecifiedWriter.getConstructor(Writer.class);
                stringTemplateWriter = (StringTemplateWriter)constructor.newInstance(writer);
            }
            catch (Exception exception) {
                this.error("problems getting StringTemplateWriter", exception);
            }
        }
        if (stringTemplateWriter == null) {
            stringTemplateWriter = new AutoIndentWriter(writer);
        }
        return stringTemplateWriter;
    }

    public void setAttributeRenderers(Map map2) {
        this.attributeRenderers = map2;
    }

    public void registerRenderer(Class clazz, Object object2) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = Collections.synchronizedMap(new HashMap());
        }
        this.attributeRenderers.put(clazz, object2);
    }

    public AttributeRenderer getAttributeRenderer(Class clazz) {
        if (this.attributeRenderers == null) {
            if (this.superGroup == null) {
                return null;
            }
            return this.superGroup.getAttributeRenderer(clazz);
        }
        AttributeRenderer attributeRenderer = (AttributeRenderer)this.attributeRenderers.get(clazz);
        if (attributeRenderer == null && this.superGroup != null) {
            attributeRenderer = this.superGroup.getAttributeRenderer(clazz);
        }
        return attributeRenderer;
    }

    public Map getMap(String string) {
        if (this.maps == null) {
            if (this.superGroup == null) {
                return null;
            }
            return this.superGroup.getMap(string);
        }
        Map map2 = (Map)this.maps.get(string);
        if (map2 == null && this.superGroup != null) {
            map2 = this.superGroup.getMap(string);
        }
        return map2;
    }

    public void defineMap(String string, Map map2) {
        this.maps.put(string, map2);
    }

    public static void registerDefaultLexer(Class clazz) {
        defaultTemplateLexerClass = clazz;
    }

    public static void registerGroupLoader(StringTemplateGroupLoader stringTemplateGroupLoader) {
        groupLoader = stringTemplateGroupLoader;
    }

    public static StringTemplateGroup loadGroup(String string) {
        return StringTemplateGroup.loadGroup(string, null);
    }

    public static StringTemplateGroup loadGroup(String string, StringTemplateGroup stringTemplateGroup) {
        if (groupLoader != null) {
            return groupLoader.loadGroup(string, stringTemplateGroup);
        }
        return null;
    }

    public static StringTemplateGroupInterface loadInterface(String string) {
        if (groupLoader != null) {
            return groupLoader.loadInterface(string);
        }
        return null;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        if (this.listener != null) {
            this.listener.error(string, exception);
        } else {
            System.err.println("StringTemplate: " + string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized Set getTemplateNames() {
        return this.templates.keySet();
    }

    public void emitDebugStartStopStrings(boolean bl) {
        this.debugTemplateOutput = bl;
    }

    public void doNotEmitDebugStringsForTemplate(String string) {
        if (this.noDebugStartStopStrings == null) {
            this.noDebugStartStopStrings = new HashSet();
        }
        this.noDebugStartStopStrings.add(string);
    }

    public void emitTemplateStartDebugString(StringTemplate stringTemplate, StringTemplateWriter stringTemplateWriter) throws IOException {
        if (this.noDebugStartStopStrings == null || !this.noDebugStartStopStrings.contains(stringTemplate.getName())) {
            stringTemplateWriter.write("<" + stringTemplate.getName() + ">");
        }
    }

    public void emitTemplateStopDebugString(StringTemplate stringTemplate, StringTemplateWriter stringTemplateWriter) throws IOException {
        if (this.noDebugStartStopStrings == null || !this.noDebugStartStopStrings.contains(stringTemplate.getName())) {
            stringTemplateWriter.write("</" + stringTemplate.getName() + ">");
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.templates.keySet();
        ArrayList arrayList = new ArrayList(set);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        stringBuffer.append("group " + this.getName() + ";\n");
        StringTemplate stringTemplate = new StringTemplate("$args;separator=\",\"$");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTemplate stringTemplate2 = (StringTemplate)this.templates.get(string);
            if (stringTemplate2 == NOT_FOUND_ST) continue;
            stringTemplate = stringTemplate.getInstanceOf();
            stringTemplate.setAttribute("args", stringTemplate2.getFormalArguments());
            stringBuffer.append(string + "(" + stringTemplate + ")");
            if (bl) {
                stringBuffer.append(" ::= <<");
                stringBuffer.append(stringTemplate2.getTemplate());
                stringBuffer.append(">>\n");
                continue;
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

