/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.base.WikiNodeServiceBaseImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=wiki", "json.web.service.context.path=WikiNode"}, service={AopService.class})
public class WikiNodeServiceImpl
extends WikiNodeServiceBaseImpl {
    @Reference(target="(resource.name=com.liferay.wiki)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;

    public WikiNode addNode(String name, String description, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_NODE");
        return this.wikiNodeLocalService.addNode(this.getUserId(), name, description, serviceContext);
    }

    public void deleteNode(long nodeId) throws PortalException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "DELETE");
        this.wikiNodeLocalService.deleteNode(node);
    }

    public WikiNode getNode(long nodeId) throws PortalException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "VIEW");
        return node;
    }

    public WikiNode getNode(long groupId, String name) throws PortalException {
        WikiNode node = this.wikiNodeLocalService.getNode(groupId, name);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "VIEW");
        return node;
    }

    public List<WikiNode> getNodes(long groupId) throws PortalException {
        return this.getNodes(groupId, 0);
    }

    public List<WikiNode> getNodes(long groupId, int status) throws PortalException {
        ArrayList<WikiNode> nodes = this.wikiNodePersistence.filterFindByG_S(groupId, status);
        if (nodes.isEmpty()) {
            nodes = new ArrayList<WikiNode>();
            List allNodes = this.wikiNodeLocalService.getNodes(groupId, status);
            for (WikiNode node : allNodes) {
                if (!this._wikiNodeModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)node, "VIEW")) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) {
        return this.getNodes(groupId, 0, start, end);
    }

    public List<WikiNode> getNodes(long groupId, int status, int start, int end) {
        return this.wikiNodePersistence.filterFindByG_S(groupId, status, start, end);
    }

    public List<WikiNode> getNodes(long groupId, int status, int start, int end, OrderByComparator<WikiNode> obc) {
        return this.wikiNodePersistence.filterFindByG_S(groupId, status, start, end, obc);
    }

    public int getNodesCount(long groupId) {
        return this.getNodesCount(groupId, 0);
    }

    public int getNodesCount(long groupId, int status) {
        return this.wikiNodePersistence.filterCountByG_S(groupId, status);
    }

    public void importPages(long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "IMPORT");
        this.wikiNodeLocalService.importPages(this.getUserId(), nodeId, importer, inputStreams, options);
    }

    public WikiNode moveNodeToTrash(long nodeId) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "DELETE");
        return this.wikiNodeLocalService.moveNodeToTrash(this.getUserId(), nodeId);
    }

    public void restoreNodeFromTrash(long nodeId) throws PortalException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "DELETE");
        this.wikiNodeLocalService.restoreNodeFromTrash(this.getUserId(), node);
    }

    public void subscribeNode(long nodeId) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "SUBSCRIBE");
        this.wikiNodeLocalService.subscribeNode(this.getUserId(), nodeId);
    }

    public void unsubscribeNode(long nodeId) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "SUBSCRIBE");
        this.wikiNodeLocalService.unsubscribeNode(this.getUserId(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "UPDATE");
        return this.wikiNodeLocalService.updateNode(nodeId, name, description, serviceContext);
    }
}

