/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.wiki.exception.NoSuchPageResourceException;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.model.impl.WikiPageResourceImpl;
import com.liferay.wiki.model.impl.WikiPageResourceModelImpl;
import com.liferay.wiki.service.persistence.WikiPageResourcePersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WikiPageResourcePersistence.class})
public class WikiPageResourcePersistenceImpl
extends BasePersistenceImpl<WikiPageResource>
implements WikiPageResourcePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = WikiPageResourceImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "wikiPageResource.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "wikiPageResource.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "wikiPageResource.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "wikiPageResource.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "wikiPageResource.companyId = ?";
    private FinderPath _finderPathFetchByN_T;
    private FinderPath _finderPathCountByN_T;
    private static final String _FINDER_COLUMN_N_T_NODEID_2 = "wikiPageResource.nodeId = ? AND ";
    private static final String _FINDER_COLUMN_N_T_TITLE_2 = "wikiPageResource.title = ?";
    private static final String _FINDER_COLUMN_N_T_TITLE_3 = "(wikiPageResource.title IS NULL OR wikiPageResource.title = '')";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_WIKIPAGERESOURCE = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource";
    private static final String _SQL_SELECT_WIKIPAGERESOURCE_WHERE = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource WHERE ";
    private static final String _SQL_COUNT_WIKIPAGERESOURCE = "SELECT COUNT(wikiPageResource) FROM WikiPageResource wikiPageResource";
    private static final String _SQL_COUNT_WIKIPAGERESOURCE_WHERE = "SELECT COUNT(wikiPageResource) FROM WikiPageResource wikiPageResource WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "wikiPageResource.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WikiPageResource exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WikiPageResource exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(WikiPageResourcePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<WikiPageResource> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end, OrderByComparator<WikiPageResource> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end, OrderByComparator<WikiPageResource> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiPageResource wikiPageResource : list) {
                if (uuid.equals(wikiPageResource.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiPageResource findByUuid_First(String uuid, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_First(uuid, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchPageResourceException(sb.toString());
    }

    public WikiPageResource fetchByUuid_First(String uuid, OrderByComparator<WikiPageResource> orderByComparator) {
        List<WikiPageResource> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource findByUuid_Last(String uuid, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_Last(uuid, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchPageResourceException(sb.toString());
    }

    public WikiPageResource fetchByUuid_Last(String uuid, OrderByComparator<WikiPageResource> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<WikiPageResource> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource[] findByUuid_PrevAndNext(long resourcePrimKey, String uuid, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        uuid = Objects.toString(uuid, "");
        WikiPageResource wikiPageResource = this.findByPrimaryKey(resourcePrimKey);
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource[] array = new WikiPageResourceImpl[]{this.getByUuid_PrevAndNext(session, wikiPageResource, uuid, orderByComparator, true), wikiPageResource, this.getByUuid_PrevAndNext(session, wikiPageResource, uuid, orderByComparator, false)};
            WikiPageResource[] wikiPageResourceArray = array;
            return wikiPageResourceArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource getByUuid_PrevAndNext(Session session, WikiPageResource wikiPageResource, String uuid, OrderByComparator<WikiPageResource> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiPageResource)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiPageResource)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (WikiPageResource wikiPageResource : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiPageResource findByUUID_G(String uuid, long groupId) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUUID_G(uuid, groupId);
        if (wikiPageResource == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchPageResourceException(sb.toString());
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public WikiPageResource fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        WikiPageResource wikiPageResource;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiPageResource && (!Objects.equals(uuid, (wikiPageResource = (WikiPageResource)result).getUuid()) || groupId != wikiPageResource.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiPageResource.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    WikiPageResource wikiPageResource2 = (WikiPageResource)list.get(0);
                    result = wikiPageResource2;
                    this.cacheResult(wikiPageResource2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiPageResource)result;
    }

    public WikiPageResource removeByUUID_G(String uuid, long groupId) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.findByUUID_G(uuid, groupId);
        return (WikiPageResource)this.remove((BaseModel)wikiPageResource);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiPageResource.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiPageResource> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<WikiPageResource> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<WikiPageResource> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (WikiPageResource wikiPageResource : list) {
                if (uuid.equals(wikiPageResource.getUuid()) && companyId == wikiPageResource.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiPageResource.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiPageResource findByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchPageResourceException(sb.toString());
    }

    public WikiPageResource fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) {
        List<WikiPageResource> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource findByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (wikiPageResource != null) {
            return wikiPageResource;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchPageResourceException(sb.toString());
    }

    public WikiPageResource fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<WikiPageResource> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public WikiPageResource[] findByUuid_C_PrevAndNext(long resourcePrimKey, String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator) throws NoSuchPageResourceException {
        uuid = Objects.toString(uuid, "");
        WikiPageResource wikiPageResource = this.findByPrimaryKey(resourcePrimKey);
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource[] array = new WikiPageResourceImpl[]{this.getByUuid_C_PrevAndNext(session, wikiPageResource, uuid, companyId, orderByComparator, true), wikiPageResource, this.getByUuid_C_PrevAndNext(session, wikiPageResource, uuid, companyId, orderByComparator, false)};
            WikiPageResource[] wikiPageResourceArray = array;
            return wikiPageResourceArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource getByUuid_C_PrevAndNext(Session session, WikiPageResource wikiPageResource, String uuid, long companyId, OrderByComparator<WikiPageResource> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("wikiPageResource.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i2 = 0; i2 < orderByConditionFields.length; ++i2) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i3 = 0; i3 < orderByFields.length; ++i3) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY wikiPageResource.resourcePrimKey ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)wikiPageResource)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (WikiPageResource)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (WikiPageResource wikiPageResource : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("wikiPageResource.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiPageResource findByN_T(long nodeId, String title2) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.fetchByN_T(nodeId, title2);
        if (wikiPageResource == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("nodeId=");
            sb.append(nodeId);
            sb.append(", title=");
            sb.append(title2);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchPageResourceException(sb.toString());
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByN_T(long nodeId, String title2) {
        return this.fetchByN_T(nodeId, title2, true);
    }

    public WikiPageResource fetchByN_T(long nodeId, String title2, boolean useFinderCache) {
        WikiPageResource wikiPageResource;
        title2 = Objects.toString(title2, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{nodeId, title2};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByN_T, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof WikiPageResource && (nodeId != (wikiPageResource = (WikiPageResource)result).getNodeId() || !Objects.equals(title2, wikiPageResource.getTitle()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            sb.append(_FINDER_COLUMN_N_T_NODEID_2);
            boolean bindTitle = false;
            if (title2.isEmpty()) {
                sb.append(_FINDER_COLUMN_N_T_TITLE_3);
            } else {
                bindTitle = true;
                sb.append(_FINDER_COLUMN_N_T_TITLE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(nodeId);
                if (bindTitle) {
                    queryPos.add(title2);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByN_T, finderArgs, (Object)list);
                    }
                } else {
                    WikiPageResource wikiPageResource2 = (WikiPageResource)list.get(0);
                    result = wikiPageResource2;
                    this.cacheResult(wikiPageResource2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByN_T, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiPageResource)result;
    }

    public WikiPageResource removeByN_T(long nodeId, String title2) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = this.findByN_T(nodeId, title2);
        return (WikiPageResource)this.remove((BaseModel)wikiPageResource);
    }

    public int countByN_T(long nodeId, String title2) {
        title2 = Objects.toString(title2, "");
        FinderPath finderPath = this._finderPathCountByN_T;
        Object[] finderArgs = new Object[]{nodeId, title2};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            sb.append(_FINDER_COLUMN_N_T_NODEID_2);
            boolean bindTitle = false;
            if (title2.isEmpty()) {
                sb.append(_FINDER_COLUMN_N_T_TITLE_3);
            } else {
                bindTitle = true;
                sb.append(_FINDER_COLUMN_N_T_TITLE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(nodeId);
                if (bindTitle) {
                    queryPos.add(title2);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public WikiPageResourcePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(WikiPageResource.class);
        this.setModelImplClass(WikiPageResourceImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(WikiPageResource wikiPageResource) {
        this.entityCache.putResult(this.entityCacheEnabled, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (Serializable)wikiPageResource);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{wikiPageResource.getUuid(), wikiPageResource.getGroupId()}, (Object)wikiPageResource);
        this.finderCache.putResult(this._finderPathFetchByN_T, new Object[]{wikiPageResource.getNodeId(), wikiPageResource.getTitle()}, (Object)wikiPageResource);
        wikiPageResource.resetOriginalValues();
    }

    public void cacheResult(List<WikiPageResource> wikiPageResources) {
        for (WikiPageResource wikiPageResource : wikiPageResources) {
            if (this.entityCache.getResult(this.entityCacheEnabled, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey())) == null) {
                this.cacheResult(wikiPageResource);
                continue;
            }
            wikiPageResource.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(WikiPageResourceImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(WikiPageResource wikiPageResource) {
        this.entityCache.removeResult(this.entityCacheEnabled, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((WikiPageResourceModelImpl)wikiPageResource, true);
    }

    public void clearCache(List<WikiPageResource> wikiPageResources) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (WikiPageResource wikiPageResource : wikiPageResources) {
            this.entityCache.removeResult(this.entityCacheEnabled, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()));
            this.clearUniqueFindersCache((WikiPageResourceModelImpl)wikiPageResource, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, WikiPageResourceImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(WikiPageResourceModelImpl wikiPageResourceModelImpl) {
        Object[] args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)wikiPageResourceModelImpl, false);
        args = new Object[]{wikiPageResourceModelImpl.getNodeId(), wikiPageResourceModelImpl.getTitle()};
        this.finderCache.putResult(this._finderPathCountByN_T, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByN_T, args, (Object)wikiPageResourceModelImpl, false);
    }

    protected void clearUniqueFindersCache(WikiPageResourceModelImpl wikiPageResourceModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((wikiPageResourceModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiPageResourceModelImpl.getOriginalUuid(), wikiPageResourceModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{wikiPageResourceModelImpl.getNodeId(), wikiPageResourceModelImpl.getTitle()};
            this.finderCache.removeResult(this._finderPathCountByN_T, args);
            this.finderCache.removeResult(this._finderPathFetchByN_T, args);
        }
        if ((wikiPageResourceModelImpl.getColumnBitmask() & this._finderPathFetchByN_T.getColumnBitmask()) != 0L) {
            args = new Object[]{wikiPageResourceModelImpl.getOriginalNodeId(), wikiPageResourceModelImpl.getOriginalTitle()};
            this.finderCache.removeResult(this._finderPathCountByN_T, args);
            this.finderCache.removeResult(this._finderPathFetchByN_T, args);
        }
    }

    public WikiPageResource create(long resourcePrimKey) {
        WikiPageResourceImpl wikiPageResource = new WikiPageResourceImpl();
        wikiPageResource.setNew(true);
        wikiPageResource.setPrimaryKey(resourcePrimKey);
        String uuid = PortalUUIDUtil.generate();
        wikiPageResource.setUuid(uuid);
        wikiPageResource.setCompanyId(CompanyThreadLocal.getCompanyId());
        return wikiPageResource;
    }

    public WikiPageResource remove(long resourcePrimKey) throws NoSuchPageResourceException {
        return this.remove(Long.valueOf(resourcePrimKey));
    }

    public WikiPageResource remove(Serializable primaryKey) throws NoSuchPageResourceException {
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, primaryKey);
            if (wikiPageResource == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchPageResourceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            WikiPageResource wikiPageResource2 = (WikiPageResource)this.remove((BaseModel)wikiPageResource);
            return wikiPageResource2;
        }
        catch (NoSuchPageResourceException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource removeImpl(WikiPageResource wikiPageResource) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)wikiPageResource)) {
                wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, wikiPageResource.getPrimaryKeyObj());
            }
            if (wikiPageResource != null) {
                session.delete((Object)wikiPageResource);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (wikiPageResource != null) {
            this.clearCache(wikiPageResource);
        }
        return wikiPageResource;
    }

    public WikiPageResource updateImpl(WikiPageResource wikiPageResource) {
        boolean isNew = wikiPageResource.isNew();
        if (!(wikiPageResource instanceof WikiPageResourceModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(wikiPageResource.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)wikiPageResource);
                throw new IllegalArgumentException("Implement ModelWrapper in wikiPageResource proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom WikiPageResource implementation " + wikiPageResource.getClass());
        }
        WikiPageResourceModelImpl wikiPageResourceModelImpl = (WikiPageResourceModelImpl)wikiPageResource;
        if (Validator.isNull((String)wikiPageResource.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            wikiPageResource.setUuid(uuid);
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)wikiPageResource);
                wikiPageResource.setNew(false);
            } else {
                wikiPageResource = (WikiPageResource)session.merge((Object)wikiPageResource);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{wikiPageResourceModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((wikiPageResourceModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiPageResourceModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{wikiPageResourceModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((wikiPageResourceModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{wikiPageResourceModelImpl.getOriginalUuid(), wikiPageResourceModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{wikiPageResourceModelImpl.getUuid(), wikiPageResourceModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (Serializable)wikiPageResource, false);
        this.clearUniqueFindersCache(wikiPageResourceModelImpl, false);
        this.cacheUniqueFindersCache(wikiPageResourceModelImpl);
        wikiPageResource.resetOriginalValues();
        return wikiPageResource;
    }

    public WikiPageResource findByPrimaryKey(Serializable primaryKey) throws NoSuchPageResourceException {
        WikiPageResource wikiPageResource = (WikiPageResource)this.fetchByPrimaryKey(primaryKey);
        if (wikiPageResource == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchPageResourceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return wikiPageResource;
    }

    public WikiPageResource findByPrimaryKey(long resourcePrimKey) throws NoSuchPageResourceException {
        return this.findByPrimaryKey(Long.valueOf(resourcePrimKey));
    }

    public WikiPageResource fetchByPrimaryKey(long resourcePrimKey) {
        return (WikiPageResource)this.fetchByPrimaryKey(Long.valueOf(resourcePrimKey));
    }

    public List<WikiPageResource> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<WikiPageResource> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<WikiPageResource> findAll(int start, int end, OrderByComparator<WikiPageResource> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<WikiPageResource> findAll(int start, int end, OrderByComparator<WikiPageResource> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_WIKIPAGERESOURCE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_WIKIPAGERESOURCE;
                sql = sql.concat(" ORDER BY wikiPageResource.resourcePrimKey ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (WikiPageResource wikiPageResource : this.findAll()) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_WIKIPAGERESOURCE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "resourcePrimKey";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_WIKIPAGERESOURCE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return WikiPageResourceModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        WikiPageResourceModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        WikiPageResourceModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
        this._finderPathCountByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
        this._finderPathCountByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 17L);
        this._finderPathCountByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathFetchByN_T = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, WikiPageResourceImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByN_T", new String[]{Long.class.getName(), String.class.getName()}, 12L);
        this._finderPathCountByN_T = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByN_T", new String[]{Long.class.getName(), String.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(WikiPageResourceImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.wiki.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.wiki.model.WikiPageResource"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.wiki.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.wiki.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

