/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.OutputSegment;
import net.htmlparser.jericho.Segment;

final class BlankOutputSegment
implements OutputSegment {
    private final int begin;
    private final int end;

    public BlankOutputSegment(int n, int n2) {
        this.begin = n;
        this.end = n2;
    }

    public BlankOutputSegment(Segment segment) {
        this(segment.getBegin(), segment.getEnd());
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
    }

    public void appendTo(Appendable appendable) throws IOException {
        for (int j = this.begin; j < this.end; ++j) {
            appendable.append(' ');
        }
    }

    public long getEstimatedMaximumOutputLength() {
        return this.end - this.begin;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.end - this.begin);
        for (int j = this.begin; j < this.end; ++j) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public String getDebugInfo() {
        return "Replace with Spaces: (p" + this.begin + "-p" + this.end + ')';
    }
}

