/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.language;

import java.util.LinkedHashMap;
import org.antlr.stringtemplate.StringTemplate;

public class FormalArgument {
    public static final int OPTIONAL = 1;
    public static final int REQUIRED = 2;
    public static final int ZERO_OR_MORE = 4;
    public static final int ONE_OR_MORE = 8;
    public static final String[] suffixes = new String[]{null, "?", "", null, "*", null, null, null, "+"};
    public static LinkedHashMap UNKNOWN = new LinkedHashMap();
    public String name;
    public StringTemplate defaultValueST;

    public FormalArgument(String string) {
        this.name = string;
    }

    public FormalArgument(String string, StringTemplate stringTemplate) {
        this.name = string;
        this.defaultValueST = stringTemplate;
    }

    public static String getCardinalityName(int n) {
        switch (n) {
            case 1: {
                return "optional";
            }
            case 2: {
                return "exactly one";
            }
            case 4: {
                return "zero-or-more";
            }
            case 8: {
                return "one-or-more";
            }
        }
        return "unknown";
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof FormalArgument)) {
            return false;
        }
        FormalArgument formalArgument = (FormalArgument)object2;
        if (!this.name.equals(formalArgument.name)) {
            return false;
        }
        return (this.defaultValueST == null || formalArgument.defaultValueST != null) && (this.defaultValueST != null || formalArgument.defaultValueST == null);
    }

    public String toString() {
        if (this.defaultValueST != null) {
            return this.name + "=" + this.defaultValueST;
        }
        return this.name;
    }
}

