/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.wiki.internal.exportimport.data.handler.WikiPortletDataHandler;
import com.liferay.wiki.internal.util.WikiCacheThreadLocal;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiPageLocalService;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet"}, service={PortletDataHandler.class})
public class WikiAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String[] CLASS_NAMES = new String[]{WikiNode.class.getName(), WikiPage.class.getName()};
    public static final String NAMESPACE = "wiki";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<?, ?> _portalCache;
    @Reference
    private Staging _staging;
    private WikiNodeLocalService _wikiNodeLocalService;
    private WikiPageLocalService _wikiPageLocalService;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getResourceName() {
        return "com.liferay.wiki";
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.wiki";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences2 = super.importData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
    }

    @Activate
    protected void activate() {
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(WikiNode.class), new StagedModelType(WikiPage.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "wiki-nodes", false, true, null, WikiNode.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "wiki-pages", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content")}, WikiPage.class.getName())});
        this.setStagingControls(this.getExportControls());
        this._portalCache = this._multiVMPool.getPortalCache(WikiPageDisplay.class.getName());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(WikiPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._wikiNodeLocalService.deleteNodes(portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return this.getExportDataRootElementString(rootElement);
        }
        portletDataContext.addPortletPermissions("com.liferay.wiki");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ExportActionableDynamicQuery nodeActionableDynamicQuery = this._wikiNodeLocalService.getExportActionableDynamicQuery(portletDataContext);
        nodeActionableDynamicQuery.performActions();
        ExportActionableDynamicQuery pageActionableDynamicQuery = this._wikiPageLocalService.getExportActionableDynamicQuery(portletDataContext);
        pageActionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return null;
        }
        portletDataContext.importPortletPermissions("com.liferay.wiki");
        Element nodesElement = portletDataContext.getImportDataGroupElement(WikiNode.class);
        List nodeElements = nodesElement.elements();
        for (Element nodeElement : nodeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)nodeElement);
        }
        Element pagesElement = portletDataContext.getImportDataGroupElement(WikiPage.class);
        List pageElements = pagesElement.elements();
        for (Element pageElement : pageElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)pageElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(WikiNode.class.getName()), new StagedModelType(WikiPage.class.getName())});
            return;
        }
        ExportActionableDynamicQuery nodeActionableDynamicQuery = this._wikiNodeLocalService.getExportActionableDynamicQuery(portletDataContext);
        nodeActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery pageExportActionableDynamicQuery = this._wikiPageLocalService.getExportActionableDynamicQuery(portletDataContext);
        pageExportActionableDynamicQuery.performCount();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }
}

