/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.model.impl;

import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.impl.WikiNodeImpl;
import com.liferay.wiki.model.impl.WikiPageBaseImpl;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.service.WikiPageServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WikiPageImpl
extends WikiPageBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(WikiPageImpl.class);
    private long _attachmentsFolderId;

    public Folder addAttachmentsFolder() throws PortalException {
        if (this._attachmentsFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFolder((long)this._attachmentsFolderId);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)this.getGroupId(), (String)"com.liferay.wiki", (ServiceContext)serviceContext);
        WikiNode node = this.getNode();
        Folder nodeFolder = node.addAttachmentsFolder();
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)this.getUserId(), (long)repository.getRepositoryId(), (long)nodeFolder.getFolderId(), (String)String.valueOf(this.getResourcePrimKey()), (ServiceContext)serviceContext);
        this._attachmentsFolderId = folder.getFolderId();
        return folder;
    }

    public WikiPage fetchParentPage() {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.fetchPage((long)this.getNodeId(), (String)this.getParentTitle());
    }

    public WikiPage fetchRedirectPage() {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.fetchPage((long)this.getNodeId(), (String)this.getRedirectTitle());
    }

    public List<FileEntry> getAttachmentsFileEntries() throws PortalException {
        return this.getAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getAttachmentsFileEntries(int start, int end) throws PortalException {
        return this.getAttachmentsFileEntries(start, end, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getAttachmentsFileEntries(int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId == 0L) {
            return Collections.emptyList();
        }
        return PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)0, (int)start, (int)end, orderByComparator);
    }

    public List<FileEntry> getAttachmentsFileEntries(String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId == 0L) {
            return Collections.emptyList();
        }
        return PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (String[])mimeTypes, (int)0, (int)start, (int)end, orderByComparator);
    }

    public int getAttachmentsFileEntriesCount() throws PortalException {
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId == 0L) {
            return 0;
        }
        return PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)0);
    }

    public int getAttachmentsFileEntriesCount(String[] mimeTypes) throws PortalException {
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId == 0L) {
            return 0;
        }
        return PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (String[])mimeTypes, (int)0);
    }

    public long getAttachmentsFolderId() {
        if (this._attachmentsFolderId != 0L) {
            return this._attachmentsFolderId;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)this.getGroupId(), (String)"com.liferay.wiki");
        long nodeAttachmentsFolderId = this.getNodeAttachmentsFolderId();
        if (repository == null || nodeAttachmentsFolderId == 0L) {
            return 0L;
        }
        try {
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)nodeAttachmentsFolderId, (String)String.valueOf(this.getResourcePrimKey()));
            this._attachmentsFolderId = folder.getFolderId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._attachmentsFolderId;
    }

    public List<WikiPage> getChildPages() {
        try {
            return WikiPageLocalServiceUtil.getChildren((long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public List<FileEntry> getDeletedAttachmentsFileEntries() throws PortalException {
        return this.getDeletedAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getDeletedAttachmentsFileEntries(int start, int end) throws PortalException {
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId == 0L) {
            return Collections.emptyList();
        }
        return PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)8, (int)start, (int)end, (OrderByComparator)new RepositoryModelTitleComparator(true));
    }

    public int getDeletedAttachmentsFileEntriesCount() throws PortalException {
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId == 0L) {
            return 0;
        }
        return PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)8);
    }

    public WikiNode getNode() {
        try {
            return WikiNodeLocalServiceUtil.getNode((long)this.getNodeId());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return new WikiNodeImpl();
        }
    }

    public long getNodeAttachmentsFolderId() {
        WikiNode node = WikiNodeLocalServiceUtil.fetchWikiNode((long)this.getNodeId());
        if (node == null) {
            return 0L;
        }
        return node.getAttachmentsFolderId();
    }

    public WikiPage getParentPage() throws PortalException {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getParentTitle());
    }

    public List<WikiPage> getParentPages() {
        WikiPage parentPage = this.fetchParentPage();
        if (parentPage == null) {
            return Collections.emptyList();
        }
        ArrayList<WikiPage> parentPages = new ArrayList<WikiPage>();
        parentPages.addAll(parentPage.getParentPages());
        parentPages.add(parentPage);
        return parentPages;
    }

    public WikiPage getRedirectPage() throws PortalException {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        return WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getRedirectTitle());
    }

    @Override
    public long getTrashEntryClassPK() {
        return this.getResourcePrimKey();
    }

    public List<WikiPage> getViewableChildPages() {
        try {
            return WikiPageServiceUtil.getChildren((long)this.getGroupId(), (long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public WikiPage getViewableParentPage() {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        try {
            return WikiPageServiceUtil.getPage((long)this.getGroupId(), (long)this.getNodeId(), (String)this.getParentTitle());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    public List<WikiPage> getViewableParentPages() {
        WikiPage page = this.getViewableParentPage();
        if (page == null) {
            return Collections.emptyList();
        }
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        pages.addAll(page.getViewableParentPages());
        pages.add(page);
        return pages;
    }

    @Override
    public boolean isResourceMain() {
        return this.isHead();
    }

    public void setAttachmentsFolderId(long attachmentsFolderId) {
        this._attachmentsFolderId = attachmentsFolderId;
    }
}

