/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jrcs.util.ToString;

public class Chunk
extends ToString {
    protected int anchor;
    protected int count;
    protected List chunk;

    public Chunk(int pos, int count) {
        this.anchor = pos;
        this.count = count >= 0 ? count : 0;
    }

    public Chunk(Object[] iseq, int pos, int count) {
        this(pos, count);
        this.chunk = Chunk.slice(iseq, pos, count);
    }

    public Chunk(Object[] iseq, int pos, int count, int offset) {
        this(offset, count);
        this.chunk = Chunk.slice(iseq, pos, count);
    }

    public Chunk(List iseq, int pos, int count) {
        this(pos, count);
        this.chunk = Chunk.slice(iseq, pos, count);
    }

    public Chunk(List iseq, int pos, int count, int offset) {
        this(offset, count);
        this.chunk = Chunk.slice(iseq, pos, count);
    }

    public int anchor() {
        return this.anchor;
    }

    public int size() {
        return this.count;
    }

    public int first() {
        return this.anchor();
    }

    public int last() {
        return this.anchor() + this.size() - 1;
    }

    public int rcsfrom() {
        return this.anchor + 1;
    }

    public int rcsto() {
        return this.anchor + this.count;
    }

    public List chunk() {
        return this.chunk;
    }

    public boolean verify(List target) {
        if (this.chunk == null) {
            return true;
        }
        if (this.last() > target.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (target.get(this.anchor + i2).equals(this.chunk.get(i2))) continue;
            return false;
        }
        return true;
    }

    public void applyDelete(List target) {
        for (int i2 = this.last(); i2 >= this.first(); --i2) {
            target.remove(i2);
        }
    }

    public void applyAdd(int start, List target) {
        Iterator i2 = this.chunk.iterator();
        while (i2.hasNext()) {
            target.add(start++, i2.next());
        }
    }

    public void toString(StringBuffer s2) {
        this.toString(s2, "", "");
    }

    public StringBuffer toString(StringBuffer s2, String prefix, String postfix) {
        if (this.chunk != null) {
            Iterator i2 = this.chunk.iterator();
            while (i2.hasNext()) {
                s2.append(prefix);
                s2.append(i2.next());
                s2.append(postfix);
            }
        }
        return s2;
    }

    public static List slice(List seq, int pos, int count) {
        if (count <= 0) {
            return new ArrayList(seq.subList(pos, pos));
        }
        return new ArrayList(seq.subList(pos, pos + count));
    }

    public static List slice(Object[] seq, int pos, int count) {
        return Chunk.slice(Arrays.asList(seq), pos, count);
    }

    public String rangeString() {
        StringBuffer result = new StringBuffer();
        this.rangeString(result);
        return result.toString();
    }

    public void rangeString(StringBuffer s2) {
        this.rangeString(s2, ",");
    }

    public void rangeString(StringBuffer s2, String separ) {
        if (this.size() <= 1) {
            s2.append(Integer.toString(this.rcsfrom()));
        } else {
            s2.append(Integer.toString(this.rcsfrom()));
            s2.append(separ);
            s2.append(Integer.toString(this.rcsto()));
        }
    }
}

