/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.bind;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.PortletInfo;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.util.axis.ServletUtil;
import com.liferay.wsrp.exception.NoSuchProducerException;
import com.liferay.wsrp.internal.bind.BaseServiceImpl;
import com.liferay.wsrp.model.WSRPProducer;
import com.liferay.wsrp.util.ExtensionHelperUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_ServiceDescription_PortType;
import oasis.names.tc.wsrp.v2.types.CookieProtocol;
import oasis.names.tc.wsrp.v2.types.GetServiceDescription;
import oasis.names.tc.wsrp.v2.types.MarkupType;
import oasis.names.tc.wsrp.v2.types.PortletDescription;
import oasis.names.tc.wsrp.v2.types.ServiceDescription;
import org.apache.axis.message.MessageElement;

public class V2ServiceDescriptionServiceImpl
extends BaseServiceImpl
implements WSRP_v2_ServiceDescription_PortType {
    private static final Log _log = LogFactoryUtil.getLog(V2ServiceDescriptionServiceImpl.class);
    private static final CookieProtocol _cookieProtocol = CookieProtocol.fromString((String)"perGroup");

    public ServiceDescription getServiceDescription(GetServiceDescription getServiceDescription) throws RemoteException {
        try {
            return this.doGetServiceDescription(getServiceDescription);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    protected ServiceDescription doGetServiceDescription(GetServiceDescription getServiceDescription) throws Exception {
        WSRPProducer wsrpProducer = null;
        try {
            wsrpProducer = this.getWSRPProducer();
        }
        catch (NoSuchProducerException nspe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nspe.getMessage());
            }
            return null;
        }
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setOfferedPortlets(this.getPortletDescriptions(wsrpProducer));
        serviceDescription.setRequiresInitCookie(_cookieProtocol);
        return serviceDescription;
    }

    protected MarkupType[] getMarkupTypes(Portlet portlet) {
        Map portletModes = portlet.getPortletModes();
        Map windowStates = portlet.getWindowStates();
        HashSet mimeTypes = new HashSet();
        mimeTypes.addAll(portletModes.keySet());
        mimeTypes.addAll(windowStates.keySet());
        ArrayList<MarkupType> markupTypes = new ArrayList<MarkupType>();
        for (String mimeType : mimeTypes) {
            Set<String> mimeTypeWindowStates;
            Set<String> mimeTypePortletModes = (Set<String>)portletModes.get(mimeType);
            if (mimeTypePortletModes == null) {
                mimeTypePortletModes = Collections.emptySet();
            }
            if ((mimeTypeWindowStates = (Set<String>)windowStates.get(mimeType)) == null) {
                mimeTypeWindowStates = Collections.emptySet();
            }
            MarkupType markupType = new MarkupType();
            markupType.setMimeType(mimeType);
            markupType.setModes(this.getWSRPKeys(mimeTypePortletModes));
            markupType.setWindowStates(this.getWSRPKeys(mimeTypeWindowStates));
            markupTypes.add(markupType);
        }
        return markupTypes.toArray(new MarkupType[markupTypes.size()]);
    }

    protected PortletDescription getPortletDescription(WSRPProducer wsrpProducer, Portlet portlet, String portletId) {
        PortletDescription portletDescription = new PortletDescription();
        portletDescription.setGroupID("liferay");
        portletDescription.setPortletHandle(portletId);
        portletDescription.setMarkupTypes(this.getMarkupTypes(portlet));
        HttpServletRequest request = ServletUtil.getRequest();
        ServletContext servletContext = request.getSession().getServletContext();
        String title = PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)servletContext, (Locale)LocaleUtil.getDefault());
        portletDescription.setTitle(this.getLocalizedString(title));
        PortletInfo portletInfo = portlet.getPortletInfo();
        String shortTitle = portletInfo.getShortTitle();
        if (shortTitle == null) {
            shortTitle = title;
        }
        portletDescription.setShortTitle(this.getLocalizedString(shortTitle));
        String[] keywords = StringUtil.split((String)portletInfo.getKeywords());
        portletDescription.setKeywords(this.getLocalizedStrings(keywords));
        String displayName = GetterUtil.getString((String)portlet.getDisplayName(), (String)title);
        portletDescription.setDisplayName(this.getLocalizedString(displayName));
        this.setExtensions(portletDescription, portlet);
        return portletDescription;
    }

    protected PortletDescription[] getPortletDescriptions(WSRPProducer wsrpProducer) {
        String[] portletIds = StringUtil.split((String)wsrpProducer.getPortletIds());
        ArrayList<PortletDescription> portletDescriptions = new ArrayList<PortletDescription>();
        for (String portletId : portletIds) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)rootPortletId);
            if (portlet == null) continue;
            PortletDescription portletDescription = this.getPortletDescription(wsrpProducer, portlet, portletId);
            portletDescriptions.add(portletDescription);
        }
        return portletDescriptions.toArray(new PortletDescription[portletDescriptions.size()]);
    }

    protected String[] getWSRPKeys(Set<String> keys) {
        String[] wsrpKeys = new String[keys.size()];
        int i = 0;
        for (String key : keys) {
            wsrpKeys[i++] = "wsrp:".concat(key);
        }
        return wsrpKeys;
    }

    protected void setExtensions(PortletDescription portletDescription, Portlet portlet) {
        ArrayList<MessageElement> messageElements = new ArrayList<MessageElement>();
        ExtensionHelperUtil.addMessageElement(messageElements, "css-class-wrapper", portlet.getCssClassWrapper());
        HttpServletRequest request = ServletUtil.getRequest();
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        String portalPath = portalURL + PortalUtil.getPathContext();
        String portletPath = portalURL + portlet.getContextPath();
        Portlet rootPortlet = portlet.getRootPortlet();
        long timestamp = rootPortlet.getTimestamp();
        for (String footerPortalCss : portlet.getFooterPortalCss()) {
            if (!HttpUtil.hasProtocol((String)footerPortalCss)) {
                footerPortalCss = portalPath + footerPortalCss + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "footer-portal-css", footerPortalCss);
        }
        for (String footerPortalJavaScript : portlet.getFooterPortalJavaScript()) {
            if (!HttpUtil.hasProtocol((String)footerPortalJavaScript)) {
                footerPortalJavaScript = portalPath + footerPortalJavaScript + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "footer-portal-javascript", footerPortalJavaScript);
        }
        for (String footerPortletCss : portlet.getFooterPortletCss()) {
            if (!HttpUtil.hasProtocol((String)footerPortletCss)) {
                footerPortletCss = portletPath + footerPortletCss + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "footer-portlet-css", footerPortletCss);
        }
        for (String footerPortletJavaScript : portlet.getFooterPortletJavaScript()) {
            if (!HttpUtil.hasProtocol((String)footerPortletJavaScript)) {
                footerPortletJavaScript = portletPath + footerPortletJavaScript + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "footer-portlet-javascript", footerPortletJavaScript);
        }
        for (String headerPortalCss : portlet.getHeaderPortalCss()) {
            if (!HttpUtil.hasProtocol((String)headerPortalCss)) {
                headerPortalCss = portalPath + headerPortalCss + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "header-portal-css", headerPortalCss);
        }
        for (String headerPortalJavaScript : portlet.getHeaderPortalJavaScript()) {
            if (!HttpUtil.hasProtocol((String)headerPortalJavaScript)) {
                headerPortalJavaScript = portalPath + headerPortalJavaScript + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "header-portal-javascript", headerPortalJavaScript);
        }
        for (String headerPortletCss : portlet.getHeaderPortletCss()) {
            if (!HttpUtil.hasProtocol((String)headerPortletCss)) {
                headerPortletCss = portletPath + headerPortletCss + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "header-portlet-css", headerPortletCss);
        }
        for (String headerPortletJavaScript : portlet.getHeaderPortletJavaScript()) {
            if (!HttpUtil.hasProtocol((String)headerPortletJavaScript)) {
                headerPortletJavaScript = portletPath + headerPortletJavaScript + "?t=" + timestamp;
            }
            ExtensionHelperUtil.addMessageElement(messageElements, "header-portlet-javascript", headerPortletJavaScript);
        }
        portletDescription.setExtensions(ExtensionHelperUtil.getExtensions(messageElements));
    }
}

