/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.messaging;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.HotDeployMessageListener;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.wsrp.internal.jmx.WSRPConsumerPortletManager;
import com.liferay.wsrp.service.WSRPConsumerPortletLocalService;
import com.liferay.wsrp.util.ExtensionHelperUtil;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, property={"destination.name=liferay/wsrp"}, service={MessageListener.class})
public class WSRPMessageListener
extends HotDeployMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(WSRPMessageListener.class);
    private BundleContext _bundleContext;
    private ServiceTracker<MBeanServer, MBeanServer> _serviceTracker;
    @Reference
    private WSRPConsumerPortletLocalService _wSRPConsumerPortletLocalService;

    public void destroy() {
        this._serviceTracker.close();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        block2: {
            this._bundleContext = bundleContext;
            this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, MBeanServer.class, (ServiceTrackerCustomizer)new MBeanServerServiceTrackerCustomizer());
            this._serviceTracker.open();
            ExtensionHelperUtil.initialize();
            try {
                this._wSRPConsumerPortletLocalService.destroyWSRPConsumerPortlets();
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to destroy WSRP consumer portlets", (Throwable)pe);
            }
        }
        this._wSRPConsumerPortletLocalService.initWSRPConsumerPortlets();
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        block2: {
            try {
                this._wSRPConsumerPortletLocalService.destroyWSRPConsumerPortlets();
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to destroy WSRP consumer portlets", (Throwable)pe);
            }
        }
    }

    private class MBeanServerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<MBeanServer, MBeanServer> {
        private MBeanServerServiceTrackerCustomizer() {
        }

        public MBeanServer addingService(ServiceReference<MBeanServer> serviceReference) {
            MBeanServer mBeanServer;
            block2: {
                mBeanServer = (MBeanServer)WSRPMessageListener.this._bundleContext.getService(serviceReference);
                try {
                    mBeanServer.registerMBean(new WSRPConsumerPortletManager(), new ObjectName("com.liferay.wsrp:classification=wsrp,name=WSRPConsumerPortletManager"));
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)"Unable to register WSRP consumer portlet manager", (Throwable)e);
                }
            }
            return mBeanServer;
        }

        public void modifiedService(ServiceReference<MBeanServer> serviceReference, MBeanServer mBeanServer) {
        }

        public void removedService(ServiceReference<MBeanServer> serviceReference, MBeanServer mBeanServer) {
        }
    }
}

