/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.service.impl;

import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletInfo;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.wsrp.exception.NoSuchConsumerPortletException;
import com.liferay.wsrp.exception.WSRPConsumerPortletHandleException;
import com.liferay.wsrp.exception.WSRPConsumerPortletNameException;
import com.liferay.wsrp.internal.consumer.portlet.ConsumerFriendlyURLMapper;
import com.liferay.wsrp.internal.consumer.portlet.ConsumerPortlet;
import com.liferay.wsrp.model.WSRPConsumer;
import com.liferay.wsrp.model.WSRPConsumerPortlet;
import com.liferay.wsrp.service.base.WSRPConsumerPortletLocalServiceBaseImpl;
import com.liferay.wsrp.util.ExtensionHelperUtil;
import com.liferay.wsrp.util.LocalizedStringUtil;
import com.liferay.wsrp.util.WSRPConsumerManager;
import com.liferay.wsrp.util.WSRPConsumerManagerFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.Portlet;
import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v2.types.MarkupType;
import oasis.names.tc.wsrp.v2.types.ParameterDescription;
import oasis.names.tc.wsrp.v2.types.PortletDescription;
import org.apache.axis.message.MessageElement;

public class WSRPConsumerPortletLocalServiceImpl
extends WSRPConsumerPortletLocalServiceBaseImpl {
    private static final String _CONSUMER_PORTLET_ID = "com_liferay_wsrp_portlet_WSRPConsumerPortlet";
    private static final String _CONSUMER_PORTLET_NAME = "com_liferay_wsrp_portlet_WSRPConsumerPortlet";
    private static final String _WSRP_CATEGORY = "category.wsrp";
    private static final Log _log = LogFactoryUtil.getLog(WSRPConsumerPortletLocalServiceImpl.class);
    private static final Map<String, com.liferay.portal.kernel.model.Portlet> _portletsPool = new ConcurrentHashMap<String, com.liferay.portal.kernel.model.Portlet>();
    private Class<? extends ConsumerPortlet> _consumerPortletClass;
    private final Map<Long, Tuple> _failedWSRPConsumerPortlets = new ConcurrentHashMap<Long, Tuple>();

    public WSRPConsumerPortlet addWSRPConsumerPortlet(long wsrpConsumerId, String name, String portletHandle, ServiceContext serviceContext) throws PortalException {
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
        Date now = new Date();
        this.validate(name, portletHandle);
        long wsrpConsumerPortletId = this.counterLocalService.increment();
        WSRPConsumerPortlet wsrpConsumerPortlet = this.wsrpConsumerPortletPersistence.create(wsrpConsumerPortletId);
        wsrpConsumerPortlet.setUuid(serviceContext.getUuid());
        wsrpConsumerPortlet.setCompanyId(wsrpConsumer.getCompanyId());
        wsrpConsumerPortlet.setCreateDate(now);
        wsrpConsumerPortlet.setModifiedDate(now);
        wsrpConsumerPortlet.setWsrpConsumerId(wsrpConsumerId);
        wsrpConsumerPortlet.setName(name);
        wsrpConsumerPortlet.setPortletHandle(portletHandle);
        this.wsrpConsumerPortletPersistence.update((BaseModel)wsrpConsumerPortlet);
        this.wsrpConsumerPortletLocalService.initWSRPConsumerPortlet(wsrpConsumer.getCompanyId(), wsrpConsumerId, wsrpConsumerPortletId, wsrpConsumerPortlet.getUuid(), name, portletHandle);
        return wsrpConsumerPortlet;
    }

    public WSRPConsumerPortlet addWSRPConsumerPortlet(String wsrpConsumerUuid, String name, String portletHandle, ServiceContext serviceContext) throws PortalException {
        WSRPConsumer wsrpConsumer = this.wsrpConsumerLocalService.getWSRPConsumer(wsrpConsumerUuid);
        return this.addWSRPConsumerPortlet(wsrpConsumer.getWsrpConsumerId(), name, portletHandle, serviceContext);
    }

    @Override
    public WSRPConsumerPortlet deleteWSRPConsumerPortlet(long wsrpConsumerPortletId) throws PortalException {
        WSRPConsumerPortlet wsrpConsumerPortlet = this.wsrpConsumerPortletPersistence.findByPrimaryKey(wsrpConsumerPortletId);
        return this.wsrpConsumerPortletLocalService.deleteWSRPConsumerPortlet(wsrpConsumerPortlet);
    }

    public void deleteWSRPConsumerPortlet(String wsrpConsumerPortletUuid) throws PortalException {
        List wsrpConsumerPortlets = this.wsrpConsumerPortletPersistence.findByUuid(wsrpConsumerPortletUuid);
        if (!wsrpConsumerPortlets.isEmpty()) {
            this.wsrpConsumerPortletLocalService.deleteWSRPConsumerPortlet((WSRPConsumerPortlet)wsrpConsumerPortlets.get(0));
        }
    }

    @Override
    @SystemEvent(type=1)
    public WSRPConsumerPortlet deleteWSRPConsumerPortlet(WSRPConsumerPortlet wsrpConsumerPortlet) throws PortalException {
        this.wsrpConsumerPortletPersistence.remove((BaseModel)wsrpConsumerPortlet);
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerPortlet.getWsrpConsumerId());
        this.wsrpConsumerPortletLocalService.destroyWSRPConsumerPortlet(wsrpConsumerPortlet.getWsrpConsumerPortletId(), wsrpConsumerPortlet.getUuid(), wsrpConsumer.getUrl());
        return wsrpConsumerPortlet;
    }

    public void deleteWSRPConsumerPortlets(long wsrpConsumerId) throws PortalException {
        List wsrpConsumerPortlets = this.wsrpConsumerPortletPersistence.findByWsrpConsumerId(wsrpConsumerId);
        for (WSRPConsumerPortlet wsrpConsumerPortlet : wsrpConsumerPortlets) {
            this.wsrpConsumerPortletLocalService.deleteWSRPConsumerPortlet(wsrpConsumerPortlet);
        }
    }

    @Clusterable
    public void destroyWSRPConsumerPortlet(long wsrpConsumerPortletId, String wsrpConsumerPortletUuid, String url) {
        try {
            com.liferay.portal.kernel.model.Portlet portlet = _portletsPool.remove(wsrpConsumerPortletUuid);
            if (portlet == null) {
                WSRPConsumerPortlet wsrpConsumerPortlet = this.getWSRPConsumerPortlet(wsrpConsumerPortletId);
                portlet = this.portletLocalService.getPortletById(wsrpConsumerPortlet.getCompanyId(), this.getPortletId(wsrpConsumerPortletUuid));
            } else {
                WSRPConsumerManagerFactory.destroyWSRPConsumerManager(url);
                this._failedWSRPConsumerPortlets.remove(wsrpConsumerPortletId);
            }
            PortletInstanceFactoryUtil.destroy((com.liferay.portal.kernel.model.Portlet)portlet);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to destroy WSRP consumer portlet " + wsrpConsumerPortletId), (Throwable)e);
        }
    }

    public void destroyWSRPConsumerPortlets() throws PortalException {
        List wsrpConsumerPortlets = this.wsrpConsumerPortletPersistence.findAll();
        for (WSRPConsumerPortlet wsrpConsumerPortlet : wsrpConsumerPortlets) {
            WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerPortlet.getWsrpConsumerId());
            this.destroyWSRPConsumerPortlet(wsrpConsumerPortlet.getWsrpConsumerPortletId(), wsrpConsumerPortlet.getUuid(), wsrpConsumer.getUrl());
        }
    }

    public WSRPConsumerPortlet getWSRPConsumerPortlet(long wsrpConsumerId, String portletHandle) throws PortalException {
        return this.wsrpConsumerPortletPersistence.findByW_P(wsrpConsumerId, portletHandle);
    }

    public WSRPConsumerPortlet getWSRPConsumerPortlet(String wsrpConsumerPortletUuid) throws PortalException {
        List wsrpConsumerPortlets = this.wsrpConsumerPortletPersistence.findByUuid(wsrpConsumerPortletUuid);
        if (wsrpConsumerPortlets.isEmpty()) {
            throw new NoSuchConsumerPortletException("No WSRP consumer portlet exists with uuid " + wsrpConsumerPortletUuid);
        }
        return (WSRPConsumerPortlet)wsrpConsumerPortlets.get(0);
    }

    public List<WSRPConsumerPortlet> getWSRPConsumerPortlets(long wsrpConsumerId, int start, int end) {
        return this.wsrpConsumerPortletPersistence.findByWsrpConsumerId(wsrpConsumerId, start, end);
    }

    public int getWSRPConsumerPortletsCount(long wsrpConsumerId) {
        return this.wsrpConsumerPortletPersistence.countByWsrpConsumerId(wsrpConsumerId);
    }

    @Clusterable
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void initFailedWSRPConsumerPortlets() {
        for (Map.Entry<Long, Tuple> entry : this._failedWSRPConsumerPortlets.entrySet()) {
            long wsrpConsumerPortletId = entry.getKey();
            Tuple tuple = entry.getValue();
            try {
                long companyId = (Long)tuple.getObject(0);
                long wsrpConsumerId = (Long)tuple.getObject(1);
                String wsrpConsumerPortletUuid = (String)tuple.getObject(2);
                String name = (String)tuple.getObject(3);
                String portletHandle = (String)tuple.getObject(4);
                this._failedWSRPConsumerPortlets.remove(wsrpConsumerPortletId);
                this.initWSRPConsumerPortlet(companyId, wsrpConsumerId, wsrpConsumerPortletId, wsrpConsumerPortletUuid, name, portletHandle);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to reinitialize WSRP consumer portlet " + wsrpConsumerPortletId), (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Clusterable
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void initWSRPConsumerPortlet(long companyId, long wsrpConsumerId, long wsrpConsumerPortletId, String wsrpConsumerPortletUuid, String name, String portletHandle) throws PortalException {
        boolean initializationFailed = false;
        try {
            com.liferay.portal.kernel.model.Portlet portlet = this.getPortlet(companyId, wsrpConsumerId, wsrpConsumerPortletUuid, name, portletHandle);
            if (!portlet.isActive()) {
                initializationFailed = true;
            }
            this.portletLocalService.deployRemotePortlet(portlet, _WSRP_CATEGORY);
            if (!initializationFailed) return;
        }
        catch (PortalException pe) {
            try {
                initializationFailed = true;
                throw pe;
                catch (SystemException se) {
                    initializationFailed = true;
                    throw se;
                }
                catch (Exception e) {
                    initializationFailed = true;
                    throw new SystemException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (!initializationFailed) throw throwable;
                Tuple tuple = new Tuple(new Object[]{companyId, wsrpConsumerId, wsrpConsumerPortletUuid, name, portletHandle});
                this._failedWSRPConsumerPortlets.put(wsrpConsumerPortletId, tuple);
                throw throwable;
            }
        }
        Tuple tuple = new Tuple(new Object[]{companyId, wsrpConsumerId, wsrpConsumerPortletUuid, name, portletHandle});
        this._failedWSRPConsumerPortlets.put(wsrpConsumerPortletId, tuple);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void initWSRPConsumerPortlets() {
        for (WSRPConsumerPortlet wsrpConsumerPortlet : this.wsrpConsumerPortletPersistence.findAll()) {
            try {
                this.initWSRPConsumerPortlet(wsrpConsumerPortlet.getCompanyId(), wsrpConsumerPortlet.getWsrpConsumerId(), wsrpConsumerPortlet.getWsrpConsumerPortletId(), wsrpConsumerPortlet.getUuid(), wsrpConsumerPortlet.getName(), wsrpConsumerPortlet.getPortletHandle());
            }
            catch (Exception e) {
                _log.error((Object)("Unable to initialize WSRP consumer portlet " + wsrpConsumerPortlet.getUuid()), (Throwable)e);
            }
        }
    }

    public WSRPConsumerPortlet updateWSRPConsumerPortlet(long wsrpConsumerPortletId, String name) throws PortalException {
        this.validate(name);
        WSRPConsumerPortlet wsrpConsumerPortlet = this.wsrpConsumerPortletPersistence.findByPrimaryKey(wsrpConsumerPortletId);
        wsrpConsumerPortlet.setModifiedDate(new Date());
        wsrpConsumerPortlet.setName(name);
        this.wsrpConsumerPortletPersistence.update((BaseModel)wsrpConsumerPortlet);
        return wsrpConsumerPortlet;
    }

    protected void addPortletExtraInfo(com.liferay.portal.kernel.model.Portlet portlet, PortletApp portletApp, PortletDescription portletDescription, String title) {
        MessageElement[] messageElements;
        QName[] publishedEvents;
        QName[] handledEvents;
        MarkupType[] markupTypes;
        for (MarkupType markupType : markupTypes = portletDescription.getMarkupTypes()) {
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            for (String portletMode : markupType.getModes()) {
                if ((portletMode = StringUtil.toLowerCase((String)portletMode)).startsWith("wsrp:")) {
                    portletMode = portletMode.substring(5);
                }
                mimeTypePortletModes.add(portletMode);
            }
            portlet.getPortletModes().put(markupType.getMimeType(), mimeTypePortletModes);
            ParameterDescription[] mimeTypeWindowStates = new HashSet();
            String[] stringArray = markupType.getWindowStates();
            int n = stringArray.length;
            for (int portletMode = 0; portletMode < n; ++portletMode) {
                String windowState = stringArray[portletMode];
                if ((windowState = StringUtil.toLowerCase((String)windowState)).startsWith("wsrp:")) {
                    windowState = windowState.substring(5);
                }
                mimeTypeWindowStates.add(windowState);
            }
            portlet.getWindowStates().put(markupType.getMimeType(), mimeTypeWindowStates);
        }
        String shortTitle = LocalizedStringUtil.getLocalizedStringValue(portletDescription.getShortTitle(), title);
        String keywords = StringUtil.merge((Object[])LocalizedStringUtil.getLocalizedStringValues(portletDescription.getKeywords()), (String)" ");
        String description = LocalizedStringUtil.getLocalizedStringValue(portletDescription.getShortTitle());
        PortletInfo portletInfo = new PortletInfo(title, shortTitle, keywords, description);
        portlet.setPortletInfo(portletInfo);
        portlet.setFriendlyURLMapperClass(ConsumerFriendlyURLMapper.class.getName());
        ParameterDescription[] parameterDescriptions = portletDescription.getNavigationalPublicValueDescriptions();
        if (parameterDescriptions != null) {
            for (ParameterDescription parameterDescription : parameterDescriptions) {
                Object[] qNames = parameterDescription.getNames();
                if (ArrayUtil.isEmpty((Object[])qNames)) continue;
                com.liferay.portal.kernel.xml.QName qName = this.getQName((QName)qNames[0]);
                String identifier = parameterDescription.getIdentifier();
                portletApp.addPublicRenderParameter(identifier, qName);
                portlet.addPublicRenderParameter(portletApp.getPublicRenderParameter(identifier));
            }
        }
        if ((handledEvents = portletDescription.getHandledEvents()) != null) {
            for (QName handledEvent : handledEvents) {
                portlet.addProcessingEvent(this.getQName(handledEvent));
            }
        }
        if ((publishedEvents = portletDescription.getPublishedEvents()) != null) {
            for (QName publishedEvent : publishedEvents) {
                portlet.addPublishingEvent(this.getQName(publishedEvent));
            }
        }
        if ((messageElements = ExtensionHelperUtil.getMessageElements(portletDescription.getExtensions())) != null) {
            for (MessageElement messageElement : messageElements) {
                this.setExtension(portlet, messageElement);
            }
        }
    }

    protected ConsumerPortlet getConsumerPortletInstance(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        if (this._consumerPortletClass == null) {
            ClassLoader classLoader = this.getClassLoader();
            Class<?> clazz = classLoader.loadClass(portlet.getPortletClass());
            this._consumerPortletClass = clazz.asSubclass(ConsumerPortlet.class);
        }
        return this._consumerPortletClass.newInstance();
    }

    protected com.liferay.portal.kernel.model.Portlet getPortlet(long companyId, long wsrpConsumerId, String wsrpConsumerPortletUuid, String name, String portletHandle) throws Exception {
        PortletDescription portletDescription;
        String portletId;
        com.liferay.portal.kernel.model.Portlet portlet;
        block5: {
            portlet = _portletsPool.get(wsrpConsumerPortletUuid);
            if (portlet != null && portlet.isActive()) {
                return portlet;
            }
            portletId = this.getPortletId(wsrpConsumerPortletUuid);
            portlet = this.portletLocalService.clonePortlet("com_liferay_wsrp_portlet_WSRPConsumerPortlet");
            portlet.setCompanyId(companyId);
            portlet.setDisplayName(portletId);
            portlet.setPortletId(portletId);
            portlet.setPortletName(portletId);
            Map initParams = portlet.getInitParams();
            initParams.put("com.liferay.portal.invokerPortletName", "com_liferay_wsrp_portlet_WSRPConsumerPortlet");
            WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
            portletDescription = null;
            try {
                WSRPConsumerManager wsrpConsumerManager = WSRPConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
                portletDescription = wsrpConsumerManager.getPortletDescription(portletHandle);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Unable to connect to WSRP producer for portlet " + wsrpConsumerPortletUuid), (Throwable)e);
            }
        }
        if (portletDescription != null) {
            this.addPortletExtraInfo(portlet, portlet.getPortletApp(), portletDescription, name);
            portlet.setActive(true);
        } else {
            PortletInfo portletInfo = new PortletInfo(name, name, "", "");
            portlet.setPortletInfo(portletInfo);
        }
        _portletsPool.put(wsrpConsumerPortletUuid, portlet);
        PortletBag portletBag = PortletBagPool.get((String)"com_liferay_wsrp_portlet_WSRPConsumerPortlet");
        portletBag = (PortletBag)portletBag.clone();
        portletBag.setPortletName(portletId);
        ConsumerPortlet consumerPortletInstance = this.getConsumerPortletInstance(portlet);
        portletBag.setPortletInstance((Portlet)consumerPortletInstance);
        PortletBagPool.put((String)portletId, (PortletBag)portletBag);
        return portlet;
    }

    protected String getPortletId(String wsrpConsumerPortletUuid) {
        String portletId = "WSRP_".concat(wsrpConsumerPortletUuid);
        portletId = PortalUtil.getJsSafePortletId((String)PortalUUIDUtil.toJsSafeUuid((String)portletId));
        return portletId;
    }

    protected String getProxyURL(String url) {
        return "/proxy?url=" + URLCodec.encodeURL((String)url);
    }

    protected com.liferay.portal.kernel.xml.QName getQName(QName qName) {
        String localPart = qName.getLocalPart();
        String prefix = qName.getPrefix();
        String namespaceURI = qName.getNamespaceURI();
        Namespace namespace = SAXReaderUtil.createNamespace((String)prefix, (String)namespaceURI);
        return SAXReaderUtil.createQName((String)localPart, (Namespace)namespace);
    }

    protected void setExtension(com.liferay.portal.kernel.model.Portlet portlet, MessageElement messageElement) {
        String name = ExtensionHelperUtil.getNameAttribute(messageElement);
        String value = messageElement.getValue();
        if (Validator.isNull((String)name)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Message element " + messageElement.toString() + " has a null name"));
            }
            return;
        }
        if (name.equals("css-class-wrapper")) {
            portlet.setCssClassWrapper(value);
        } else if (name.equals("footer-portal-css")) {
            portlet.getFooterPortalCss().add(this.getProxyURL(value));
        } else if (name.equals("footer-portal-javascript")) {
            portlet.getFooterPortalJavaScript().add(this.getProxyURL(value));
        } else if (name.equals("footer-portlet-css")) {
            portlet.getFooterPortletCss().add(this.getProxyURL(value));
        } else if (name.equals("footer-portlet-javascript")) {
            portlet.getFooterPortletJavaScript().add(this.getProxyURL(value));
        } else if (name.equals("header-portal-css")) {
            portlet.getHeaderPortalCss().add(this.getProxyURL(value));
        } else if (name.equals("header-portal-javascript")) {
            portlet.getHeaderPortalJavaScript().add(this.getProxyURL(value));
        } else if (name.equals("header-portlet-css")) {
            portlet.getHeaderPortletCss().add(this.getProxyURL(value));
        } else if (name.equals("header-portlet-javascript")) {
            portlet.getHeaderPortletJavaScript().add(this.getProxyURL(value));
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new WSRPConsumerPortletNameException();
        }
    }

    protected void validate(String name, String portletHandle) throws PortalException {
        this.validate(name);
        if (Validator.isNull((String)portletHandle)) {
            throw new WSRPConsumerPortletHandleException();
        }
    }
}

