/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wsrp.configuration.WSRPGroupServiceConfiguration;
import com.liferay.wsrp.util.ConsumerRequestExtension;
import com.liferay.wsrp.util.WSRPConfigurationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oasis.names.tc.wsrp.v2.types.UserProfile;
import org.apache.axis.message.MessageElement;

public class ConsumerRequestExtensionsHelper {
    private static final Log _log = LogFactoryUtil.getLog(ConsumerRequestExtensionsHelper.class);
    private static final ConsumerRequestExtensionsHelper _instance = new ConsumerRequestExtensionsHelper();
    private List<ConsumerRequestExtension> _consumerRequestExtensions = Collections.emptyList();

    public static void addClientAttributes(List<MessageElement> clientAttributes) {
        _instance._addClientAttributes(clientAttributes);
    }

    public static void addUserProfileAttributes(UserProfile userProfile, User user) {
        _instance._addUserProfileAttributes(userProfile, user);
    }

    private ConsumerRequestExtensionsHelper() {
        try {
            this._initConsumerRequestExtensions();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to instantiate consumer request extension", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void _addClientAttributes(List<MessageElement> clientAttributes) {
        for (ConsumerRequestExtension consumerRequestExtension : this._consumerRequestExtensions) {
            consumerRequestExtension.addClientAttributes(clientAttributes);
        }
    }

    private void _addUserProfileAttributes(UserProfile userProfile, User user) {
        for (ConsumerRequestExtension consumerRequestExtension : this._consumerRequestExtensions) {
            consumerRequestExtension.addUserProfileAttributes(userProfile, user);
        }
    }

    private void _initConsumerRequestExtensions() throws Exception {
        WSRPGroupServiceConfiguration wsrpGroupServiceConfiguration = WSRPConfigurationUtil.getWSRPConfiguration();
        String[] consumerRequestExtensionsClassNames = wsrpGroupServiceConfiguration.consumerRequestExtensions();
        if (consumerRequestExtensionsClassNames.length == 0) {
            return;
        }
        this._consumerRequestExtensions = new ArrayList<ConsumerRequestExtension>(consumerRequestExtensionsClassNames.length);
        for (String consumerRequestExtensionClassName : consumerRequestExtensionsClassNames) {
            if (!Validator.isNotNull((String)consumerRequestExtensionClassName)) continue;
            ConsumerRequestExtension consumerRequestExtension = (ConsumerRequestExtension)InstanceFactory.newInstance((String)consumerRequestExtensionClassName);
            this._consumerRequestExtensions.add(consumerRequestExtension);
        }
    }
}

