/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.activator;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.servlet.PortletServlet;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.wsrp.internal.jmx.WSRPConsumerPortletManager;
import com.liferay.wsrp.internal.util.ExtensionHelperUtil;
import com.liferay.wsrp.service.WSRPConsumerPortletLocalService;
import java.util.Dictionary;
import java.util.concurrent.FutureTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class WSRPActivator {
    private static final Log _log = LogFactoryUtil.getLog(WSRPActivator.class);
    private BundleContext _bundleContext;
    private FutureTask<Void> _initConsumerPortletsFutureTask;
    private ServiceTracker<MBeanServer, MBeanServer> _serviceTracker;
    private ServiceRegistration<Servlet> _servletServiceRegistration;
    @Reference
    private WSRPConsumerPortletLocalService _wsrpConsumerPortletLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        block2: {
            this._bundleContext = bundleContext;
            this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, MBeanServer.class, (ServiceTrackerCustomizer)new MBeanServerServiceTrackerCustomizer());
            this._serviceTracker.open();
            ExtensionHelperUtil.initialize();
            try {
                this._wsrpConsumerPortletLocalService.destroyWSRPConsumerPortlets();
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to destroy WSRP consumer portlets", (Throwable)pe);
            }
        }
        this._initConsumerPortletsFutureTask = new FutureTask<Void>(() -> {
            this._wsrpConsumerPortletLocalService.initWSRPConsumerPortlets();
            return null;
        });
        Thread thread = new Thread(this._initConsumerPortletsFutureTask, "WSRP Init Consumer Portlets Thread");
        thread.setDaemon(true);
        thread.start();
        this.createPortletServlet();
    }

    protected void createPortletServlet() {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=wsrp-service)");
        properties.put("osgi.http.whiteboard.servlet.name", PortletServlet.class.getName());
        properties.put("osgi.http.whiteboard.servlet.pattern", "/com_liferay_wsrp_portlet_WSRPConsumerPortlet/*");
        this._servletServiceRegistration = this._bundleContext.registerService(Servlet.class, (Object)new PortletServlet(){}, (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        block2: {
            this._servletServiceRegistration.unregister();
            try {
                this._wsrpConsumerPortletLocalService.destroyWSRPConsumerPortlets();
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to destroy WSRP consumer portlets", (Throwable)pe);
            }
        }
        this._serviceTracker.close();
        this._initConsumerPortletsFutureTask.cancel(true);
    }

    @Reference(target="(javax.portlet.name=com_liferay_wsrp_portlet_WSRPConsumerPortlet)", unbind="-")
    protected void setPortlet(Portlet portlet) {
    }

    private class MBeanServerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<MBeanServer, MBeanServer> {
        private MBeanServerServiceTrackerCustomizer() {
        }

        public MBeanServer addingService(ServiceReference<MBeanServer> serviceReference) {
            MBeanServer mBeanServer;
            block2: {
                mBeanServer = (MBeanServer)WSRPActivator.this._bundleContext.getService(serviceReference);
                try {
                    mBeanServer.registerMBean(new WSRPConsumerPortletManager(), new ObjectName("com.liferay.wsrp:classification=wsrp,name=WSRPConsumerPortletManager"));
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)"Unable to register WSRP consumer portlet manager", (Throwable)e);
                }
            }
            return mBeanServer;
        }

        public void modifiedService(ServiceReference<MBeanServer> serviceReference, MBeanServer mBeanServer) {
        }

        public void removedService(ServiceReference<MBeanServer> serviceReference, MBeanServer mBeanServer) {
        }
    }
}

