/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.proxy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.Array;
import java.util.Map;
import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v1.types.CookieProtocol;
import oasis.names.tc.wsrp.v1.types.MarkupParams;
import oasis.names.tc.wsrp.v1.types.PropertyDescription;
import oasis.names.tc.wsrp.v1.types.RuntimeContext;
import oasis.names.tc.wsrp.v1.types.StateChange;
import oasis.names.tc.wsrp.v2.types.NavigationalContext;
import oasis.names.tc.wsrp.v2.types.Property;
import oasis.names.tc.wsrp.v2.types.SessionParams;
import org.apache.commons.beanutils.PropertyUtils;

public class TypeConvertorUtil {
    private static final String _V1_PACKAGE = "oasis.names.tc.wsrp.v1.types.";
    private static final String _V2_PACKAGE = "oasis.names.tc.wsrp.v2.types.";
    private static final Log _log = LogFactoryUtil.getLog(TypeConvertorUtil.class);

    public static Object convert(Object source, int sourceVersion) throws Exception {
        if (source == null) {
            return null;
        }
        String sourcePackage = _V1_PACKAGE;
        String destinationPackage = _V2_PACKAGE;
        if (sourceVersion == 2) {
            sourcePackage = _V2_PACKAGE;
            destinationPackage = _V1_PACKAGE;
        }
        Class<?> sourceClass = source.getClass();
        String sourceClassName = sourceClass.getSimpleName();
        Object[] destination = null;
        if (sourceClass.isArray()) {
            destination = source;
            Class<?> componentType = sourceClass.getComponentType();
            String componentTypeName = componentType.getName();
            if (componentTypeName.contains(sourcePackage)) {
                Object[] sourceArray = (Object[])source;
                Class<?> destinationComponentType = Class.forName(destinationPackage + componentType.getSimpleName());
                Object[] destinationArray = (Object[])Array.newInstance(destinationComponentType, sourceArray.length);
                for (int i = 0; i < sourceArray.length; ++i) {
                    Object sourceArrayValue = sourceArray[i];
                    destinationArray[i] = TypeConvertorUtil.convert(sourceArrayValue, sourceVersion);
                }
                destination = destinationArray;
            }
        } else if (sourceClass == CookieProtocol.class) {
            CookieProtocol cookieProtocol = (CookieProtocol)source;
            destination = oasis.names.tc.wsrp.v2.types.CookieProtocol.fromValue((String)cookieProtocol.getValue());
        } else if (sourceClass == oasis.names.tc.wsrp.v2.types.CookieProtocol.class) {
            oasis.names.tc.wsrp.v2.types.CookieProtocol cookieProtocol = (oasis.names.tc.wsrp.v2.types.CookieProtocol)source;
            destination = CookieProtocol.fromValue((String)cookieProtocol.getValue());
        } else if (sourceClass == StateChange.class) {
            StateChange stateChange = (StateChange)source;
            destination = oasis.names.tc.wsrp.v2.types.StateChange.fromValue((String)stateChange.getValue());
        } else if (sourceClass == oasis.names.tc.wsrp.v2.types.StateChange.class) {
            oasis.names.tc.wsrp.v2.types.StateChange stateChange = (oasis.names.tc.wsrp.v2.types.StateChange)source;
            destination = StateChange.fromValue((String)stateChange.getValue());
        } else {
            Class<?> destinationClass = Class.forName(destinationPackage + sourceClassName);
            destination = destinationClass.newInstance();
            Map sourceChildren = PropertyUtils.describe((Object)source);
            for (Map.Entry sourceChildEntry : sourceChildren.entrySet()) {
                Object sourceChild;
                String sourceChildName = (String)sourceChildEntry.getKey();
                if (sourceChildName.equals("class") || (sourceChild = sourceChildEntry.getValue()) == null) continue;
                TypeConvertorUtil._convert(sourceVersion, sourcePackage, sourceClass, sourceChild, sourceChildName, destination);
            }
        }
        return destination;
    }

    private static void _convert(int sourceVersion, String sourcePackage, Object sourceClass, Object sourceChild, String sourceChildName, Object destination) throws Exception {
        block28: {
            Class<?> sourceChildClass = sourceChild.getClass();
            if (sourceChildClass == NavigationalContext.class) {
                sourceChildName = "navigationalState";
                NavigationalContext navigationalContext = (NavigationalContext)sourceChild;
                sourceChild = navigationalContext.getOpaqueValue();
            } else if (sourceChildClass == SessionParams.class) {
                sourceChildName = "sessionID";
                SessionParams sessionParams = (SessionParams)sourceChild;
                sourceChild = sessionParams.getSessionID();
            }
            if (sourceChild == null) {
                return;
            }
            sourceChildClass = sourceChild.getClass();
            Object destinationChild = null;
            if (sourceChildClass.isArray()) {
                destinationChild = TypeConvertorUtil.convert(sourceChild, sourceVersion);
            } else {
                destinationChild = sourceChild;
                sourceChildClass = sourceChild.getClass();
                String sourceChildClassName = sourceChildClass.getName();
                if (sourceChildClassName.contains(sourcePackage)) {
                    destinationChild = TypeConvertorUtil.convert(sourceChild, sourceVersion);
                }
            }
            String destinationChildName = sourceChildName;
            if (sourceChildName.equals("itemBinary")) {
                destinationChildName = "markupBinary";
            } else if (sourceChildName.equals("itemString")) {
                destinationChildName = "markupString";
            } else if (sourceChildName.equals("markupBinary")) {
                destinationChildName = "itemBinary";
            } else if (sourceChildName.equals("markupString")) {
                destinationChildName = "itemString";
            } else if (sourceChildName.equals("name") && sourceClass == Property.class) {
                QName qName = (QName)destinationChild;
                destinationChild = qName.getLocalPart();
            } else if (sourceChildName.equals("name") && sourceClass == PropertyDescription.class) {
                String name = (String)destinationChild;
                destinationChild = new QName("namespace", name, "prefix");
            } else if (sourceChildName.equals("navigationalState") && sourceClass == MarkupParams.class) {
                String navigationalState = (String)sourceChild;
                NavigationalContext navigationalContext = new NavigationalContext();
                navigationalContext.setOpaqueValue(navigationalState);
                destinationChild = navigationalContext;
                destinationChildName = "navigationalContext";
            } else if (sourceChildName.equals("requiresRewriting")) {
                destinationChildName = "requiresUrlRewriting";
            } else if (sourceChildName.equals("requiresUrlRewriting")) {
                destinationChildName = "requiresRewriting";
            } else if (sourceChildName.equals("sessionID") && sourceClass == RuntimeContext.class) {
                String sessionID = (String)sourceChild;
                SessionParams sessionParams = new SessionParams();
                sessionParams.setSessionID(sessionID);
                destinationChild = sessionParams;
                destinationChildName = "sessionParams";
            }
            try {
                PropertyUtils.setProperty((Object)destination, (String)destinationChildName, (Object)destinationChild);
            }
            catch (NoSuchMethodException nsme) {
                if (!_log.isWarnEnabled()) break block28;
                _log.warn((Object)nsme, (Throwable)nsme);
            }
        }
    }
}

