/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wsrp.configuration.WSRPGroupServiceConfiguration;
import com.liferay.wsrp.internal.util.WSRPConfigurationUtil;
import com.liferay.wsrp.internal.util.WSRPURLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=wsrp-service)", "osgi.http.whiteboard.servlet.name=com.liferay.wsrp.servlet.ProxyServlet", "osgi.http.whiteboard.servlet.pattern=/proxy/*"}, service={Servlet.class})
public class ProxyServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(ProxyServlet.class);
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    @Reference
    private WSRPConfigurationUtil _wsrpConfigurationUtil;
    @Reference
    private WSRPURLUtil _wsrpURLUtil;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            URL url = this.getAllowedURL(request);
            if (url != null) {
                this.proxyURL(request, response, url);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }

    protected URL getAllowedURL(HttpServletRequest request) throws Exception {
        String actualWSRPAuth;
        String urlString;
        long companyId = this._portal.getCompanyId(request);
        String expectedWSRPAuth = this._wsrpURLUtil.encodeWSRPAuth(companyId, urlString = ParamUtil.getString((HttpServletRequest)request, (String)"url"));
        if (!expectedWSRPAuth.equals(actualWSRPAuth = ParamUtil.getString((HttpServletRequest)request, (String)"wsrp-auth"))) {
            return null;
        }
        URL url = new URL(urlString);
        String protocol = url.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return null;
        }
        ProxyServlet proxyServlet = this;
        WSRPGroupServiceConfiguration wsrpGroupServiceConfiguration = proxyServlet._wsrpConfigurationUtil.getWSRPConfiguration();
        String[] allowedIps = wsrpGroupServiceConfiguration.proxyUrlIpsAllowed();
        if (allowedIps.length == 0) {
            return url;
        }
        String domain = url.getHost();
        InetAddress inetAddress = InetAddress.getByName(domain);
        String hostAddress = inetAddress.getHostAddress();
        Set computerAddresses = this._portal.getComputerAddresses();
        boolean serverIpIsHostAddress = computerAddresses.contains(hostAddress);
        for (String ip : allowedIps) {
            if ((!serverIpIsHostAddress || !ip.equals("SERVER_IP")) && !ip.equals(hostAddress)) continue;
            return url;
        }
        return null;
    }

    protected void proxyURL(HttpServletRequest request, HttpServletResponse response, URL url) throws Exception {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setIfModifiedSince(request.getDateHeader("If-Modified-Since"));
        HttpSession session = request.getSession();
        String cookie = (String)session.getAttribute("COOKIE");
        if (Validator.isNotNull((String)cookie)) {
            urlConnection.setRequestProperty("Cookie", cookie);
        }
        boolean useCaches = true;
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            Object headerValue;
            String headerName = (String)enumeration.nextElement();
            if (StringUtil.equalsIgnoreCase((String)headerName, (String)"Cookie") || StringUtil.equalsIgnoreCase((String)headerName, (String)"If-Modified-Since") || !Validator.isNotNull((String)(headerValue = request.getHeader(headerName)))) continue;
            if (StringUtil.equalsIgnoreCase((String)headerName, (String)"Cache-Control") && ((String)headerValue).contains("private, no-cache, no-store, must-revalidate")) {
                useCaches = false;
            }
            urlConnection.setRequestProperty(headerName, (String)headerValue);
        }
        urlConnection.setUseCaches(useCaches);
        urlConnection.connect();
        response.setContentLength(urlConnection.getContentLength());
        response.setContentType(urlConnection.getContentType());
        Map<String, List<String>> headers = urlConnection.getHeaderFields();
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            if (!Validator.isNotNull((String)headerName) || response.containsHeader(headerName)) continue;
            response.setHeader(headerName, urlConnection.getHeaderField(headerName));
        }
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            response.setStatus(httpURLConnection.getResponseCode());
        }
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)urlConnection.getInputStream());
    }
}

