/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.wsrp.internal.proxy.ServiceHandler;
import com.liferay.wsrp.internal.util.LocalizedStringUtil;
import com.liferay.wsrp.util.WSRPConsumerManager;
import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_Markup_PortType;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_PortletManagement_PortType;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_Registration_PortType;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_ServiceDescription_PortType;
import oasis.names.tc.wsrp.v2.types.EventDescription;
import oasis.names.tc.wsrp.v2.types.GetServiceDescription;
import oasis.names.tc.wsrp.v2.types.ModelDescription;
import oasis.names.tc.wsrp.v2.types.PortletDescription;
import oasis.names.tc.wsrp.v2.types.PropertyDescription;
import oasis.names.tc.wsrp.v2.types.RegistrationContext;
import oasis.names.tc.wsrp.v2.types.ServiceDescription;
import oasis.names.tc.wsrp.v2.wsdl.WSRP_v2_Service;
import org.apache.axis.attachments.AttachmentsImpl;

public class WSRPConsumerManagerImpl
implements WSRPConsumerManager {
    private static final String _WSDL_URI = "http://schemas.xmlsoap.org/wsdl/";
    private static final String _WSRP_V1_MARKUP_BINDING = "WSRP_v1_Markup_Binding_SOAP";
    private static final String _WSRP_V1_PORTLET_MANAGEMENT_BINDING = "WSRP_v1_PortletManagement_Binding_SOAP";
    private static final String _WSRP_V1_REGISTRATION_BINDING = "WSRP_v1_Registration_Binding_SOAP";
    private static final String _WSRP_V1_SERVICE_DESCRIPTION_BINDING = "WSRP_v1_ServiceDescription_Binding_SOAP";
    private static final String _WSRP_V2_MARKUP_BINDING = "WSRP_v2_Markup_Binding_SOAP";
    private static final String _WSRP_V2_PORTLET_MANAGEMENT_BINDING = "WSRP_v2_PortletManagement_Binding_SOAP";
    private static final String _WSRP_V2_REGISTRATION_BINDING = "WSRP_v2_Registration_Binding_SOAP";
    private static final String _WSRP_V2_SERVICE_DESCRIPTION_BINDING = "WSRP_v2_ServiceDescription_Binding_SOAP";
    private static final Log _log = LogFactoryUtil.getLog(WSRPConsumerManagerImpl.class);
    private Map<String, QName> _events;
    private URL _markupServiceURL;
    private Map<String, PortletDescription> _portletDescriptions;
    private WSRP_v2_PortletManagement_PortType _portletManagementService;
    private Map<String, PropertyDescription> _propertyDescriptions;
    private WSRP_v2_Registration_PortType _registrationService;
    private final WSRP_v2_Service _service;
    private ServiceDescription _serviceDescription;
    private WSRP_v2_ServiceDescription_PortType _serviceDescriptionService;
    private final String _wsdl;
    private final Namespace _wsdlNamespace;

    public WSRPConsumerManagerImpl(String url, RegistrationContext registrationContext, String forwardCookies, String forwardHeaders, String userToken) throws Exception {
        try {
            this._wsdl = HttpUtil.URLtoString((String)url);
            Document document = SAXReaderUtil.read((String)this._wsdl);
            Element root = document.getRootElement();
            this._wsdlNamespace = this._getWsdlNamespace(root);
            List serviceElements = root.elements(this._getWsdlQName("service"));
            ServiceHandler serviceHandler = new ServiceHandler(forwardCookies, forwardHeaders, userToken, this._isV2(serviceElements));
            this._service = (WSRP_v2_Service)ProxyUtil.newProxyInstance((ClassLoader)WSRP_v2_Service.class.getClassLoader(), (Class[])new Class[]{WSRP_v2_Service.class}, (InvocationHandler)serviceHandler);
            this._readServiceElements(serviceElements);
            this.updateServiceDescription(registrationContext);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            throw e;
        }
    }

    public String getDisplayName(PortletDescription portletDescription) {
        String displayName = LocalizedStringUtil.getLocalizedStringValue(portletDescription.getDisplayName());
        if (displayName == null) {
            displayName = LocalizedStringUtil.getLocalizedStringValue(portletDescription.getShortTitle());
        }
        if (displayName == null) {
            displayName = LocalizedStringUtil.getLocalizedStringValue(portletDescription.getTitle());
        }
        if (displayName == null) {
            displayName = portletDescription.getPortletHandle();
        }
        return displayName;
    }

    public QName getEventQName(QName qName) {
        String key = PortletQNameUtil.getKey((String)qName.getNamespaceURI(), (String)qName.getLocalPart());
        return this._events.get(key);
    }

    public WSRP_v2_Markup_PortType getMarkupService() throws Exception {
        return this._service.getWSRP_v2_Markup_Service(this._markupServiceURL);
    }

    public PortletDescription getPortletDescription(String portletHandle) {
        return this._portletDescriptions.get(portletHandle);
    }

    public WSRP_v2_PortletManagement_PortType getPortletManagementService() {
        return this._portletManagementService;
    }

    public PropertyDescription getPropertyDescription(String name) {
        return this._propertyDescriptions.get(name);
    }

    public PropertyDescription[] getPropertyDescriptions() {
        PropertyDescription[] propertyDescriptions = null;
        ModelDescription modelDescription = this._serviceDescription.getRegistrationPropertyDescription();
        if (modelDescription != null) {
            propertyDescriptions = modelDescription.getPropertyDescriptions();
        }
        if (propertyDescriptions == null) {
            propertyDescriptions = new PropertyDescription[]{};
        }
        return propertyDescriptions;
    }

    public WSRP_v2_Registration_PortType getRegistrationService() {
        return this._registrationService;
    }

    public ServiceDescription getServiceDescription() {
        return this._serviceDescription;
    }

    public String getWsdl() {
        return this._wsdl;
    }

    public void updateServiceDescription(RegistrationContext registrationContext) throws Exception {
        GetServiceDescription getServiceDescription = new GetServiceDescription();
        if (registrationContext != null) {
            getServiceDescription.setRegistrationContext(registrationContext);
        }
        Thread currentThread = Thread.currentThread();
        try {
            currentThread.setContextClassLoader(AttachmentsImpl.class.getClassLoader());
            this._serviceDescription = this._serviceDescriptionService.getServiceDescription(getServiceDescription);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            currentThread.setContextClassLoader(WSRPConsumerManager.class.getClassLoader());
        }
        this._portletDescriptions = new HashMap<String, PortletDescription>();
        PortletDescription[] portletDescriptions = this._serviceDescription.getOfferedPortlets();
        if (portletDescriptions != null) {
            for (PortletDescription portletDescription : portletDescriptions) {
                this._portletDescriptions.put(portletDescription.getPortletHandle(), portletDescription);
            }
        }
        this._propertyDescriptions = new HashMap<String, PropertyDescription>();
        PropertyDescription[] propertyDescriptions = this.getPropertyDescriptions();
        if (propertyDescriptions != null) {
            for (PropertyDescription propertyDescription : propertyDescriptions) {
                QName qName = propertyDescription.getName();
                this._propertyDescriptions.put(qName.toString(), propertyDescription);
            }
        }
        this._events = new HashMap<String, QName>();
        EventDescription[] eventDescriptions = this._serviceDescription.getEventDescriptions();
        if (eventDescriptions != null) {
            for (EventDescription eventDescription : eventDescriptions) {
                QName[] aliases = eventDescription.getAliases();
                QName qName = eventDescription.getName();
                String key = PortletQNameUtil.getKey((String)qName.getNamespaceURI(), (String)qName.getLocalPart());
                this._events.put(key, qName);
                if (aliases == null) continue;
                for (QName alias : aliases) {
                    key = PortletQNameUtil.getKey((String)alias.getNamespaceURI(), (String)alias.getLocalPart());
                    this._events.put(key, qName);
                }
            }
        }
    }

    private Namespace _getWsdlNamespace(Element element) {
        return element.getNamespaceForURI(_WSDL_URI);
    }

    private com.liferay.portal.kernel.xml.QName _getWsdlQName(String localName) {
        return SAXReaderUtil.createQName((String)localName, (Namespace)this._wsdlNamespace);
    }

    private boolean _isV2(List<Element> serviceElements) {
        for (Element serviceElement : serviceElements) {
            List bindingElements = serviceElement.elements(this._getWsdlQName("port"));
            Element firstBindingElement = (Element)bindingElements.get(0);
            String binding = firstBindingElement.attributeValue("binding");
            if (!binding.contains("v2")) continue;
            return true;
        }
        return false;
    }

    private void _readBindingElement(Element bindingElement) throws Exception {
        String binding = bindingElement.attributeValue("binding");
        int pos = binding.indexOf(":");
        binding = binding.substring(pos + 1);
        Element addressElement = bindingElement.element("address");
        String bindingLocation = addressElement.attributeValue("location");
        URL bindingLocationURL = new URL(bindingLocation);
        if (binding.equals(_WSRP_V1_MARKUP_BINDING) || binding.equals(_WSRP_V2_MARKUP_BINDING)) {
            this._markupServiceURL = bindingLocationURL;
        } else if (binding.equals(_WSRP_V1_PORTLET_MANAGEMENT_BINDING) || binding.equals(_WSRP_V2_PORTLET_MANAGEMENT_BINDING)) {
            this._portletManagementService = this._service.getWSRP_v2_PortletManagement_Service(bindingLocationURL);
        } else if (binding.equals(_WSRP_V1_REGISTRATION_BINDING) || binding.equals(_WSRP_V2_REGISTRATION_BINDING)) {
            this._registrationService = this._service.getWSRP_v2_Registration_Service(bindingLocationURL);
        } else if (binding.equals(_WSRP_V1_SERVICE_DESCRIPTION_BINDING) || binding.equals(_WSRP_V2_SERVICE_DESCRIPTION_BINDING)) {
            this._serviceDescriptionService = this._service.getWSRP_v2_ServiceDescription_Service(bindingLocationURL);
        }
    }

    private void _readServiceElements(List<Element> serviceElements) throws Exception {
        for (Element serviceElement : serviceElements) {
            List bindingElements = serviceElement.elements(this._getWsdlQName("port"));
            for (Element bindingElement : bindingElements) {
                this._readBindingElement(bindingElement);
            }
            Element firstBindingElement = (Element)bindingElements.get(0);
            String binding = firstBindingElement.attributeValue("binding");
            if (!binding.contains("v2")) continue;
            break;
        }
    }
}

