/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wsrp.exception.NoSuchProducerException;
import com.liferay.wsrp.exception.WSRPProducerNameException;
import com.liferay.wsrp.model.WSRPProducer;
import com.liferay.wsrp.service.base.WSRPProducerLocalServiceBaseImpl;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class WSRPProducerLocalServiceImpl
extends WSRPProducerLocalServiceBaseImpl {
    private static final String _WSRP_GROUP_NAME = "WSRP";

    public WSRPProducer addWSRPProducer(long userId, long groupId, String name, String version, String portletIds, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        portletIds = this.transformPortletIds(portletIds);
        Date now = new Date();
        this.validate(name);
        long wsrpProducerId = this.counterLocalService.increment();
        WSRPProducer wsrpProducer = this.wsrpProducerPersistence.create(wsrpProducerId);
        wsrpProducer.setUuid(serviceContext.getUuid());
        wsrpProducer.setGroupId(groupId);
        wsrpProducer.setCompanyId(user.getCompanyId());
        wsrpProducer.setCreateDate(now);
        wsrpProducer.setModifiedDate(now);
        wsrpProducer.setName(name);
        wsrpProducer.setVersion(version);
        wsrpProducer.setPortletIds(portletIds);
        this.wsrpProducerPersistence.update((BaseModel)wsrpProducer);
        return wsrpProducer;
    }

    public WSRPProducer addWSRPProducer(long userId, String name, String version, String portletIds, ServiceContext serviceContext) throws PortalException {
        Group group = this.addGroup(userId, name);
        return this.addWSRPProducer(userId, group.getGroupId(), name, version, portletIds, serviceContext);
    }

    @Override
    public WSRPProducer deleteWSRPProducer(long wsrpProducerId) throws PortalException {
        WSRPProducer wsrpProducer = this.wsrpProducerPersistence.findByPrimaryKey(wsrpProducerId);
        return this.wsrpProducerLocalService.deleteWSRPProducer(wsrpProducer);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public WSRPProducer deleteWSRPProducer(WSRPProducer wsrpProducer) throws PortalException {
        this.wsrpProducerPersistence.remove((BaseModel)wsrpProducer);
        this.groupLocalService.deleteGroup(wsrpProducer.getGroupId());
        return wsrpProducer;
    }

    public void deleteWSRPProducers(long companyId) throws PortalException {
        List wsrpProducers = this.wsrpProducerPersistence.findByCompanyId(companyId);
        for (WSRPProducer wsrpProducer : wsrpProducers) {
            this.wsrpProducerLocalService.deleteWSRPProducer(wsrpProducer);
        }
    }

    public WSRPProducer getWSRPProducer(String wsrpProducerUuid) throws PortalException {
        List wsrpProducers = this.wsrpProducerPersistence.findByUuid(wsrpProducerUuid);
        if (wsrpProducers.isEmpty()) {
            throw new NoSuchProducerException("No WSRP producer exists with uuid " + wsrpProducerUuid);
        }
        return (WSRPProducer)wsrpProducers.get(0);
    }

    public List<WSRPProducer> getWSRPProducers(long companyId, int start, int end) {
        return this.wsrpProducerPersistence.findByCompanyId(companyId, start, end);
    }

    public int getWSRPProducersCount(long companyId) {
        return this.wsrpProducerPersistence.countByCompanyId(companyId);
    }

    public WSRPProducer updateWSRPProducer(long wsrpProducerId, String name, String version, String portletIds) throws PortalException {
        portletIds = this.transformPortletIds(portletIds);
        this.validate(name);
        WSRPProducer wsrpProducer = this.wsrpProducerPersistence.findByPrimaryKey(wsrpProducerId);
        wsrpProducer.setModifiedDate(new Date());
        wsrpProducer.setName(name);
        wsrpProducer.setVersion(version);
        wsrpProducer.setPortletIds(portletIds);
        this.wsrpProducerPersistence.update((BaseModel)wsrpProducer);
        this.updateGroup(wsrpProducer, name);
        return wsrpProducer;
    }

    protected Group addGroup(long userId, String name) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        name = this.getGroupName(name);
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        int type = 4;
        params.put("type", type);
        List groups = this.groupLocalService.search(user.getCompanyId(), name, params, 0, 1);
        if (!groups.isEmpty()) {
            return (Group)groups.get(0);
        }
        Group group = this.groupLocalService.addGroup(user.getUserId(), 0L, null, 0L, 0L, name, null, type, true, 0, null, true, true, null);
        this.layoutLocalService.addLayout(user.getUserId(), group.getGroupId(), false, 0L, "Portlets", null, null, "portlet", false, "/portlets", new ServiceContext());
        return group;
    }

    protected String getFullInstanceSeparator() {
        String instanceId = PwdGenerator.getPassword((String)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", (int)4);
        return "_INSTANCE_" + instanceId;
    }

    protected String getGroupName(String name) {
        return "WSRP-" + name;
    }

    protected String transformPortletIds(String portletIds) {
        Object[] portletIdsArray = StringUtil.split((String)portletIds);
        for (int i = 0; i < portletIdsArray.length; ++i) {
            Portlet portlet;
            Object portletId = portletIdsArray[i];
            if (((String)portletId).contains("_INSTANCE_") || !(portlet = this.portletLocalService.getPortletById((String)portletId)).isInstanceable()) continue;
            String instanceId = PwdGenerator.getPassword((String)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", (int)4);
            portletIdsArray[i] = (String)portletId + "_INSTANCE_" + instanceId;
        }
        return StringUtil.merge((Object[])portletIdsArray);
    }

    protected void updateGroup(WSRPProducer wsrpProducer, String name) throws PortalException {
        Group group = this.groupLocalService.getGroup(wsrpProducer.getGroupId());
        group.setName(this.getGroupName(name));
        this.groupLocalService.updateGroup(group);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new WSRPProducerNameException();
        }
    }
}

