/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.delay.queue;

import cn.hutool.core.thread.NamedThreadFactory;
import com.lmaye.cloud.starter.delay.queue.DelayQueueProperties;
import com.lmaye.cloud.starter.delay.queue.service.DelayQueueService;
import com.lmaye.cloud.starter.delay.queue.service.RedisDelayQueueTask;
import com.lmaye.cloud.starter.delay.queue.service.impl.DelayQueueServiceImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@EnableConfigurationProperties(value={DelayQueueProperties.class})
@ConditionalOnProperty(value={"enabled"}, prefix="delay-queue", matchIfMissing=true)
public class DelayQueueAutoConfiguration {
    @Autowired
    private DelayQueueProperties properties;

    @Bean
    DelayQueueService delayQueueService() {
        return new DelayQueueServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisTemplate.class})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setEnableTransactionSupport(true);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }

    @Bean(destroyMethod="shutdown")
    ExecutorService executorService() {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(this.properties.getCorePoolSize(), (ThreadFactory)new NamedThreadFactory("scheduleThreadPool", false), new ThreadPoolExecutor.AbortPolicy());
        executorService.scheduleWithFixedDelay(new RedisDelayQueueTask(this.delayQueueService()), this.properties.getInitialDelay(), this.properties.getDelay(), TimeUnit.SECONDS);
        return executorService;
    }
}

