/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.delay.queue.producer;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.lmaye.cloud.core.utils.GsonUtils;
import com.lmaye.cloud.starter.delay.queue.DelayQueueProperties;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRetryListener
implements RetryListener {
    private static final Logger log = LoggerFactory.getLogger(KafkaRetryListener.class);
    private final DelayQueueProperties properties;

    public <SendResult> void onRetry(Attempt<SendResult> attempt) {
        if (attempt.hasException()) {
            log.error("[Retry] exception: ", attempt.getExceptionCause());
        } else if (attempt.hasResult()) {
            if (Objects.isNull(attempt.getResult())) {
                log.error("[Retry] return data is null");
            } else {
                log.debug("[Retry] return data is: {}", (Object)GsonUtils.toJson((Object)attempt.getResult()));
            }
        }
        if (Objects.equals(this.properties.getRetryNums(), attempt.getAttemptNumber())) {
            log.debug("-------------------> Send Massage <-------------------");
        }
    }

    public KafkaRetryListener(DelayQueueProperties properties) {
        this.properties = properties;
    }
}

