/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.delay.queue.service.impl;

import com.lmaye.cloud.core.utils.GsonUtils;
import com.lmaye.cloud.starter.delay.queue.DelayQueueProperties;
import com.lmaye.cloud.starter.delay.queue.entity.DelayQueueBody;
import com.lmaye.cloud.starter.delay.queue.producer.KafkaProducer;
import com.lmaye.cloud.starter.delay.queue.service.DelayQueueService;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DelayQueueServiceImpl
implements DelayQueueService {
    private static final Logger log = LoggerFactory.getLogger(DelayQueueServiceImpl.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private KafkaProducer kafkaProducer;
    @Autowired
    private DelayQueueProperties properties;

    @Override
    @Async
    public void taskHandle() {
        Set dts = this.redisTemplate.opsForZSet().rangeByScore((Object)this.properties.getQueueCacheKey(), 0.0, (double)System.currentTimeMillis());
        assert (dts != null);
        dts.forEach(it -> {
            log.debug("----- \u4efb\u52a1\u5f00\u59cb\uff0c\u5ef6\u8fdf\u961f\u5217Body: {}", it);
            DelayQueueBody body = (DelayQueueBody)GsonUtils.fromJson((String)it.toString(), DelayQueueBody.class);
            RLock lock = this.redissonClient.getLock(this.properties.getLockKey() + body.getSerialNo());
            try {
                lock.tryLock(100L, 300L, TimeUnit.SECONDS);
                this.kafkaProducer.send(body.getTopic(), GsonUtils.toJson((Object)body));
                this.redisTemplate.opsForZSet().remove((Object)this.properties.getQueueCacheKey(), new Object[]{it});
                log.debug("===== \u4efb\u52a1\u5904\u7406\u5b8c\u6210 =====");
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u5931\u8d25: ", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        });
    }
}

