/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lmaye.cloud.starter.web.WebProperties;
import com.lmaye.cloud.starter.web.utils.JsonUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={DispatcherServlet.class})
@EnableConfigurationProperties(value={WebProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebAutoConfiguration
implements WebMvcConfigurer {
    @Bean(value={"webProperties"})
    WebProperties webProperties() {
        return new WebProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper objectMapper() {
        return JsonUtils.getObjectMapper();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }
}

