/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web.config;

import feign.RequestInterceptor;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignEncoderConfig {
    private static final Logger log = LoggerFactory.getLogger(FeignEncoderConfig.class);
    private final ObjectFactory<HttpMessageConverters> messageConverters;
    private static final String[] HEADERS = new String[]{"Authorization", "clientId", "language", "timeZone"};

    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder feignFormEncoder() {
        return new SpringFormEncoder((Encoder)new SpringEncoder(this.messageConverters));
    }

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (!Objects.isNull(attributes)) {
                HttpServletRequest request = attributes.getRequest();
                log.info("Feign request: {}", (Object)request.getRequestURI());
                for (String key : HEADERS) {
                    requestTemplate.header(key, new String[]{request.getHeader(key)});
                }
            }
        };
    }

    public FeignEncoderConfig(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }
}

