/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web.config;

import com.lmaye.cloud.core.context.IResultCode;
import com.lmaye.cloud.core.context.ResultCode;
import com.lmaye.cloud.core.exception.CoreException;
import com.lmaye.cloud.core.exception.HandleException;
import com.lmaye.cloud.core.exception.ServiceException;
import com.lmaye.cloud.core.utils.GsonUtils;
import com.lmaye.cloud.starter.web.context.ResultVO;
import com.lmaye.cloud.starter.web.validator.ValidateErrors;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionAdvice.class);

    @ExceptionHandler(value={Exception.class})
    public ResultVO<String> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return ResultVO.response((IResultCode)ResultCode.FAILURE, e.getMessage());
    }

    @ExceptionHandler(value={CoreException.class})
    public <T> ResultVO<T> handleCoreException(CoreException e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ResultVO(e.getResultCode());
    }

    @ExceptionHandler(value={ServiceException.class})
    public <T> ResultVO<T> handleServiceException(ServiceException e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ResultVO(e.getResultCode());
    }

    @ExceptionHandler(value={HandleException.class})
    public <T> ResultVO<T> handleHandleException(HandleException e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ResultVO(e.getResultCode());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultVO<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        return ResultVO.response((IResultCode)ResultCode.FAILURE, GsonUtils.toJson((Object)ValidateErrors.builder().errors((Errors)e.getBindingResult()).build()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResultVO<String> constraintViolationException(ConstraintViolationException e) {
        Set constraintViolations = e.getConstraintViolations();
        HashMap<String, String> fieldErrors = new HashMap<String, String>(constraintViolations.size());
        for (ConstraintViolation constraintViolation : constraintViolations) {
            Path propertyPath = constraintViolation.getPropertyPath();
            Iterator iterator = propertyPath.iterator();
            Path.Node node = null;
            while (iterator.hasNext()) {
                node = (Path.Node)iterator.next();
            }
            if (node == null) continue;
            fieldErrors.put(node.getName(), constraintViolation.getMessage());
        }
        return ResultVO.response((IResultCode)ResultCode.FAILURE, GsonUtils.toJson((Object)ValidateErrors.builder().fieldErrors(fieldErrors).build()));
    }
}

