/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web.context;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.lmaye.cloud.core.context.IResultCode;
import com.lmaye.cloud.core.context.ResultCode;
import com.lmaye.cloud.starter.web.WebProperties;
import com.lmaye.cloud.starter.web.utils.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="ResultVO", description="\u54cd\u5e94\u7ed3\u679c")
public class ResultVO<T>
implements Serializable {
    @ApiModelProperty(value="\u54cd\u5e94\u4ee3\u7801")
    private Integer code;
    @ApiModelProperty(value="\u54cd\u5e94\u6d88\u606f")
    private String msg;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private T data;

    public ResultVO() {
    }

    public ResultVO(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResultVO(IResultCode resultCode) {
        this.initParams(resultCode);
    }

    public ResultVO(IResultCode resultCode, T data) {
        this.initParams(resultCode);
        this.data = data;
    }

    private void initParams(IResultCode resultCode) {
        this.code = resultCode.getCode();
        WebProperties webProperties = (WebProperties)SpringUtils.getBean("webProperties");
        String key = resultCode.getKey();
        this.msg = StringUtils.isBlank((CharSequence)key) || webProperties.getI18n().getEnabled() == false ? resultCode.getDesc() : key;
    }

    public static <T> ResultVO<T> success(T data) {
        return new ResultVO<T>((IResultCode)ResultCode.SUCCESS, data);
    }

    public static <T> ResultVO<T> failed() {
        return new ResultVO<Object>((IResultCode)ResultCode.FAILURE, null);
    }

    public static <T> ResultVO<T> response(IResultCode resultCode, T data) {
        return new ResultVO<T>(resultCode, data);
    }

    public boolean isSuccess() {
        if (Objects.isNull(this.code)) {
            return false;
        }
        return Objects.equals(ResultCode.SUCCESS.getCode(), this.code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public ResultVO<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public ResultVO<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public ResultVO<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultVO)) {
            return false;
        }
        ResultVO other = (ResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultVO(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

