/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web.controller;

import com.lmaye.cloud.starter.web.context.PageResult;
import com.lmaye.cloud.starter.web.context.ResultVO;
import com.lmaye.cloud.starter.web.query.ListQuery;
import com.lmaye.cloud.starter.web.query.PageQuery;
import com.lmaye.cloud.starter.web.service.IAppService;
import com.lmaye.cloud.starter.web.service.IRestConverter;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseController<S extends IAppService<T, ID>, C extends IRestConverter<T, V, D>, T extends Serializable, V extends Serializable, D extends Serializable, ID extends Serializable>
implements IRestConverter<T, V, D> {
    protected final S service;
    protected final C restConverter;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e")
    public ResultVO<V> add(@RequestBody @Validated D param) {
        return this.service.insert(this.restConverter.convertDtoToEntity(param)).map(it -> ResultVO.success(this.restConverter.convertEntityToVo((Serializable)it))).orElseGet(() -> ResultVO.success(null));
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u7f16\u8f91")
    public ResultVO<V> edit(@RequestBody @Validated D param) {
        return this.service.update(this.restConverter.convertDtoToEntity(param)).map(it -> ResultVO.success(this.restConverter.convertEntityToVo((Serializable)it))).orElseGet(() -> ResultVO.success(null));
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664")
    public ResultVO<Boolean> delete(@PathVariable @ApiParam(value="\u4e3b\u952eID", required=true) ID id) {
        return ResultVO.success(this.service.deleteById(id));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u67e5\u8be2")
    public ResultVO<V> queryById(@PathVariable @ApiParam(value="\u4e3b\u952eID", required=true) ID id) {
        return this.service.findById(id).map(it -> ResultVO.success(this.restConverter.convertEntityToVo((Serializable)it))).orElseGet(() -> ResultVO.success(null));
    }

    @PostMapping(value={"/queryRecords"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public ResultVO<List<V>> queryRecords(@RequestBody ListQuery query) {
        return ResultVO.success(this.service.findAll(query).stream().map(arg_0 -> this.restConverter.convertEntityToVo(arg_0)).collect(Collectors.toList()));
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ResultVO<PageResult<V>> queryPage(@RequestBody PageQuery query) {
        PageResult result = new PageResult();
        PageResult pageResult = this.service.findPage(query);
        result.setRecords(pageResult.getRecords().stream().map(arg_0 -> this.restConverter.convertEntityToVo(arg_0)).collect(Collectors.toList()));
        result.setPageIndex(pageResult.getPageIndex());
        result.setPageSize(pageResult.getPageSize());
        result.setPages(pageResult.getPages());
        result.setTotal(pageResult.getTotal());
        return ResultVO.success(result);
    }

    public BaseController(S service, C restConverter) {
        this.service = service;
        this.restConverter = restConverter;
    }
}

