/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web.validator;

import com.lmaye.cloud.starter.web.validator.constraints.Mobile;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.logging.log4j.util.Strings;

public class MobileValidator
implements ConstraintValidator<Mobile, String> {
    private static final Pattern MOBILE_PATTERN = Pattern.compile("1\\d{10}");

    public static boolean isMobile(String mobile) {
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    public void initialize(Mobile constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return Strings.isBlank((String)value) || MobileValidator.isMobile(value);
    }
}

