/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.cloud.starter.web.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class ValidateErrors
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> globalErrors;
    private Map<String, String> fieldErrors;

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getGlobalErrors() {
        return this.globalErrors;
    }

    public Map<String, String> getFieldErrors() {
        return this.fieldErrors;
    }

    public void setGlobalErrors(List<String> globalErrors) {
        this.globalErrors = globalErrors;
    }

    public void setFieldErrors(Map<String, String> fieldErrors) {
        this.fieldErrors = fieldErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidateErrors)) {
            return false;
        }
        ValidateErrors other = (ValidateErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$globalErrors = this.getGlobalErrors();
        List<String> other$globalErrors = other.getGlobalErrors();
        if (this$globalErrors == null ? other$globalErrors != null : !((Object)this$globalErrors).equals(other$globalErrors)) {
            return false;
        }
        Map<String, String> this$fieldErrors = this.getFieldErrors();
        Map<String, String> other$fieldErrors = other.getFieldErrors();
        return !(this$fieldErrors == null ? other$fieldErrors != null : !((Object)this$fieldErrors).equals(other$fieldErrors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidateErrors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $globalErrors = this.getGlobalErrors();
        result = result * 59 + ($globalErrors == null ? 43 : ((Object)$globalErrors).hashCode());
        Map<String, String> $fieldErrors = this.getFieldErrors();
        result = result * 59 + ($fieldErrors == null ? 43 : ((Object)$fieldErrors).hashCode());
        return result;
    }

    public String toString() {
        return "ValidateErrors(globalErrors=" + this.getGlobalErrors() + ", fieldErrors=" + this.getFieldErrors() + ")";
    }

    public static class Builder {
        private Errors errors;
        private List<String> globalErrors;
        private Map<String, String> fieldErrors;

        public Builder errors(Errors errors) {
            this.errors = errors;
            return this;
        }

        public Builder globalErrors(List<String> globalErrors) {
            this.globalErrors = globalErrors;
            return this;
        }

        public Builder fieldErrors(Map<String, String> fieldErrors) {
            this.fieldErrors = fieldErrors;
            return this;
        }

        public ValidateErrors build() {
            ValidateErrors validateErrors = new ValidateErrors();
            if (this.errors != null) {
                String message;
                if (this.errors.hasGlobalErrors()) {
                    validateErrors.setGlobalErrors(new ArrayList<String>(this.errors.getGlobalErrors().size()));
                    for (ObjectError error : this.errors.getGlobalErrors()) {
                        message = error.getDefaultMessage();
                        validateErrors.getGlobalErrors().add(message);
                    }
                }
                if (this.errors.hasFieldErrors()) {
                    validateErrors.setFieldErrors(new HashMap<String, String>(this.errors.getFieldErrors().size()));
                    for (ObjectError error : this.errors.getFieldErrors()) {
                        message = error.getDefaultMessage();
                        validateErrors.getFieldErrors().put(error.getField(), message);
                    }
                }
            }
            if (this.fieldErrors != null) {
                validateErrors.fieldErrors = this.fieldErrors;
            }
            if (this.globalErrors != null) {
                validateErrors.globalErrors = this.globalErrors;
            }
            return validateErrors;
        }
    }
}

