/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.GetOrCreateSamlUserOptions;
import com.mailslurp.models.UserDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiInternalControllerApi {
    private ApiClient localVarApiClient;

    public ApiInternalControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiInternalControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getSamlUserOrCreate
     * @param key  (required)
     * @param getOrCreateSamlUserOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSamlUserOrCreateCall(String key, GetOrCreateSamlUserOptions getOrCreateSamlUserOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = getOrCreateSamlUserOptions;

        // create path and map variables
        String localVarPath = "/internal/saml/user";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSamlUserOrCreateValidateBeforeCall(String key, GetOrCreateSamlUserOptions getOrCreateSamlUserOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getSamlUserOrCreate(Async)");
        }
        
        // verify the required parameter 'getOrCreateSamlUserOptions' is set
        if (getOrCreateSamlUserOptions == null) {
            throw new ApiException("Missing the required parameter 'getOrCreateSamlUserOptions' when calling getSamlUserOrCreate(Async)");
        }
        

        okhttp3.Call localVarCall = getSamlUserOrCreateCall(key, getOrCreateSamlUserOptions, _callback);
        return localVarCall;

    }

    /**
     * 
     * 
     * @param key  (required)
     * @param getOrCreateSamlUserOptions  (required)
     * @return UserDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserDto getSamlUserOrCreate(String key, GetOrCreateSamlUserOptions getOrCreateSamlUserOptions) throws ApiException {
        ApiResponse<UserDto> localVarResp = getSamlUserOrCreateWithHttpInfo(key, getOrCreateSamlUserOptions);
        return localVarResp.getData();
    }

    /**
     * 
     * 
     * @param key  (required)
     * @param getOrCreateSamlUserOptions  (required)
     * @return ApiResponse&lt;UserDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserDto> getSamlUserOrCreateWithHttpInfo(String key, GetOrCreateSamlUserOptions getOrCreateSamlUserOptions) throws ApiException {
        okhttp3.Call localVarCall = getSamlUserOrCreateValidateBeforeCall(key, getOrCreateSamlUserOptions, null);
        Type localVarReturnType = new TypeToken<UserDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * 
     * @param key  (required)
     * @param getOrCreateSamlUserOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSamlUserOrCreateAsync(String key, GetOrCreateSamlUserOptions getOrCreateSamlUserOptions, final ApiCallback<UserDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSamlUserOrCreateValidateBeforeCall(key, getOrCreateSamlUserOptions, _callback);
        Type localVarReturnType = new TypeToken<UserDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
