/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.BouncedEmailDto;
import com.mailslurp.models.BouncedRecipientDto;
import com.mailslurp.models.FilterBouncedRecipientsOptions;
import com.mailslurp.models.FilterBouncedRecipientsResult;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageBouncedEmail;
import com.mailslurp.models.PageBouncedRecipients;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BounceControllerApi {
    private ApiClient localVarApiClient;

    public BounceControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BounceControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for filterBouncedRecipient
     * @param filterBouncedRecipientsOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call filterBouncedRecipientCall(FilterBouncedRecipientsOptions filterBouncedRecipientsOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = filterBouncedRecipientsOptions;

        // create path and map variables
        String localVarPath = "/bounce/filter-recipients";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call filterBouncedRecipientValidateBeforeCall(FilterBouncedRecipientsOptions filterBouncedRecipientsOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'filterBouncedRecipientsOptions' is set
        if (filterBouncedRecipientsOptions == null) {
            throw new ApiException("Missing the required parameter 'filterBouncedRecipientsOptions' when calling filterBouncedRecipient(Async)");
        }
        

        okhttp3.Call localVarCall = filterBouncedRecipientCall(filterBouncedRecipientsOptions, _callback);
        return localVarCall;

    }

    /**
     * Filter a list of email recipients and remove those who have bounced
     * Prevent email sending errors by remove recipients who have resulted in past email bounces or complaints
     * @param filterBouncedRecipientsOptions  (required)
     * @return FilterBouncedRecipientsResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public FilterBouncedRecipientsResult filterBouncedRecipient(FilterBouncedRecipientsOptions filterBouncedRecipientsOptions) throws ApiException {
        ApiResponse<FilterBouncedRecipientsResult> localVarResp = filterBouncedRecipientWithHttpInfo(filterBouncedRecipientsOptions);
        return localVarResp.getData();
    }

    /**
     * Filter a list of email recipients and remove those who have bounced
     * Prevent email sending errors by remove recipients who have resulted in past email bounces or complaints
     * @param filterBouncedRecipientsOptions  (required)
     * @return ApiResponse&lt;FilterBouncedRecipientsResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FilterBouncedRecipientsResult> filterBouncedRecipientWithHttpInfo(FilterBouncedRecipientsOptions filterBouncedRecipientsOptions) throws ApiException {
        okhttp3.Call localVarCall = filterBouncedRecipientValidateBeforeCall(filterBouncedRecipientsOptions, null);
        Type localVarReturnType = new TypeToken<FilterBouncedRecipientsResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Filter a list of email recipients and remove those who have bounced (asynchronously)
     * Prevent email sending errors by remove recipients who have resulted in past email bounces or complaints
     * @param filterBouncedRecipientsOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call filterBouncedRecipientAsync(FilterBouncedRecipientsOptions filterBouncedRecipientsOptions, final ApiCallback<FilterBouncedRecipientsResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = filterBouncedRecipientValidateBeforeCall(filterBouncedRecipientsOptions, _callback);
        Type localVarReturnType = new TypeToken<FilterBouncedRecipientsResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBouncedEmail
     * @param id ID of the bounced email to fetch (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedEmailCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/bounce/emails/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBouncedEmailValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBouncedEmail(Async)");
        }
        

        okhttp3.Call localVarCall = getBouncedEmailCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get a bounced email.
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param id ID of the bounced email to fetch (required)
     * @return BouncedEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BouncedEmailDto getBouncedEmail(UUID id) throws ApiException {
        ApiResponse<BouncedEmailDto> localVarResp = getBouncedEmailWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get a bounced email.
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param id ID of the bounced email to fetch (required)
     * @return ApiResponse&lt;BouncedEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BouncedEmailDto> getBouncedEmailWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getBouncedEmailValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<BouncedEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a bounced email. (asynchronously)
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param id ID of the bounced email to fetch (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedEmailAsync(UUID id, final ApiCallback<BouncedEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBouncedEmailValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<BouncedEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBouncedEmails
     * @param page Optional page index (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedEmailsCall(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/bounce/emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBouncedEmailsValidateBeforeCall(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBouncedEmailsCall(page, size, sort, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get paginated list of bounced emails.
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param page Optional page index (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageBouncedEmail
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageBouncedEmail getBouncedEmails(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageBouncedEmail> localVarResp = getBouncedEmailsWithHttpInfo(page, size, sort, since, before);
        return localVarResp.getData();
    }

    /**
     * Get paginated list of bounced emails.
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param page Optional page index (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageBouncedEmail&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBouncedEmail> getBouncedEmailsWithHttpInfo(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getBouncedEmailsValidateBeforeCall(page, size, sort, since, before, null);
        Type localVarReturnType = new TypeToken<PageBouncedEmail>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get paginated list of bounced emails. (asynchronously)
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param page Optional page index (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedEmailsAsync(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageBouncedEmail> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBouncedEmailsValidateBeforeCall(page, size, sort, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageBouncedEmail>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBouncedRecipient
     * @param id ID of the bounced recipient (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedRecipientCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/bounce/recipients/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBouncedRecipientValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBouncedRecipient(Async)");
        }
        

        okhttp3.Call localVarCall = getBouncedRecipientCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get a bounced email.
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param id ID of the bounced recipient (required)
     * @return BouncedRecipientDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BouncedRecipientDto getBouncedRecipient(UUID id) throws ApiException {
        ApiResponse<BouncedRecipientDto> localVarResp = getBouncedRecipientWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get a bounced email.
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param id ID of the bounced recipient (required)
     * @return ApiResponse&lt;BouncedRecipientDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BouncedRecipientDto> getBouncedRecipientWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getBouncedRecipientValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<BouncedRecipientDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a bounced email. (asynchronously)
     * Bounced emails are email you have sent that were rejected by a recipient
     * @param id ID of the bounced recipient (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedRecipientAsync(UUID id, final ApiCallback<BouncedRecipientDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBouncedRecipientValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<BouncedRecipientDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBouncedRecipients
     * @param page Optional page index  (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedRecipientsCall(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/bounce/recipients";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBouncedRecipientsValidateBeforeCall(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBouncedRecipientsCall(page, size, sort, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get paginated list of bounced recipients.
     * Bounced recipients are email addresses that you have sent emails to that did not accept the sent email. Once a recipient is bounced you cannot send emails to that address.
     * @param page Optional page index  (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageBouncedRecipients
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageBouncedRecipients getBouncedRecipients(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageBouncedRecipients> localVarResp = getBouncedRecipientsWithHttpInfo(page, size, sort, since, before);
        return localVarResp.getData();
    }

    /**
     * Get paginated list of bounced recipients.
     * Bounced recipients are email addresses that you have sent emails to that did not accept the sent email. Once a recipient is bounced you cannot send emails to that address.
     * @param page Optional page index  (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageBouncedRecipients&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBouncedRecipients> getBouncedRecipientsWithHttpInfo(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getBouncedRecipientsValidateBeforeCall(page, size, sort, since, before, null);
        Type localVarReturnType = new TypeToken<PageBouncedRecipients>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get paginated list of bounced recipients. (asynchronously)
     * Bounced recipients are email addresses that you have sent emails to that did not accept the sent email. Once a recipient is bounced you cannot send emails to that address.
     * @param page Optional page index  (optional, default to 0)
     * @param size Optional page size  (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBouncedRecipientsAsync(Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageBouncedRecipients> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBouncedRecipientsValidateBeforeCall(page, size, sort, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageBouncedRecipients>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
