/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.InboxDto;
import java.time.OffsetDateTime;
import com.mailslurp.models.SimpleSendEmailOptions;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonActionsControllerApi {
    private ApiClient localVarApiClient;

    public CommonActionsControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CommonActionsControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createNewEmailAddress
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createNewEmailAddressCall(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/newEmailAddress";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }

        if (useDomainPool != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }

        if (expiresAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }

        if (expiresIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }

        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        if (inboxType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxType", inboxType));
        }

        if (description != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("description", description));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (tags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tags", tags));
        }

        if (favourite != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("favourite", favourite));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createNewEmailAddressValidateBeforeCall(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createNewEmailAddressCall(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite, _callback);
        return localVarCall;

    }

    /**
     * Create new random inbox
     * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto createNewEmailAddress(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite) throws ApiException {
        ApiResponse<InboxDto> localVarResp = createNewEmailAddressWithHttpInfo(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite);
        return localVarResp.getData();
    }

    /**
     * Create new random inbox
     * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> createNewEmailAddressWithHttpInfo(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite) throws ApiException {
        okhttp3.Call localVarCall = createNewEmailAddressValidateBeforeCall(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create new random inbox (asynchronously)
     * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createNewEmailAddressAsync(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createNewEmailAddressValidateBeforeCall(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createRandomInbox
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createRandomInboxCall(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/createInbox";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }

        if (useDomainPool != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }

        if (expiresAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }

        if (expiresIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }

        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        if (inboxType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxType", inboxType));
        }

        if (description != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("description", description));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (tags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tags", tags));
        }

        if (favourite != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("favourite", favourite));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createRandomInboxValidateBeforeCall(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createRandomInboxCall(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite, _callback);
        return localVarCall;

    }

    /**
     * Create new random inbox
     * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto createRandomInbox(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite) throws ApiException {
        ApiResponse<InboxDto> localVarResp = createRandomInboxWithHttpInfo(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite);
        return localVarResp.getData();
    }

    /**
     * Create new random inbox
     * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> createRandomInboxWithHttpInfo(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite) throws ApiException {
        okhttp3.Call localVarCall = createRandomInboxValidateBeforeCall(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create new random inbox (asynchronously)
     * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
     * @param allowTeamAccess  (optional)
     * @param useDomainPool  (optional)
     * @param expiresAt  (optional)
     * @param expiresIn  (optional)
     * @param emailAddress  (optional)
     * @param inboxType  (optional)
     * @param description  (optional)
     * @param name  (optional)
     * @param tags  (optional)
     * @param favourite  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createRandomInboxAsync(Boolean allowTeamAccess, Boolean useDomainPool, OffsetDateTime expiresAt, Long expiresIn, String emailAddress, String inboxType, String description, String name, List<String> tags, Boolean favourite, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createRandomInboxValidateBeforeCall(allowTeamAccess, useDomainPool, expiresAt, expiresIn, emailAddress, inboxType, description, name, tags, favourite, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteEmailAddress
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEmailAddressCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/deleteEmailAddress";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteEmailAddressValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling deleteEmailAddress(Async)");
        }
        

        okhttp3.Call localVarCall = deleteEmailAddressCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Delete inbox email address by inbox id
     * Deletes inbox email address
     * @param inboxId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteEmailAddress(UUID inboxId) throws ApiException {
        deleteEmailAddressWithHttpInfo(inboxId);
    }

    /**
     * Delete inbox email address by inbox id
     * Deletes inbox email address
     * @param inboxId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteEmailAddressWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = deleteEmailAddressValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete inbox email address by inbox id (asynchronously)
     * Deletes inbox email address
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEmailAddressAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteEmailAddressValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for emptyInbox
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call emptyInboxCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emptyInbox";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call emptyInboxValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling emptyInbox(Async)");
        }
        

        okhttp3.Call localVarCall = emptyInboxCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Delete all emails in an inbox
     * Deletes all emails
     * @param inboxId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void emptyInbox(UUID inboxId) throws ApiException {
        emptyInboxWithHttpInfo(inboxId);
    }

    /**
     * Delete all emails in an inbox
     * Deletes all emails
     * @param inboxId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> emptyInboxWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = emptyInboxValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all emails in an inbox (asynchronously)
     * Deletes all emails
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call emptyInboxAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = emptyInboxValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEmailSimple
     * @param simpleSendEmailOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailSimpleCall(SimpleSendEmailOptions simpleSendEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = simpleSendEmailOptions;

        // create path and map variables
        String localVarPath = "/sendEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEmailSimpleValidateBeforeCall(SimpleSendEmailOptions simpleSendEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'simpleSendEmailOptions' is set
        if (simpleSendEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'simpleSendEmailOptions' when calling sendEmailSimple(Async)");
        }
        

        okhttp3.Call localVarCall = sendEmailSimpleCall(simpleSendEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Send an email
     * If no senderId or inboxId provided a random email address will be used to send from.
     * @param simpleSendEmailOptions  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public void sendEmailSimple(SimpleSendEmailOptions simpleSendEmailOptions) throws ApiException {
        sendEmailSimpleWithHttpInfo(simpleSendEmailOptions);
    }

    /**
     * Send an email
     * If no senderId or inboxId provided a random email address will be used to send from.
     * @param simpleSendEmailOptions  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> sendEmailSimpleWithHttpInfo(SimpleSendEmailOptions simpleSendEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = sendEmailSimpleValidateBeforeCall(simpleSendEmailOptions, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Send an email (asynchronously)
     * If no senderId or inboxId provided a random email address will be used to send from.
     * @param simpleSendEmailOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailSimpleAsync(SimpleSendEmailOptions simpleSendEmailOptions, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEmailSimpleValidateBeforeCall(simpleSendEmailOptions, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
