/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.AttachmentMetaData;
import com.mailslurp.models.ContentMatchOptions;
import com.mailslurp.models.CountDto;
import com.mailslurp.models.DownloadAttachmentDto;
import com.mailslurp.models.Email;
import com.mailslurp.models.EmailContentMatchResult;
import com.mailslurp.models.EmailLinksResult;
import com.mailslurp.models.EmailPreview;
import com.mailslurp.models.EmailPreviewUrls;
import com.mailslurp.models.EmailTextLinesResult;
import com.mailslurp.models.ForwardEmailOptions;
import com.mailslurp.models.GravatarUrl;
import com.mailslurp.models.ImapFlagOperationOptions;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageEmailProjection;
import com.mailslurp.models.RawEmailJson;
import com.mailslurp.models.ReplyToEmailOptions;
import com.mailslurp.models.SendEmailOptions;
import com.mailslurp.models.SentEmailDto;
import java.util.UUID;
import com.mailslurp.models.UnreadCount;
import com.mailslurp.models.ValidationDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailControllerApi {
    private ApiClient localVarApiClient;

    public EmailControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for applyImapFlagOperation
     * @param emailId  (required)
     * @param imapFlagOperationOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applyImapFlagOperationCall(UUID emailId, ImapFlagOperationOptions imapFlagOperationOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = imapFlagOperationOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/imap-flag-operation"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applyImapFlagOperationValidateBeforeCall(UUID emailId, ImapFlagOperationOptions imapFlagOperationOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling applyImapFlagOperation(Async)");
        }
        
        // verify the required parameter 'imapFlagOperationOptions' is set
        if (imapFlagOperationOptions == null) {
            throw new ApiException("Missing the required parameter 'imapFlagOperationOptions' when calling applyImapFlagOperation(Async)");
        }
        

        okhttp3.Call localVarCall = applyImapFlagOperationCall(emailId, imapFlagOperationOptions, _callback);
        return localVarCall;

    }

    /**
     * Set IMAP flags associated with a message. Only supports &#39;\\Seen&#39; flag.
     * Apply RFC3501 section-2.3.2 IMAP flag operations on an email
     * @param emailId  (required)
     * @param imapFlagOperationOptions  (required)
     * @return EmailPreview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailPreview applyImapFlagOperation(UUID emailId, ImapFlagOperationOptions imapFlagOperationOptions) throws ApiException {
        ApiResponse<EmailPreview> localVarResp = applyImapFlagOperationWithHttpInfo(emailId, imapFlagOperationOptions);
        return localVarResp.getData();
    }

    /**
     * Set IMAP flags associated with a message. Only supports &#39;\\Seen&#39; flag.
     * Apply RFC3501 section-2.3.2 IMAP flag operations on an email
     * @param emailId  (required)
     * @param imapFlagOperationOptions  (required)
     * @return ApiResponse&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailPreview> applyImapFlagOperationWithHttpInfo(UUID emailId, ImapFlagOperationOptions imapFlagOperationOptions) throws ApiException {
        okhttp3.Call localVarCall = applyImapFlagOperationValidateBeforeCall(emailId, imapFlagOperationOptions, null);
        Type localVarReturnType = new TypeToken<EmailPreview>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set IMAP flags associated with a message. Only supports &#39;\\Seen&#39; flag. (asynchronously)
     * Apply RFC3501 section-2.3.2 IMAP flag operations on an email
     * @param emailId  (required)
     * @param imapFlagOperationOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applyImapFlagOperationAsync(UUID emailId, ImapFlagOperationOptions imapFlagOperationOptions, final ApiCallback<EmailPreview> _callback) throws ApiException {

        okhttp3.Call localVarCall = applyImapFlagOperationValidateBeforeCall(emailId, imapFlagOperationOptions, _callback);
        Type localVarReturnType = new TypeToken<EmailPreview>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAllEmails
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllEmailsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllEmailsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAllEmailsCall(_callback);
        return localVarCall;

    }

    /**
     * Delete all emails in all inboxes.
     * Deletes all emails in your account. Be careful as emails cannot be recovered
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAllEmails() throws ApiException {
        deleteAllEmailsWithHttpInfo();
    }

    /**
     * Delete all emails in all inboxes.
     * Deletes all emails in your account. Be careful as emails cannot be recovered
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAllEmailsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllEmailsValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all emails in all inboxes. (asynchronously)
     * Deletes all emails in your account. Be careful as emails cannot be recovered
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllEmailsAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllEmailsValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteEmail
     * @param emailId ID of email to delete (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEmailCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteEmailValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling deleteEmail(Async)");
        }
        

        okhttp3.Call localVarCall = deleteEmailCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Delete an email
     * Deletes an email and removes it from the inbox. Deleted emails cannot be recovered.
     * @param emailId ID of email to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteEmail(UUID emailId) throws ApiException {
        deleteEmailWithHttpInfo(emailId);
    }

    /**
     * Delete an email
     * Deletes an email and removes it from the inbox. Deleted emails cannot be recovered.
     * @param emailId ID of email to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteEmailWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = deleteEmailValidateBeforeCall(emailId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an email (asynchronously)
     * Deletes an email and removes it from the inbox. Deleted emails cannot be recovered.
     * @param emailId ID of email to delete (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEmailAsync(UUID emailId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteEmailValidateBeforeCall(emailId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadAttachment
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentCall(UUID emailId, String attachmentId, String apiKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()))
            .replaceAll("\\{" + "attachmentId" + "\\}", localVarApiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("apiKey", apiKey));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadAttachmentValidateBeforeCall(UUID emailId, String attachmentId, String apiKey, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadAttachment(Async)");
        }
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling downloadAttachment(Async)");
        }
        

        okhttp3.Call localVarCall = downloadAttachmentCall(emailId, attachmentId, apiKey, _callback);
        return localVarCall;

    }

    /**
     * Get email attachment bytes. Returned as &#x60;octet-stream&#x60; with content type header. If you have trouble with byte responses try the &#x60;downloadAttachmentBase64&#x60; response endpoints and convert the base 64 encoded content to a file or string.
     * Returns the specified attachment for a given email as a stream / array of bytes. You can find attachment ids in email responses endpoint responses. The response type is application/octet-stream.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public byte[] downloadAttachment(UUID emailId, String attachmentId, String apiKey) throws ApiException {
        ApiResponse<byte[]> localVarResp = downloadAttachmentWithHttpInfo(emailId, attachmentId, apiKey);
        return localVarResp.getData();
    }

    /**
     * Get email attachment bytes. Returned as &#x60;octet-stream&#x60; with content type header. If you have trouble with byte responses try the &#x60;downloadAttachmentBase64&#x60; response endpoints and convert the base 64 encoded content to a file or string.
     * Returns the specified attachment for a given email as a stream / array of bytes. You can find attachment ids in email responses endpoint responses. The response type is application/octet-stream.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @return ApiResponse&lt;byte[]&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<byte[]> downloadAttachmentWithHttpInfo(UUID emailId, String attachmentId, String apiKey) throws ApiException {
        okhttp3.Call localVarCall = downloadAttachmentValidateBeforeCall(emailId, attachmentId, apiKey, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email attachment bytes. Returned as &#x60;octet-stream&#x60; with content type header. If you have trouble with byte responses try the &#x60;downloadAttachmentBase64&#x60; response endpoints and convert the base 64 encoded content to a file or string. (asynchronously)
     * Returns the specified attachment for a given email as a stream / array of bytes. You can find attachment ids in email responses endpoint responses. The response type is application/octet-stream.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentAsync(UUID emailId, String attachmentId, String apiKey, final ApiCallback<byte[]> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadAttachmentValidateBeforeCall(emailId, attachmentId, apiKey, _callback);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadAttachmentBase64
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentBase64Call(UUID emailId, String attachmentId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}/base64"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()))
            .replaceAll("\\{" + "attachmentId" + "\\}", localVarApiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadAttachmentBase64ValidateBeforeCall(UUID emailId, String attachmentId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadAttachmentBase64(Async)");
        }
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling downloadAttachmentBase64(Async)");
        }
        

        okhttp3.Call localVarCall = downloadAttachmentBase64Call(emailId, attachmentId, _callback);
        return localVarCall;

    }

    /**
     * Get email attachment as base64 encoded string as an alternative to binary responses. Decode the &#x60;base64FileContents&#x60; as a &#x60;utf-8&#x60; encoded string or array of bytes depending on the &#x60;contentType&#x60;.
     * Returns the specified attachment for a given email as a base 64 encoded string. The response type is application/json. This method is similar to the &#x60;downloadAttachment&#x60; method but allows some clients to get around issues with binary responses.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @return DownloadAttachmentDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public DownloadAttachmentDto downloadAttachmentBase64(UUID emailId, String attachmentId) throws ApiException {
        ApiResponse<DownloadAttachmentDto> localVarResp = downloadAttachmentBase64WithHttpInfo(emailId, attachmentId);
        return localVarResp.getData();
    }

    /**
     * Get email attachment as base64 encoded string as an alternative to binary responses. Decode the &#x60;base64FileContents&#x60; as a &#x60;utf-8&#x60; encoded string or array of bytes depending on the &#x60;contentType&#x60;.
     * Returns the specified attachment for a given email as a base 64 encoded string. The response type is application/json. This method is similar to the &#x60;downloadAttachment&#x60; method but allows some clients to get around issues with binary responses.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @return ApiResponse&lt;DownloadAttachmentDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DownloadAttachmentDto> downloadAttachmentBase64WithHttpInfo(UUID emailId, String attachmentId) throws ApiException {
        okhttp3.Call localVarCall = downloadAttachmentBase64ValidateBeforeCall(emailId, attachmentId, null);
        Type localVarReturnType = new TypeToken<DownloadAttachmentDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email attachment as base64 encoded string as an alternative to binary responses. Decode the &#x60;base64FileContents&#x60; as a &#x60;utf-8&#x60; encoded string or array of bytes depending on the &#x60;contentType&#x60;. (asynchronously)
     * Returns the specified attachment for a given email as a base 64 encoded string. The response type is application/json. This method is similar to the &#x60;downloadAttachment&#x60; method but allows some clients to get around issues with binary responses.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentBase64Async(UUID emailId, String attachmentId, final ApiCallback<DownloadAttachmentDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadAttachmentBase64ValidateBeforeCall(emailId, attachmentId, _callback);
        Type localVarReturnType = new TypeToken<DownloadAttachmentDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadBody
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadBodyCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/body"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadBodyValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadBody(Async)");
        }
        

        okhttp3.Call localVarCall = downloadBodyCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get email body as string. Returned as &#x60;plain/text&#x60; with content type header.
     * Returns the specified email body for a given email as a string
     * @param emailId ID of email (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public String downloadBody(UUID emailId) throws ApiException {
        ApiResponse<String> localVarResp = downloadBodyWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get email body as string. Returned as &#x60;plain/text&#x60; with content type header.
     * Returns the specified email body for a given email as a string
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> downloadBodyWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = downloadBodyValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email body as string. Returned as &#x60;plain/text&#x60; with content type header. (asynchronously)
     * Returns the specified email body for a given email as a string
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadBodyAsync(UUID emailId, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadBodyValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadBodyBytes
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadBodyBytesCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/body-bytes"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadBodyBytesValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadBodyBytes(Async)");
        }
        

        okhttp3.Call localVarCall = downloadBodyBytesCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get email body in bytes. Returned as &#x60;octet-stream&#x60; with content type header.
     * Returns the specified email body for a given email as a stream / array of bytes.
     * @param emailId ID of email (required)
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public byte[] downloadBodyBytes(UUID emailId) throws ApiException {
        ApiResponse<byte[]> localVarResp = downloadBodyBytesWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get email body in bytes. Returned as &#x60;octet-stream&#x60; with content type header.
     * Returns the specified email body for a given email as a stream / array of bytes.
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;byte[]&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<byte[]> downloadBodyBytesWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = downloadBodyBytesValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email body in bytes. Returned as &#x60;octet-stream&#x60; with content type header. (asynchronously)
     * Returns the specified email body for a given email as a stream / array of bytes.
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadBodyBytesAsync(UUID emailId, final ApiCallback<byte[]> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadBodyBytesValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for forwardEmail
     * @param emailId ID of email (required)
     * @param forwardEmailOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call forwardEmailCall(UUID emailId, ForwardEmailOptions forwardEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = forwardEmailOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/forward"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call forwardEmailValidateBeforeCall(UUID emailId, ForwardEmailOptions forwardEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling forwardEmail(Async)");
        }
        
        // verify the required parameter 'forwardEmailOptions' is set
        if (forwardEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'forwardEmailOptions' when calling forwardEmail(Async)");
        }
        

        okhttp3.Call localVarCall = forwardEmailCall(emailId, forwardEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Forward email to recipients
     * Forward an existing email to new recipients. The sender of the email will be the inbox that received the email you are forwarding. You can override the sender with the &#x60;from&#x60; option. Note you must have access to the from address in MailSlurp to use the override. For more control consider fetching the email and sending it a new using the send email endpoints.
     * @param emailId ID of email (required)
     * @param forwardEmailOptions  (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto forwardEmail(UUID emailId, ForwardEmailOptions forwardEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = forwardEmailWithHttpInfo(emailId, forwardEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Forward email to recipients
     * Forward an existing email to new recipients. The sender of the email will be the inbox that received the email you are forwarding. You can override the sender with the &#x60;from&#x60; option. Note you must have access to the from address in MailSlurp to use the override. For more control consider fetching the email and sending it a new using the send email endpoints.
     * @param emailId ID of email (required)
     * @param forwardEmailOptions  (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> forwardEmailWithHttpInfo(UUID emailId, ForwardEmailOptions forwardEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = forwardEmailValidateBeforeCall(emailId, forwardEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Forward email to recipients (asynchronously)
     * Forward an existing email to new recipients. The sender of the email will be the inbox that received the email you are forwarding. You can override the sender with the &#x60;from&#x60; option. Note you must have access to the from address in MailSlurp to use the override. For more control consider fetching the email and sending it a new using the send email endpoints.
     * @param emailId ID of email (required)
     * @param forwardEmailOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call forwardEmailAsync(UUID emailId, ForwardEmailOptions forwardEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = forwardEmailValidateBeforeCall(emailId, forwardEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAttachmentMetaData
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAttachmentMetaDataCall(UUID emailId, String attachmentId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}/metadata"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()))
            .replaceAll("\\{" + "attachmentId" + "\\}", localVarApiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAttachmentMetaDataValidateBeforeCall(UUID emailId, String attachmentId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getAttachmentMetaData(Async)");
        }
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling getAttachmentMetaData(Async)");
        }
        

        okhttp3.Call localVarCall = getAttachmentMetaDataCall(emailId, attachmentId, _callback);
        return localVarCall;

    }

    /**
     * Get email attachment metadata. This is the &#x60;contentType&#x60; and &#x60;contentLength&#x60; of an attachment. To get the individual attachments  use the &#x60;downloadAttachment&#x60; methods.
     * Returns the metadata such as name and content-type for a given attachment and email.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @return AttachmentMetaData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AttachmentMetaData getAttachmentMetaData(UUID emailId, String attachmentId) throws ApiException {
        ApiResponse<AttachmentMetaData> localVarResp = getAttachmentMetaDataWithHttpInfo(emailId, attachmentId);
        return localVarResp.getData();
    }

    /**
     * Get email attachment metadata. This is the &#x60;contentType&#x60; and &#x60;contentLength&#x60; of an attachment. To get the individual attachments  use the &#x60;downloadAttachment&#x60; methods.
     * Returns the metadata such as name and content-type for a given attachment and email.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @return ApiResponse&lt;AttachmentMetaData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AttachmentMetaData> getAttachmentMetaDataWithHttpInfo(UUID emailId, String attachmentId) throws ApiException {
        okhttp3.Call localVarCall = getAttachmentMetaDataValidateBeforeCall(emailId, attachmentId, null);
        Type localVarReturnType = new TypeToken<AttachmentMetaData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email attachment metadata. This is the &#x60;contentType&#x60; and &#x60;contentLength&#x60; of an attachment. To get the individual attachments  use the &#x60;downloadAttachment&#x60; methods. (asynchronously)
     * Returns the metadata such as name and content-type for a given attachment and email.
     * @param emailId ID of email (required)
     * @param attachmentId ID of attachment (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAttachmentMetaDataAsync(UUID emailId, String attachmentId, final ApiCallback<AttachmentMetaData> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAttachmentMetaDataValidateBeforeCall(emailId, attachmentId, _callback);
        Type localVarReturnType = new TypeToken<AttachmentMetaData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmail
     * @param emailId  (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decode", decode));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailValidateBeforeCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmail(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailCall(emailId, decode, _callback);
        return localVarCall;

    }

    /**
     * Get email content including headers and body. Expects email to exist by ID. For emails that may not have arrived yet use the WaitForController.
     * Returns a email summary object with headers and content. To retrieve the raw unparsed email use the getRawEmail endpoints
     * @param emailId  (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email getEmail(UUID emailId, Boolean decode) throws ApiException {
        ApiResponse<Email> localVarResp = getEmailWithHttpInfo(emailId, decode);
        return localVarResp.getData();
    }

    /**
     * Get email content including headers and body. Expects email to exist by ID. For emails that may not have arrived yet use the WaitForController.
     * Returns a email summary object with headers and content. To retrieve the raw unparsed email use the getRawEmail endpoints
     * @param emailId  (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getEmailWithHttpInfo(UUID emailId, Boolean decode) throws ApiException {
        okhttp3.Call localVarCall = getEmailValidateBeforeCall(emailId, decode, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email content including headers and body. Expects email to exist by ID. For emails that may not have arrived yet use the WaitForController. (asynchronously)
     * Returns a email summary object with headers and content. To retrieve the raw unparsed email use the getRawEmail endpoints
     * @param emailId  (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailAsync(UUID emailId, Boolean decode, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailValidateBeforeCall(emailId, decode, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailAttachments
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailAttachmentsCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailAttachmentsValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailAttachments(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailAttachmentsCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get all email attachment metadata. Metadata includes name and size of attachments.
     * Returns an array of attachment metadata such as name and content-type for a given email if present.
     * @param emailId ID of email (required)
     * @return List&lt;AttachmentMetaData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<AttachmentMetaData> getEmailAttachments(UUID emailId) throws ApiException {
        ApiResponse<List<AttachmentMetaData>> localVarResp = getEmailAttachmentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get all email attachment metadata. Metadata includes name and size of attachments.
     * Returns an array of attachment metadata such as name and content-type for a given email if present.
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;List&lt;AttachmentMetaData&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<AttachmentMetaData>> getEmailAttachmentsWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getEmailAttachmentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<List<AttachmentMetaData>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all email attachment metadata. Metadata includes name and size of attachments. (asynchronously)
     * Returns an array of attachment metadata such as name and content-type for a given email if present.
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailAttachmentsAsync(UUID emailId, final ApiCallback<List<AttachmentMetaData>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailAttachmentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<List<AttachmentMetaData>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailContentMatch
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailContentMatchCall(UUID emailId, ContentMatchOptions contentMatchOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = contentMatchOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/contentMatch"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailContentMatchValidateBeforeCall(UUID emailId, ContentMatchOptions contentMatchOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailContentMatch(Async)");
        }
        
        // verify the required parameter 'contentMatchOptions' is set
        if (contentMatchOptions == null) {
            throw new ApiException("Missing the required parameter 'contentMatchOptions' when calling getEmailContentMatch(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailContentMatchCall(emailId, contentMatchOptions, _callback);
        return localVarCall;

    }

    /**
     * Get email content regex pattern match results. Runs regex against email body and returns match groups.
     * Return the matches for a given Java style regex pattern. Do not include the typical &#x60;/&#x60; at start or end of regex in some languages. Given an example &#x60;your code is: 12345&#x60; the pattern to extract match looks like &#x60;code is: (\\d{6})&#x60;. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: &#x60;[&#39;code is: 123456&#39;, &#39;123456&#39;]&#x60; See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns. 
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions  (required)
     * @return EmailContentMatchResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailContentMatchResult getEmailContentMatch(UUID emailId, ContentMatchOptions contentMatchOptions) throws ApiException {
        ApiResponse<EmailContentMatchResult> localVarResp = getEmailContentMatchWithHttpInfo(emailId, contentMatchOptions);
        return localVarResp.getData();
    }

    /**
     * Get email content regex pattern match results. Runs regex against email body and returns match groups.
     * Return the matches for a given Java style regex pattern. Do not include the typical &#x60;/&#x60; at start or end of regex in some languages. Given an example &#x60;your code is: 12345&#x60; the pattern to extract match looks like &#x60;code is: (\\d{6})&#x60;. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: &#x60;[&#39;code is: 123456&#39;, &#39;123456&#39;]&#x60; See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns. 
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions  (required)
     * @return ApiResponse&lt;EmailContentMatchResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailContentMatchResult> getEmailContentMatchWithHttpInfo(UUID emailId, ContentMatchOptions contentMatchOptions) throws ApiException {
        okhttp3.Call localVarCall = getEmailContentMatchValidateBeforeCall(emailId, contentMatchOptions, null);
        Type localVarReturnType = new TypeToken<EmailContentMatchResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email content regex pattern match results. Runs regex against email body and returns match groups. (asynchronously)
     * Return the matches for a given Java style regex pattern. Do not include the typical &#x60;/&#x60; at start or end of regex in some languages. Given an example &#x60;your code is: 12345&#x60; the pattern to extract match looks like &#x60;code is: (\\d{6})&#x60;. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: &#x60;[&#39;code is: 123456&#39;, &#39;123456&#39;]&#x60; See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns. 
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailContentMatchAsync(UUID emailId, ContentMatchOptions contentMatchOptions, final ApiCallback<EmailContentMatchResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailContentMatchValidateBeforeCall(emailId, contentMatchOptions, _callback);
        Type localVarReturnType = new TypeToken<EmailContentMatchResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailCount
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailCountCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/emails/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailCountValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getEmailCountCall(_callback);
        return localVarCall;

    }

    /**
     * Get email count
     * 
     * @return CountDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CountDto getEmailCount() throws ApiException {
        ApiResponse<CountDto> localVarResp = getEmailCountWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get email count
     * 
     * @return ApiResponse&lt;CountDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountDto> getEmailCountWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getEmailCountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CountDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email count (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailCountAsync(final ApiCallback<CountDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailCountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CountDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailHTML
     * @param emailId  (required)
     * @param decode  (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/html"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decode", decode));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailHTMLValidateBeforeCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailHTML(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailHTMLCall(emailId, decode, _callback);
        return localVarCall;

    }

    /**
     * Get email content as HTML. For displaying emails in browser context.
     * Retrieve email content as HTML response for viewing in browsers. Decodes quoted-printable entities and converts charset to UTF-8. Pass your API KEY as a request parameter when viewing in a browser: &#x60;?apiKey&#x3D;xxx&#x60;
     * @param emailId  (required)
     * @param decode  (optional, default to false)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public String getEmailHTML(UUID emailId, Boolean decode) throws ApiException {
        ApiResponse<String> localVarResp = getEmailHTMLWithHttpInfo(emailId, decode);
        return localVarResp.getData();
    }

    /**
     * Get email content as HTML. For displaying emails in browser context.
     * Retrieve email content as HTML response for viewing in browsers. Decodes quoted-printable entities and converts charset to UTF-8. Pass your API KEY as a request parameter when viewing in a browser: &#x60;?apiKey&#x3D;xxx&#x60;
     * @param emailId  (required)
     * @param decode  (optional, default to false)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getEmailHTMLWithHttpInfo(UUID emailId, Boolean decode) throws ApiException {
        okhttp3.Call localVarCall = getEmailHTMLValidateBeforeCall(emailId, decode, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email content as HTML. For displaying emails in browser context. (asynchronously)
     * Retrieve email content as HTML response for viewing in browsers. Decodes quoted-printable entities and converts charset to UTF-8. Pass your API KEY as a request parameter when viewing in a browser: &#x60;?apiKey&#x3D;xxx&#x60;
     * @param emailId  (required)
     * @param decode  (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLAsync(UUID emailId, Boolean decode, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailHTMLValidateBeforeCall(emailId, decode, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailHTMLQuery
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLQueryCall(UUID emailId, String htmlSelector, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/htmlQuery"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (htmlSelector != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("htmlSelector", htmlSelector));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailHTMLQueryValidateBeforeCall(UUID emailId, String htmlSelector, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailHTMLQuery(Async)");
        }
        
        // verify the required parameter 'htmlSelector' is set
        if (htmlSelector == null) {
            throw new ApiException("Missing the required parameter 'htmlSelector' when calling getEmailHTMLQuery(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailHTMLQueryCall(emailId, htmlSelector, _callback);
        return localVarCall;

    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of text. HTML parsing uses JSoup which supports JQuery/CSS style selectors
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (required)
     * @return EmailTextLinesResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailTextLinesResult getEmailHTMLQuery(UUID emailId, String htmlSelector) throws ApiException {
        ApiResponse<EmailTextLinesResult> localVarResp = getEmailHTMLQueryWithHttpInfo(emailId, htmlSelector);
        return localVarResp.getData();
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of text. HTML parsing uses JSoup which supports JQuery/CSS style selectors
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (required)
     * @return ApiResponse&lt;EmailTextLinesResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailTextLinesResult> getEmailHTMLQueryWithHttpInfo(UUID emailId, String htmlSelector) throws ApiException {
        okhttp3.Call localVarCall = getEmailHTMLQueryValidateBeforeCall(emailId, htmlSelector, null);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters (asynchronously)
     * Parse an email body and return the content as an array of text. HTML parsing uses JSoup which supports JQuery/CSS style selectors
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLQueryAsync(UUID emailId, String htmlSelector, final ApiCallback<EmailTextLinesResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailHTMLQueryValidateBeforeCall(emailId, htmlSelector, _callback);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailLinks
     * @param emailId ID of email to fetch text for (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailLinksCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/links"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailLinksValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailLinks(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailLinksCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Parse and return list of links found in an email (only works for HTML content)
     * HTML parsing uses JSoup and UNIX line separators. Searches content for href attributes
     * @param emailId ID of email to fetch text for (required)
     * @return EmailLinksResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailLinksResult getEmailLinks(UUID emailId) throws ApiException {
        ApiResponse<EmailLinksResult> localVarResp = getEmailLinksWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Parse and return list of links found in an email (only works for HTML content)
     * HTML parsing uses JSoup and UNIX line separators. Searches content for href attributes
     * @param emailId ID of email to fetch text for (required)
     * @return ApiResponse&lt;EmailLinksResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailLinksResult> getEmailLinksWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getEmailLinksValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<EmailLinksResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse and return list of links found in an email (only works for HTML content) (asynchronously)
     * HTML parsing uses JSoup and UNIX line separators. Searches content for href attributes
     * @param emailId ID of email to fetch text for (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailLinksAsync(UUID emailId, final ApiCallback<EmailLinksResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailLinksValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<EmailLinksResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailPreviewURLs
     * @param emailId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailPreviewURLsCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/urls"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailPreviewURLsValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailPreviewURLs(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailPreviewURLsCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get email URLs for viewing in browser or downloading
     * Get a list of URLs for email content as text/html or raw SMTP message for viewing the message in a browser.
     * @param emailId  (required)
     * @return EmailPreviewUrls
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailPreviewUrls getEmailPreviewURLs(UUID emailId) throws ApiException {
        ApiResponse<EmailPreviewUrls> localVarResp = getEmailPreviewURLsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get email URLs for viewing in browser or downloading
     * Get a list of URLs for email content as text/html or raw SMTP message for viewing the message in a browser.
     * @param emailId  (required)
     * @return ApiResponse&lt;EmailPreviewUrls&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailPreviewUrls> getEmailPreviewURLsWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getEmailPreviewURLsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<EmailPreviewUrls>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email URLs for viewing in browser or downloading (asynchronously)
     * Get a list of URLs for email content as text/html or raw SMTP message for viewing the message in a browser.
     * @param emailId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailPreviewURLsAsync(UUID emailId, final ApiCallback<EmailPreviewUrls> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailPreviewURLsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<EmailPreviewUrls>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailTextLines
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailTextLinesCall(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/textLines"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decodeHtmlEntities != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decodeHtmlEntities", decodeHtmlEntities));
        }

        if (lineSeparator != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("lineSeparator", lineSeparator));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailTextLinesValidateBeforeCall(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailTextLines(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailTextLinesCall(emailId, decodeHtmlEntities, lineSeparator, _callback);
        return localVarCall;

    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of strings. HTML parsing uses JSoup and UNIX line separators.
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @return EmailTextLinesResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailTextLinesResult getEmailTextLines(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator) throws ApiException {
        ApiResponse<EmailTextLinesResult> localVarResp = getEmailTextLinesWithHttpInfo(emailId, decodeHtmlEntities, lineSeparator);
        return localVarResp.getData();
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of strings. HTML parsing uses JSoup and UNIX line separators.
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @return ApiResponse&lt;EmailTextLinesResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailTextLinesResult> getEmailTextLinesWithHttpInfo(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator) throws ApiException {
        okhttp3.Call localVarCall = getEmailTextLinesValidateBeforeCall(emailId, decodeHtmlEntities, lineSeparator, null);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters (asynchronously)
     * Parse an email body and return the content as an array of strings. HTML parsing uses JSoup and UNIX line separators.
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailTextLinesAsync(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, final ApiCallback<EmailTextLinesResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailTextLinesValidateBeforeCall(emailId, decodeHtmlEntities, lineSeparator, _callback);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailsPaginated
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter. Searches email recipients, sender, subject, email address and ID. Does not search email body (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsPaginatedCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailsPaginatedValidateBeforeCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getEmailsPaginatedCall(inboxId, page, size, sort, unreadOnly, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get all emails in all inboxes in paginated form. Email API list all.
     * By default returns all emails across all inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter. Searches email recipients, sender, subject, email address and ID. Does not search email body (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @return PageEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailProjection getEmailsPaginated(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = getEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, unreadOnly, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * Get all emails in all inboxes in paginated form. Email API list all.
     * By default returns all emails across all inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter. Searches email recipients, sender, subject, email address and ID. Does not search email body (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @return ApiResponse&lt;PageEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailProjection> getEmailsPaginatedWithHttpInfo(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all emails in all inboxes in paginated form. Email API list all. (asynchronously)
     * By default returns all emails across all inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter. Searches email recipients, sender, subject, email address and ID. Does not search email body (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsPaginatedAsync(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGravatarUrlForEmailAddress
     * @param emailAddress  (required)
     * @param size  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGravatarUrlForEmailAddressCall(String emailAddress, String size, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/gravatarFor";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGravatarUrlForEmailAddressValidateBeforeCall(String emailAddress, String size, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailAddress' is set
        if (emailAddress == null) {
            throw new ApiException("Missing the required parameter 'emailAddress' when calling getGravatarUrlForEmailAddress(Async)");
        }
        

        okhttp3.Call localVarCall = getGravatarUrlForEmailAddressCall(emailAddress, size, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get gravatar url for email address
     * @param emailAddress  (required)
     * @param size  (optional)
     * @return GravatarUrl
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GravatarUrl getGravatarUrlForEmailAddress(String emailAddress, String size) throws ApiException {
        ApiResponse<GravatarUrl> localVarResp = getGravatarUrlForEmailAddressWithHttpInfo(emailAddress, size);
        return localVarResp.getData();
    }

    /**
     * 
     * Get gravatar url for email address
     * @param emailAddress  (required)
     * @param size  (optional)
     * @return ApiResponse&lt;GravatarUrl&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GravatarUrl> getGravatarUrlForEmailAddressWithHttpInfo(String emailAddress, String size) throws ApiException {
        okhttp3.Call localVarCall = getGravatarUrlForEmailAddressValidateBeforeCall(emailAddress, size, null);
        Type localVarReturnType = new TypeToken<GravatarUrl>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get gravatar url for email address
     * @param emailAddress  (required)
     * @param size  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGravatarUrlForEmailAddressAsync(String emailAddress, String size, final ApiCallback<GravatarUrl> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGravatarUrlForEmailAddressValidateBeforeCall(emailAddress, size, _callback);
        Type localVarReturnType = new TypeToken<GravatarUrl>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLatestEmail
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs. If not provided will search across all inboxes (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailCall(List<UUID> inboxIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxIds != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "inboxIds", inboxIds));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLatestEmailValidateBeforeCall(List<UUID> inboxIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getLatestEmailCall(inboxIds, _callback);
        return localVarCall;

    }

    /**
     * Get latest email in all inboxes. Most recently received.
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs. If not provided will search across all inboxes (optional)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email getLatestEmail(List<UUID> inboxIds) throws ApiException {
        ApiResponse<Email> localVarResp = getLatestEmailWithHttpInfo(inboxIds);
        return localVarResp.getData();
    }

    /**
     * Get latest email in all inboxes. Most recently received.
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs. If not provided will search across all inboxes (optional)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getLatestEmailWithHttpInfo(List<UUID> inboxIds) throws ApiException {
        okhttp3.Call localVarCall = getLatestEmailValidateBeforeCall(inboxIds, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get latest email in all inboxes. Most recently received. (asynchronously)
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs. If not provided will search across all inboxes (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailAsync(List<UUID> inboxIds, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLatestEmailValidateBeforeCall(inboxIds, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLatestEmailInInbox1
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailInInbox1Call(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/latestIn";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLatestEmailInInbox1ValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getLatestEmailInInbox1(Async)");
        }
        

        okhttp3.Call localVarCall = getLatestEmailInInbox1Call(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get latest email in an inbox. Use &#x60;WaitForController&#x60; to get emails that may not have arrived yet.
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email getLatestEmailInInbox1(UUID inboxId) throws ApiException {
        ApiResponse<Email> localVarResp = getLatestEmailInInbox1WithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get latest email in an inbox. Use &#x60;WaitForController&#x60; to get emails that may not have arrived yet.
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getLatestEmailInInbox1WithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getLatestEmailInInbox1ValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get latest email in an inbox. Use &#x60;WaitForController&#x60; to get emails that may not have arrived yet. (asynchronously)
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailInInbox1Async(UUID inboxId, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLatestEmailInInbox1ValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOrganizationEmailsPaginated
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter search filter for emails. (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationEmailsPaginatedCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/organization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOrganizationEmailsPaginatedValidateBeforeCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getOrganizationEmailsPaginatedCall(inboxId, page, size, sort, unreadOnly, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get all organization emails. List team or shared test email accounts
     * By default returns all emails across all team inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter search filter for emails. (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @return PageEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailProjection getOrganizationEmailsPaginated(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = getOrganizationEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, unreadOnly, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * Get all organization emails. List team or shared test email accounts
     * By default returns all emails across all team inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter search filter for emails. (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @return ApiResponse&lt;PageEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailProjection> getOrganizationEmailsPaginatedWithHttpInfo(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getOrganizationEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all organization emails. List team or shared test email accounts (asynchronously)
     * By default returns all emails across all team inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param searchFilter Optional search filter search filter for emails. (optional)
     * @param since Optional filter emails received after given date time (optional)
     * @param before Optional filter emails received before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationEmailsPaginatedAsync(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOrganizationEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRawEmailContents
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailContentsCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/raw"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRawEmailContentsValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawEmailContents(Async)");
        }
        

        okhttp3.Call localVarCall = getRawEmailContentsCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get raw email string. Returns unparsed raw SMTP message with headers and body.
     * Returns a raw, unparsed, and unprocessed email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawEmailJson endpoint
     * @param emailId ID of email (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public String getRawEmailContents(UUID emailId) throws ApiException {
        ApiResponse<String> localVarResp = getRawEmailContentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get raw email string. Returns unparsed raw SMTP message with headers and body.
     * Returns a raw, unparsed, and unprocessed email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawEmailJson endpoint
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getRawEmailContentsWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getRawEmailContentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get raw email string. Returns unparsed raw SMTP message with headers and body. (asynchronously)
     * Returns a raw, unparsed, and unprocessed email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawEmailJson endpoint
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailContentsAsync(UUID emailId, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRawEmailContentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRawEmailJson
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailJsonCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/raw/json"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRawEmailJsonValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawEmailJson(Async)");
        }
        

        okhttp3.Call localVarCall = getRawEmailJsonCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get raw email in JSON. Unparsed SMTP message in JSON wrapper format.
     * Returns a raw, unparsed, and unprocessed email wrapped in a JSON response object for easier handling when compared with the getRawEmail text/plain response
     * @param emailId ID of email (required)
     * @return RawEmailJson
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public RawEmailJson getRawEmailJson(UUID emailId) throws ApiException {
        ApiResponse<RawEmailJson> localVarResp = getRawEmailJsonWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get raw email in JSON. Unparsed SMTP message in JSON wrapper format.
     * Returns a raw, unparsed, and unprocessed email wrapped in a JSON response object for easier handling when compared with the getRawEmail text/plain response
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;RawEmailJson&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RawEmailJson> getRawEmailJsonWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getRawEmailJsonValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get raw email in JSON. Unparsed SMTP message in JSON wrapper format. (asynchronously)
     * Returns a raw, unparsed, and unprocessed email wrapped in a JSON response object for easier handling when compared with the getRawEmail text/plain response
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailJsonAsync(UUID emailId, final ApiCallback<RawEmailJson> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRawEmailJsonValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getUnreadEmailCount
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUnreadEmailCountCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/unreadCount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUnreadEmailCountValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getUnreadEmailCountCall(_callback);
        return localVarCall;

    }

    /**
     * Get unread email count
     * Get number of emails unread. Unread means has not been viewed in dashboard or returned in an email API response
     * @return UnreadCount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UnreadCount getUnreadEmailCount() throws ApiException {
        ApiResponse<UnreadCount> localVarResp = getUnreadEmailCountWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get unread email count
     * Get number of emails unread. Unread means has not been viewed in dashboard or returned in an email API response
     * @return ApiResponse&lt;UnreadCount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UnreadCount> getUnreadEmailCountWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getUnreadEmailCountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UnreadCount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get unread email count (asynchronously)
     * Get number of emails unread. Unread means has not been viewed in dashboard or returned in an email API response
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUnreadEmailCountAsync(final ApiCallback<UnreadCount> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUnreadEmailCountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UnreadCount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for markAsRead
     * @param emailId  (required)
     * @param read What value to assign to email read property. Default true. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call markAsReadCall(UUID emailId, Boolean read, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/read"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (read != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("read", read));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call markAsReadValidateBeforeCall(UUID emailId, Boolean read, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling markAsRead(Async)");
        }
        

        okhttp3.Call localVarCall = markAsReadCall(emailId, read, _callback);
        return localVarCall;

    }

    /**
     * Mark an email as read on unread
     * Marks an email as read or unread. Pass boolean read flag to set value. This is useful if you want to read an email but keep it as unread
     * @param emailId  (required)
     * @param read What value to assign to email read property. Default true. (optional, default to true)
     * @return EmailPreview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailPreview markAsRead(UUID emailId, Boolean read) throws ApiException {
        ApiResponse<EmailPreview> localVarResp = markAsReadWithHttpInfo(emailId, read);
        return localVarResp.getData();
    }

    /**
     * Mark an email as read on unread
     * Marks an email as read or unread. Pass boolean read flag to set value. This is useful if you want to read an email but keep it as unread
     * @param emailId  (required)
     * @param read What value to assign to email read property. Default true. (optional, default to true)
     * @return ApiResponse&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailPreview> markAsReadWithHttpInfo(UUID emailId, Boolean read) throws ApiException {
        okhttp3.Call localVarCall = markAsReadValidateBeforeCall(emailId, read, null);
        Type localVarReturnType = new TypeToken<EmailPreview>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Mark an email as read on unread (asynchronously)
     * Marks an email as read or unread. Pass boolean read flag to set value. This is useful if you want to read an email but keep it as unread
     * @param emailId  (required)
     * @param read What value to assign to email read property. Default true. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call markAsReadAsync(UUID emailId, Boolean read, final ApiCallback<EmailPreview> _callback) throws ApiException {

        okhttp3.Call localVarCall = markAsReadValidateBeforeCall(emailId, read, _callback);
        Type localVarReturnType = new TypeToken<EmailPreview>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for replyToEmail
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call replyToEmailCall(UUID emailId, ReplyToEmailOptions replyToEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = replyToEmailOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call replyToEmailValidateBeforeCall(UUID emailId, ReplyToEmailOptions replyToEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling replyToEmail(Async)");
        }
        
        // verify the required parameter 'replyToEmailOptions' is set
        if (replyToEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'replyToEmailOptions' when calling replyToEmail(Async)");
        }
        

        okhttp3.Call localVarCall = replyToEmailCall(emailId, replyToEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Reply to an email
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions  (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto replyToEmail(UUID emailId, ReplyToEmailOptions replyToEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = replyToEmailWithHttpInfo(emailId, replyToEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Reply to an email
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions  (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> replyToEmailWithHttpInfo(UUID emailId, ReplyToEmailOptions replyToEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = replyToEmailValidateBeforeCall(emailId, replyToEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Reply to an email (asynchronously)
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call replyToEmailAsync(UUID emailId, ReplyToEmailOptions replyToEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = replyToEmailValidateBeforeCall(emailId, replyToEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEmailSourceOptional
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param useDomainPool Use domain pool. Optionally create inbox to send from using the mailslurp domain pool. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailSourceOptionalCall(UUID inboxId, SendEmailOptions sendEmailOptions, Boolean useDomainPool, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendEmailOptions;

        // create path and map variables
        String localVarPath = "/emails"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (useDomainPool != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEmailSourceOptionalValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, Boolean useDomainPool, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmailSourceOptional(Async)");
        }
        
        // verify the required parameter 'sendEmailOptions' is set
        if (sendEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'sendEmailOptions' when calling sendEmailSourceOptional(Async)");
        }
        

        okhttp3.Call localVarCall = sendEmailSourceOptionalCall(inboxId, sendEmailOptions, useDomainPool, _callback);
        return localVarCall;

    }

    /**
     * Send email
     * Alias for &#x60;InboxController.sendEmail&#x60; method - see original method for full details. Sends an email from a given inbox that you have created. If no inbox is supplied a random inbox will be created for you and used to send the email.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param useDomainPool Use domain pool. Optionally create inbox to send from using the mailslurp domain pool. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public void sendEmailSourceOptional(UUID inboxId, SendEmailOptions sendEmailOptions, Boolean useDomainPool) throws ApiException {
        sendEmailSourceOptionalWithHttpInfo(inboxId, sendEmailOptions, useDomainPool);
    }

    /**
     * Send email
     * Alias for &#x60;InboxController.sendEmail&#x60; method - see original method for full details. Sends an email from a given inbox that you have created. If no inbox is supplied a random inbox will be created for you and used to send the email.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param useDomainPool Use domain pool. Optionally create inbox to send from using the mailslurp domain pool. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> sendEmailSourceOptionalWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions, Boolean useDomainPool) throws ApiException {
        okhttp3.Call localVarCall = sendEmailSourceOptionalValidateBeforeCall(inboxId, sendEmailOptions, useDomainPool, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Send email (asynchronously)
     * Alias for &#x60;InboxController.sendEmail&#x60; method - see original method for full details. Sends an email from a given inbox that you have created. If no inbox is supplied a random inbox will be created for you and used to send the email.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param useDomainPool Use domain pool. Optionally create inbox to send from using the mailslurp domain pool. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailSourceOptionalAsync(UUID inboxId, SendEmailOptions sendEmailOptions, Boolean useDomainPool, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEmailSourceOptionalValidateBeforeCall(inboxId, sendEmailOptions, useDomainPool, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for validateEmail
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateEmailCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/validate"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call validateEmailValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling validateEmail(Async)");
        }
        

        okhttp3.Call localVarCall = validateEmailCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Validate email HTML contents
     * Validate the HTML content of email if HTML is found. Considered valid if no HTML is present.
     * @param emailId ID of email (required)
     * @return ValidationDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ValidationDto validateEmail(UUID emailId) throws ApiException {
        ApiResponse<ValidationDto> localVarResp = validateEmailWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Validate email HTML contents
     * Validate the HTML content of email if HTML is found. Considered valid if no HTML is present.
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;ValidationDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ValidationDto> validateEmailWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = validateEmailValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<ValidationDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Validate email HTML contents (asynchronously)
     * Validate the HTML content of email if HTML is found. Considered valid if no HTML is present.
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateEmailAsync(UUID emailId, final ApiCallback<ValidationDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = validateEmailValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<ValidationDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
