/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.time.OffsetDateTime;
import com.mailslurp.models.PageEmailValidationRequest;
import com.mailslurp.models.ValidateEmailAddressListOptions;
import com.mailslurp.models.ValidateEmailAddressListResult;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailVerificationControllerApi {
    private ApiClient localVarApiClient;

    public EmailVerificationControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailVerificationControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getValidationRequests
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param isValid Filter where email is valid is true or false (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getValidationRequestsCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean isValid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/email-verification/validation-requests";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (isValid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("isValid", isValid));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getValidationRequestsValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean isValid, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getValidationRequestsCall(page, size, sort, searchFilter, since, before, isValid, _callback);
        return localVarCall;

    }

    /**
     * Validate a list of email addresses. Per unit billing. See your plan for pricing.
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param isValid Filter where email is valid is true or false (optional)
     * @return PageEmailValidationRequest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailValidationRequest getValidationRequests(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean isValid) throws ApiException {
        ApiResponse<PageEmailValidationRequest> localVarResp = getValidationRequestsWithHttpInfo(page, size, sort, searchFilter, since, before, isValid);
        return localVarResp.getData();
    }

    /**
     * Validate a list of email addresses. Per unit billing. See your plan for pricing.
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param isValid Filter where email is valid is true or false (optional)
     * @return ApiResponse&lt;PageEmailValidationRequest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailValidationRequest> getValidationRequestsWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean isValid) throws ApiException {
        okhttp3.Call localVarCall = getValidationRequestsValidateBeforeCall(page, size, sort, searchFilter, since, before, isValid, null);
        Type localVarReturnType = new TypeToken<PageEmailValidationRequest>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Validate a list of email addresses. Per unit billing. See your plan for pricing. (asynchronously)
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param isValid Filter where email is valid is true or false (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getValidationRequestsAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean isValid, final ApiCallback<PageEmailValidationRequest> _callback) throws ApiException {

        okhttp3.Call localVarCall = getValidationRequestsValidateBeforeCall(page, size, sort, searchFilter, since, before, isValid, _callback);
        Type localVarReturnType = new TypeToken<PageEmailValidationRequest>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for validateEmailAddressList
     * @param validateEmailAddressListOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateEmailAddressListCall(ValidateEmailAddressListOptions validateEmailAddressListOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = validateEmailAddressListOptions;

        // create path and map variables
        String localVarPath = "/email-verification/email-address-list";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call validateEmailAddressListValidateBeforeCall(ValidateEmailAddressListOptions validateEmailAddressListOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'validateEmailAddressListOptions' is set
        if (validateEmailAddressListOptions == null) {
            throw new ApiException("Missing the required parameter 'validateEmailAddressListOptions' when calling validateEmailAddressList(Async)");
        }
        

        okhttp3.Call localVarCall = validateEmailAddressListCall(validateEmailAddressListOptions, _callback);
        return localVarCall;

    }

    /**
     * Validate a list of email addresses. Per unit billing. See your plan for pricing.
     * 
     * @param validateEmailAddressListOptions  (required)
     * @return ValidateEmailAddressListResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ValidateEmailAddressListResult validateEmailAddressList(ValidateEmailAddressListOptions validateEmailAddressListOptions) throws ApiException {
        ApiResponse<ValidateEmailAddressListResult> localVarResp = validateEmailAddressListWithHttpInfo(validateEmailAddressListOptions);
        return localVarResp.getData();
    }

    /**
     * Validate a list of email addresses. Per unit billing. See your plan for pricing.
     * 
     * @param validateEmailAddressListOptions  (required)
     * @return ApiResponse&lt;ValidateEmailAddressListResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ValidateEmailAddressListResult> validateEmailAddressListWithHttpInfo(ValidateEmailAddressListOptions validateEmailAddressListOptions) throws ApiException {
        okhttp3.Call localVarCall = validateEmailAddressListValidateBeforeCall(validateEmailAddressListOptions, null);
        Type localVarReturnType = new TypeToken<ValidateEmailAddressListResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Validate a list of email addresses. Per unit billing. See your plan for pricing. (asynchronously)
     * 
     * @param validateEmailAddressListOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateEmailAddressListAsync(ValidateEmailAddressListOptions validateEmailAddressListOptions, final ApiCallback<ValidateEmailAddressListResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = validateEmailAddressListValidateBeforeCall(validateEmailAddressListOptions, _callback);
        Type localVarReturnType = new TypeToken<ValidateEmailAddressListResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
