/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.CountDto;
import com.mailslurp.models.CreateInboxDto;
import com.mailslurp.models.CreateInboxRulesetOptions;
import com.mailslurp.models.Email;
import com.mailslurp.models.EmailPreview;
import com.mailslurp.models.FlushExpiredInboxesResult;
import com.mailslurp.models.ImapSmtpAccessDetails;
import com.mailslurp.models.InboxByEmailAddressResult;
import com.mailslurp.models.InboxDto;
import com.mailslurp.models.InboxExistsDto;
import com.mailslurp.models.InboxIdsResult;
import com.mailslurp.models.InboxRulesetDto;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageEmailPreview;
import com.mailslurp.models.PageInboxProjection;
import com.mailslurp.models.PageInboxRulesetDto;
import com.mailslurp.models.PageOrganizationInboxProjection;
import com.mailslurp.models.PageSentEmailProjection;
import com.mailslurp.models.PageTrackingPixelProjection;
import com.mailslurp.models.SendEmailOptions;
import com.mailslurp.models.SendSMTPEnvelopeOptions;
import com.mailslurp.models.SentEmailDto;
import com.mailslurp.models.SetInboxFavouritedOptions;
import java.util.UUID;
import com.mailslurp.models.UpdateInboxOptions;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxControllerApi {
    private ApiClient localVarApiClient;

    public InboxControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboxControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createInbox
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types. (optional)
     * @param favourite Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param allowTeamAccess DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param inboxType HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxCall(String emailAddress, List<String> tags, String name, String description, Boolean useDomainPool, Boolean favourite, OffsetDateTime expiresAt, Long expiresIn, Boolean allowTeamAccess, String inboxType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        if (tags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tags", tags));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (description != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("description", description));
        }

        if (useDomainPool != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }

        if (favourite != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("favourite", favourite));
        }

        if (expiresAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }

        if (expiresIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }

        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }

        if (inboxType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxType", inboxType));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createInboxValidateBeforeCall(String emailAddress, List<String> tags, String name, String description, Boolean useDomainPool, Boolean favourite, OffsetDateTime expiresAt, Long expiresIn, Boolean allowTeamAccess, String inboxType, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createInboxCall(emailAddress, tags, name, description, useDomainPool, favourite, expiresAt, expiresIn, allowTeamAccess, inboxType, _callback);
        return localVarCall;

    }

    /**
     * Create an inbox email address. An inbox has a real email address and can send and receive emails. Inboxes can be either &#x60;SMTP&#x60; or &#x60;HTTP&#x60; inboxes.
     * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types. (optional)
     * @param favourite Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param allowTeamAccess DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param inboxType HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;. (optional)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto createInbox(String emailAddress, List<String> tags, String name, String description, Boolean useDomainPool, Boolean favourite, OffsetDateTime expiresAt, Long expiresIn, Boolean allowTeamAccess, String inboxType) throws ApiException {
        ApiResponse<InboxDto> localVarResp = createInboxWithHttpInfo(emailAddress, tags, name, description, useDomainPool, favourite, expiresAt, expiresIn, allowTeamAccess, inboxType);
        return localVarResp.getData();
    }

    /**
     * Create an inbox email address. An inbox has a real email address and can send and receive emails. Inboxes can be either &#x60;SMTP&#x60; or &#x60;HTTP&#x60; inboxes.
     * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types. (optional)
     * @param favourite Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param allowTeamAccess DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param inboxType HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;. (optional)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> createInboxWithHttpInfo(String emailAddress, List<String> tags, String name, String description, Boolean useDomainPool, Boolean favourite, OffsetDateTime expiresAt, Long expiresIn, Boolean allowTeamAccess, String inboxType) throws ApiException {
        okhttp3.Call localVarCall = createInboxValidateBeforeCall(emailAddress, tags, name, description, useDomainPool, favourite, expiresAt, expiresIn, allowTeamAccess, inboxType, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox email address. An inbox has a real email address and can send and receive emails. Inboxes can be either &#x60;SMTP&#x60; or &#x60;HTTP&#x60; inboxes. (asynchronously)
     * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types. (optional)
     * @param favourite Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param allowTeamAccess DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param inboxType HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxAsync(String emailAddress, List<String> tags, String name, String description, Boolean useDomainPool, Boolean favourite, OffsetDateTime expiresAt, Long expiresIn, Boolean allowTeamAccess, String inboxType, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createInboxValidateBeforeCall(emailAddress, tags, name, description, useDomainPool, favourite, expiresAt, expiresIn, allowTeamAccess, inboxType, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createInboxRuleset
     * @param inboxId inboxId (required)
     * @param createInboxRulesetOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxRulesetCall(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createInboxRulesetOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/rulesets"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createInboxRulesetValidateBeforeCall(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling createInboxRuleset(Async)");
        }
        
        // verify the required parameter 'createInboxRulesetOptions' is set
        if (createInboxRulesetOptions == null) {
            throw new ApiException("Missing the required parameter 'createInboxRulesetOptions' when calling createInboxRuleset(Async)");
        }
        

        okhttp3.Call localVarCall = createInboxRulesetCall(inboxId, createInboxRulesetOptions, _callback);
        return localVarCall;

    }

    /**
     * Create an inbox ruleset
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId inboxId (required)
     * @param createInboxRulesetOptions  (required)
     * @return InboxRulesetDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxRulesetDto createInboxRuleset(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions) throws ApiException {
        ApiResponse<InboxRulesetDto> localVarResp = createInboxRulesetWithHttpInfo(inboxId, createInboxRulesetOptions);
        return localVarResp.getData();
    }

    /**
     * Create an inbox ruleset
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId inboxId (required)
     * @param createInboxRulesetOptions  (required)
     * @return ApiResponse&lt;InboxRulesetDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxRulesetDto> createInboxRulesetWithHttpInfo(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions) throws ApiException {
        okhttp3.Call localVarCall = createInboxRulesetValidateBeforeCall(inboxId, createInboxRulesetOptions, null);
        Type localVarReturnType = new TypeToken<InboxRulesetDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox ruleset (asynchronously)
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId inboxId (required)
     * @param createInboxRulesetOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxRulesetAsync(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions, final ApiCallback<InboxRulesetDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createInboxRulesetValidateBeforeCall(inboxId, createInboxRulesetOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxRulesetDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createInboxWithDefaults
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxWithDefaultsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/withDefaults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createInboxWithDefaultsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createInboxWithDefaultsCall(_callback);
        return localVarCall;

    }

    /**
     * Create an inbox with default options. Uses MailSlurp domain pool address and is private.
     * 
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto createInboxWithDefaults() throws ApiException {
        ApiResponse<InboxDto> localVarResp = createInboxWithDefaultsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Create an inbox with default options. Uses MailSlurp domain pool address and is private.
     * 
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> createInboxWithDefaultsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = createInboxWithDefaultsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox with default options. Uses MailSlurp domain pool address and is private. (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxWithDefaultsAsync(final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createInboxWithDefaultsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createInboxWithOptions
     * @param createInboxDto  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxWithOptionsCall(CreateInboxDto createInboxDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createInboxDto;

        // create path and map variables
        String localVarPath = "/inboxes/withOptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createInboxWithOptionsValidateBeforeCall(CreateInboxDto createInboxDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'createInboxDto' is set
        if (createInboxDto == null) {
            throw new ApiException("Missing the required parameter 'createInboxDto' when calling createInboxWithOptions(Async)");
        }
        

        okhttp3.Call localVarCall = createInboxWithOptionsCall(createInboxDto, _callback);
        return localVarCall;

    }

    /**
     * Create an inbox with options. Extended options for inbox creation.
     * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
     * @param createInboxDto  (required)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto createInboxWithOptions(CreateInboxDto createInboxDto) throws ApiException {
        ApiResponse<InboxDto> localVarResp = createInboxWithOptionsWithHttpInfo(createInboxDto);
        return localVarResp.getData();
    }

    /**
     * Create an inbox with options. Extended options for inbox creation.
     * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
     * @param createInboxDto  (required)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> createInboxWithOptionsWithHttpInfo(CreateInboxDto createInboxDto) throws ApiException {
        okhttp3.Call localVarCall = createInboxWithOptionsValidateBeforeCall(createInboxDto, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox with options. Extended options for inbox creation. (asynchronously)
     * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
     * @param createInboxDto  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxWithOptionsAsync(CreateInboxDto createInboxDto, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createInboxWithOptionsValidateBeforeCall(createInboxDto, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAllInboxes
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllInboxesCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllInboxesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAllInboxesCall(_callback);
        return localVarCall;

    }

    /**
     * Delete all inboxes
     * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAllInboxes() throws ApiException {
        deleteAllInboxesWithHttpInfo();
    }

    /**
     * Delete all inboxes
     * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAllInboxesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllInboxesValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all inboxes (asynchronously)
     * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllInboxesAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllInboxesValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInbox
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInboxValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling deleteInbox(Async)");
        }
        

        okhttp3.Call localVarCall = deleteInboxCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Delete inbox
     * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
     * @param inboxId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInbox(UUID inboxId) throws ApiException {
        deleteInboxWithHttpInfo(inboxId);
    }

    /**
     * Delete inbox
     * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
     * @param inboxId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInboxWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = deleteInboxValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete inbox (asynchronously)
     * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInboxValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for doesInboxExist
     * @param emailAddress Email address (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call doesInboxExistCall(String emailAddress, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/exists";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call doesInboxExistValidateBeforeCall(String emailAddress, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailAddress' is set
        if (emailAddress == null) {
            throw new ApiException("Missing the required parameter 'emailAddress' when calling doesInboxExist(Async)");
        }
        

        okhttp3.Call localVarCall = doesInboxExistCall(emailAddress, _callback);
        return localVarCall;

    }

    /**
     * Does inbox exist
     * Check if inboxes exist by email address. Useful if you are sending emails to mailslurp addresses
     * @param emailAddress Email address (required)
     * @return InboxExistsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxExistsDto doesInboxExist(String emailAddress) throws ApiException {
        ApiResponse<InboxExistsDto> localVarResp = doesInboxExistWithHttpInfo(emailAddress);
        return localVarResp.getData();
    }

    /**
     * Does inbox exist
     * Check if inboxes exist by email address. Useful if you are sending emails to mailslurp addresses
     * @param emailAddress Email address (required)
     * @return ApiResponse&lt;InboxExistsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxExistsDto> doesInboxExistWithHttpInfo(String emailAddress) throws ApiException {
        okhttp3.Call localVarCall = doesInboxExistValidateBeforeCall(emailAddress, null);
        Type localVarReturnType = new TypeToken<InboxExistsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Does inbox exist (asynchronously)
     * Check if inboxes exist by email address. Useful if you are sending emails to mailslurp addresses
     * @param emailAddress Email address (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call doesInboxExistAsync(String emailAddress, final ApiCallback<InboxExistsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = doesInboxExistValidateBeforeCall(emailAddress, _callback);
        Type localVarReturnType = new TypeToken<InboxExistsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for flushExpired
     * @param before Optional expired at before flag to flush expired inboxes that have expired before the given time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call flushExpiredCall(OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/expired";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call flushExpiredValidateBeforeCall(OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = flushExpiredCall(before, _callback);
        return localVarCall;

    }

    /**
     * Remove expired inboxes
     * Remove any expired inboxes for your account (instead of waiting for scheduled removal on server)
     * @param before Optional expired at before flag to flush expired inboxes that have expired before the given time (optional)
     * @return FlushExpiredInboxesResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public FlushExpiredInboxesResult flushExpired(OffsetDateTime before) throws ApiException {
        ApiResponse<FlushExpiredInboxesResult> localVarResp = flushExpiredWithHttpInfo(before);
        return localVarResp.getData();
    }

    /**
     * Remove expired inboxes
     * Remove any expired inboxes for your account (instead of waiting for scheduled removal on server)
     * @param before Optional expired at before flag to flush expired inboxes that have expired before the given time (optional)
     * @return ApiResponse&lt;FlushExpiredInboxesResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FlushExpiredInboxesResult> flushExpiredWithHttpInfo(OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = flushExpiredValidateBeforeCall(before, null);
        Type localVarReturnType = new TypeToken<FlushExpiredInboxesResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Remove expired inboxes (asynchronously)
     * Remove any expired inboxes for your account (instead of waiting for scheduled removal on server)
     * @param before Optional expired at before flag to flush expired inboxes that have expired before the given time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call flushExpiredAsync(OffsetDateTime before, final ApiCallback<FlushExpiredInboxesResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = flushExpiredValidateBeforeCall(before, _callback);
        Type localVarReturnType = new TypeToken<FlushExpiredInboxesResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllInboxes
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess DEPRECATED. Optionally filter by team access. (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllInboxesCall(Integer page, Integer size, String sort, Boolean favourite, String search, String tag, Boolean teamAccess, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/paginated";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (favourite != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("favourite", favourite));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (tag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tag", tag));
        }

        if (teamAccess != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("teamAccess", teamAccess));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllInboxesValidateBeforeCall(Integer page, Integer size, String sort, Boolean favourite, String search, String tag, Boolean teamAccess, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllInboxesCall(page, size, sort, favourite, search, tag, teamAccess, since, before, _callback);
        return localVarCall;

    }

    /**
     * List All Inboxes Paginated
     * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess DEPRECATED. Optionally filter by team access. (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return PageInboxProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageInboxProjection getAllInboxes(Integer page, Integer size, String sort, Boolean favourite, String search, String tag, Boolean teamAccess, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageInboxProjection> localVarResp = getAllInboxesWithHttpInfo(page, size, sort, favourite, search, tag, teamAccess, since, before);
        return localVarResp.getData();
    }

    /**
     * List All Inboxes Paginated
     * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess DEPRECATED. Optionally filter by team access. (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return ApiResponse&lt;PageInboxProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageInboxProjection> getAllInboxesWithHttpInfo(Integer page, Integer size, String sort, Boolean favourite, String search, String tag, Boolean teamAccess, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getAllInboxesValidateBeforeCall(page, size, sort, favourite, search, tag, teamAccess, since, before, null);
        Type localVarReturnType = new TypeToken<PageInboxProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List All Inboxes Paginated (asynchronously)
     * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess DEPRECATED. Optionally filter by team access. (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllInboxesAsync(Integer page, Integer size, String sort, Boolean favourite, String search, String tag, Boolean teamAccess, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageInboxProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllInboxesValidateBeforeCall(page, size, sort, favourite, search, tag, teamAccess, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageInboxProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmails
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param delayTimeout  (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param unreadOnly  (optional)
     * @param before Exclude emails received after this ISO 8601 date time (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsCall(UUID inboxId, Integer size, Integer limit, String sort, Long retryTimeout, Long delayTimeout, Long minCount, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/emails"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (retryTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("retryTimeout", retryTimeout));
        }

        if (delayTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delayTimeout", delayTimeout));
        }

        if (minCount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("minCount", minCount));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailsValidateBeforeCall(UUID inboxId, Integer size, Integer limit, String sort, Long retryTimeout, Long delayTimeout, Long minCount, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getEmails(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailsCall(inboxId, size, limit, sort, retryTimeout, delayTimeout, minCount, unreadOnly, before, since, _callback);
        return localVarCall;

    }

    /**
     * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.
     * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param delayTimeout  (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param unreadOnly  (optional)
     * @param before Exclude emails received after this ISO 8601 date time (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> getEmails(UUID inboxId, Integer size, Integer limit, String sort, Long retryTimeout, Long delayTimeout, Long minCount, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = getEmailsWithHttpInfo(inboxId, size, limit, sort, retryTimeout, delayTimeout, minCount, unreadOnly, before, since);
        return localVarResp.getData();
    }

    /**
     * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.
     * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param delayTimeout  (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param unreadOnly  (optional)
     * @param before Exclude emails received after this ISO 8601 date time (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> getEmailsWithHttpInfo(UUID inboxId, Integer size, Integer limit, String sort, Long retryTimeout, Long delayTimeout, Long minCount, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since) throws ApiException {
        okhttp3.Call localVarCall = getEmailsValidateBeforeCall(inboxId, size, limit, sort, retryTimeout, delayTimeout, minCount, unreadOnly, before, since, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead. (asynchronously)
     * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param delayTimeout  (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param unreadOnly  (optional)
     * @param before Exclude emails received after this ISO 8601 date time (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsAsync(UUID inboxId, Integer size, Integer limit, String sort, Long retryTimeout, Long delayTimeout, Long minCount, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailsValidateBeforeCall(inboxId, size, limit, sort, retryTimeout, delayTimeout, minCount, unreadOnly, before, since, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getImapSmtpAccess
     * @param inboxId Inbox ID (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getImapSmtpAccessCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/imap-smtp-access";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getImapSmtpAccessValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getImapSmtpAccessCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get IMAP and SMTP access usernames and passwords
     * @param inboxId Inbox ID (optional)
     * @return ImapSmtpAccessDetails
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ImapSmtpAccessDetails getImapSmtpAccess(UUID inboxId) throws ApiException {
        ApiResponse<ImapSmtpAccessDetails> localVarResp = getImapSmtpAccessWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * 
     * Get IMAP and SMTP access usernames and passwords
     * @param inboxId Inbox ID (optional)
     * @return ApiResponse&lt;ImapSmtpAccessDetails&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ImapSmtpAccessDetails> getImapSmtpAccessWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getImapSmtpAccessValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<ImapSmtpAccessDetails>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get IMAP and SMTP access usernames and passwords
     * @param inboxId Inbox ID (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getImapSmtpAccessAsync(UUID inboxId, final ApiCallback<ImapSmtpAccessDetails> _callback) throws ApiException {

        okhttp3.Call localVarCall = getImapSmtpAccessValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<ImapSmtpAccessDetails>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInbox
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInbox(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get Inbox. Returns properties of an inbox.
     * Returns an inbox&#39;s properties, including its email address and ID.
     * @param inboxId  (required)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto getInbox(UUID inboxId) throws ApiException {
        ApiResponse<InboxDto> localVarResp = getInboxWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get Inbox. Returns properties of an inbox.
     * Returns an inbox&#39;s properties, including its email address and ID.
     * @param inboxId  (required)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> getInboxWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getInboxValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Inbox. Returns properties of an inbox. (asynchronously)
     * Returns an inbox&#39;s properties, including its email address and ID.
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxAsync(UUID inboxId, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxByEmailAddress
     * @param emailAddress  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxByEmailAddressCall(String emailAddress, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/byEmailAddress";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxByEmailAddressValidateBeforeCall(String emailAddress, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailAddress' is set
        if (emailAddress == null) {
            throw new ApiException("Missing the required parameter 'emailAddress' when calling getInboxByEmailAddress(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxByEmailAddressCall(emailAddress, _callback);
        return localVarCall;

    }

    /**
     * Search for an inbox with the provided email address
     * Get a inbox result by email address
     * @param emailAddress  (required)
     * @return InboxByEmailAddressResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxByEmailAddressResult getInboxByEmailAddress(String emailAddress) throws ApiException {
        ApiResponse<InboxByEmailAddressResult> localVarResp = getInboxByEmailAddressWithHttpInfo(emailAddress);
        return localVarResp.getData();
    }

    /**
     * Search for an inbox with the provided email address
     * Get a inbox result by email address
     * @param emailAddress  (required)
     * @return ApiResponse&lt;InboxByEmailAddressResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxByEmailAddressResult> getInboxByEmailAddressWithHttpInfo(String emailAddress) throws ApiException {
        okhttp3.Call localVarCall = getInboxByEmailAddressValidateBeforeCall(emailAddress, null);
        Type localVarReturnType = new TypeToken<InboxByEmailAddressResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Search for an inbox with the provided email address (asynchronously)
     * Get a inbox result by email address
     * @param emailAddress  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxByEmailAddressAsync(String emailAddress, final ApiCallback<InboxByEmailAddressResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxByEmailAddressValidateBeforeCall(emailAddress, _callback);
        Type localVarReturnType = new TypeToken<InboxByEmailAddressResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxCount
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxCountCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxCountValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxCountCall(_callback);
        return localVarCall;

    }

    /**
     * Get total inbox count
     * 
     * @return CountDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CountDto getInboxCount() throws ApiException {
        ApiResponse<CountDto> localVarResp = getInboxCountWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get total inbox count
     * 
     * @return ApiResponse&lt;CountDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountDto> getInboxCountWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getInboxCountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CountDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get total inbox count (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxCountAsync(final ApiCallback<CountDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxCountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CountDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxEmailCount
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxEmailCountCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/emails/count"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxEmailCountValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxEmailCount(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxEmailCountCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get email count in inbox
     * 
     * @param inboxId Id of inbox that emails belongs to (required)
     * @return CountDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CountDto getInboxEmailCount(UUID inboxId) throws ApiException {
        ApiResponse<CountDto> localVarResp = getInboxEmailCountWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get email count in inbox
     * 
     * @param inboxId Id of inbox that emails belongs to (required)
     * @return ApiResponse&lt;CountDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountDto> getInboxEmailCountWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getInboxEmailCountValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<CountDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email count in inbox (asynchronously)
     * 
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxEmailCountAsync(UUID inboxId, final ApiCallback<CountDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxEmailCountValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<CountDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxEmailsPaginated
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by received after given date time (optional)
     * @param before Optional filter by received before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxEmailsPaginatedCall(UUID inboxId, Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/emails/paginated"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxEmailsPaginatedValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxEmailsPaginated(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxEmailsPaginatedCall(inboxId, page, size, sort, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get inbox emails paginated
     * Get a paginated list of emails in an inbox. Does not hold connections open.
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by received after given date time (optional)
     * @param before Optional filter by received before given date time (optional)
     * @return PageEmailPreview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailPreview getInboxEmailsPaginated(UUID inboxId, Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageEmailPreview> localVarResp = getInboxEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, since, before);
        return localVarResp.getData();
    }

    /**
     * Get inbox emails paginated
     * Get a paginated list of emails in an inbox. Does not hold connections open.
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by received after given date time (optional)
     * @param before Optional filter by received before given date time (optional)
     * @return ApiResponse&lt;PageEmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailPreview> getInboxEmailsPaginatedWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getInboxEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, since, before, null);
        Type localVarReturnType = new TypeToken<PageEmailPreview>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get inbox emails paginated (asynchronously)
     * Get a paginated list of emails in an inbox. Does not hold connections open.
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by received after given date time (optional)
     * @param before Optional filter by received before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxEmailsPaginatedAsync(UUID inboxId, Integer page, Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageEmailPreview> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageEmailPreview>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxIds
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxIdsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/ids";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxIdsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxIdsCall(_callback);
        return localVarCall;

    }

    /**
     * Get all inbox IDs
     * Get list of inbox IDs
     * @return InboxIdsResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxIdsResult getInboxIds() throws ApiException {
        ApiResponse<InboxIdsResult> localVarResp = getInboxIdsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get all inbox IDs
     * Get list of inbox IDs
     * @return ApiResponse&lt;InboxIdsResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxIdsResult> getInboxIdsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getInboxIdsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<InboxIdsResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all inbox IDs (asynchronously)
     * Get list of inbox IDs
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxIdsAsync(final ApiCallback<InboxIdsResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxIdsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<InboxIdsResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxSentEmails
     * @param inboxId  (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional sent email search (optional)
     * @param since Optional filter by sent after given date time (optional)
     * @param before Optional filter by sent before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxSentEmailsCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/sent"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxSentEmailsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxSentEmails(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxSentEmailsCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get Inbox Sent Emails
     * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
     * @param inboxId  (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional sent email search (optional)
     * @param since Optional filter by sent after given date time (optional)
     * @param before Optional filter by sent before given date time (optional)
     * @return PageSentEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageSentEmailProjection getInboxSentEmails(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageSentEmailProjection> localVarResp = getInboxSentEmailsWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * Get Inbox Sent Emails
     * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
     * @param inboxId  (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional sent email search (optional)
     * @param since Optional filter by sent after given date time (optional)
     * @param before Optional filter by sent before given date time (optional)
     * @return ApiResponse&lt;PageSentEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageSentEmailProjection> getInboxSentEmailsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getInboxSentEmailsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Inbox Sent Emails (asynchronously)
     * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
     * @param inboxId  (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional sent email search (optional)
     * @param since Optional filter by sent after given date time (optional)
     * @param before Optional filter by sent before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxSentEmailsAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageSentEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxSentEmailsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxTags
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxTagsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/tags";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxTagsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxTagsCall(_callback);
        return localVarCall;

    }

    /**
     * Get inbox tags
     * Get all inbox tags
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<String> getInboxTags() throws ApiException {
        ApiResponse<List<String>> localVarResp = getInboxTagsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get inbox tags
     * Get all inbox tags
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<String>> getInboxTagsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getInboxTagsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get inbox tags (asynchronously)
     * Get all inbox tags
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxTagsAsync(final ApiCallback<List<String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxTagsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxes
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call getInboxesCall(Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxesValidateBeforeCall(Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxesCall(size, sort, since, before, _callback);
        return localVarCall;

    }

    /**
     * List Inboxes and email addresses
     * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended and allows paginated access using a limit and sort parameter.
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return List&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public List<InboxDto> getInboxes(Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<List<InboxDto>> localVarResp = getInboxesWithHttpInfo(size, sort, since, before);
        return localVarResp.getData();
    }

    /**
     * List Inboxes and email addresses
     * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended and allows paginated access using a limit and sort parameter.
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return ApiResponse&lt;List&lt;InboxDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<List<InboxDto>> getInboxesWithHttpInfo(Integer size, String sort, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getInboxesValidateBeforeCall(size, sort, since, before, null);
        Type localVarReturnType = new TypeToken<List<InboxDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Inboxes and email addresses (asynchronously)
     * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended and allows paginated access using a limit and sort parameter.
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call getInboxesAsync(Integer size, String sort, OffsetDateTime since, OffsetDateTime before, final ApiCallback<List<InboxDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxesValidateBeforeCall(size, sort, since, before, _callback);
        Type localVarReturnType = new TypeToken<List<InboxDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLatestEmailInInbox
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @param timeoutMillis Timeout milliseconds to wait for latest email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailInInboxCall(UUID inboxId, Long timeoutMillis, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/getLatestEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeoutMillis != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeoutMillis", timeoutMillis));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLatestEmailInInboxValidateBeforeCall(UUID inboxId, Long timeoutMillis, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getLatestEmailInInbox(Async)");
        }
        
        // verify the required parameter 'timeoutMillis' is set
        if (timeoutMillis == null) {
            throw new ApiException("Missing the required parameter 'timeoutMillis' when calling getLatestEmailInInbox(Async)");
        }
        

        okhttp3.Call localVarCall = getLatestEmailInInboxCall(inboxId, timeoutMillis, _callback);
        return localVarCall;

    }

    /**
     * Get latest email in an inbox. Use &#x60;WaitForController&#x60; to get emails that may not have arrived yet.
     * Get the newest email in an inbox or wait for one to arrive
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @param timeoutMillis Timeout milliseconds to wait for latest email (required)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email getLatestEmailInInbox(UUID inboxId, Long timeoutMillis) throws ApiException {
        ApiResponse<Email> localVarResp = getLatestEmailInInboxWithHttpInfo(inboxId, timeoutMillis);
        return localVarResp.getData();
    }

    /**
     * Get latest email in an inbox. Use &#x60;WaitForController&#x60; to get emails that may not have arrived yet.
     * Get the newest email in an inbox or wait for one to arrive
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @param timeoutMillis Timeout milliseconds to wait for latest email (required)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getLatestEmailInInboxWithHttpInfo(UUID inboxId, Long timeoutMillis) throws ApiException {
        okhttp3.Call localVarCall = getLatestEmailInInboxValidateBeforeCall(inboxId, timeoutMillis, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get latest email in an inbox. Use &#x60;WaitForController&#x60; to get emails that may not have arrived yet. (asynchronously)
     * Get the newest email in an inbox or wait for one to arrive
     * @param inboxId ID of the inbox you want to get the latest email from (required)
     * @param timeoutMillis Timeout milliseconds to wait for latest email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailInInboxAsync(UUID inboxId, Long timeoutMillis, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLatestEmailInInboxValidateBeforeCall(inboxId, timeoutMillis, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOrganizationInboxes
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationInboxesCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/organization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOrganizationInboxesValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getOrganizationInboxesCall(page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * List Organization Inboxes Paginated
     * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return PageOrganizationInboxProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageOrganizationInboxProjection getOrganizationInboxes(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageOrganizationInboxProjection> localVarResp = getOrganizationInboxesWithHttpInfo(page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * List Organization Inboxes Paginated
     * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return ApiResponse&lt;PageOrganizationInboxProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageOrganizationInboxProjection> getOrganizationInboxesWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getOrganizationInboxesValidateBeforeCall(page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageOrganizationInboxProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Organization Inboxes Paginated (asynchronously)
     * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationInboxesAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageOrganizationInboxProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOrganizationInboxesValidateBeforeCall(page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageOrganizationInboxProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInboxRulesets
     * @param inboxId  (required)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInboxRulesetsCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/rulesets"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInboxRulesetsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling listInboxRulesets(Async)");
        }
        

        okhttp3.Call localVarCall = listInboxRulesetsCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * List inbox rulesets
     * List all rulesets attached to an inbox
     * @param inboxId  (required)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return PageInboxRulesetDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageInboxRulesetDto listInboxRulesets(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageInboxRulesetDto> localVarResp = listInboxRulesetsWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * List inbox rulesets
     * List all rulesets attached to an inbox
     * @param inboxId  (required)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return ApiResponse&lt;PageInboxRulesetDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageInboxRulesetDto> listInboxRulesetsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = listInboxRulesetsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageInboxRulesetDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List inbox rulesets (asynchronously)
     * List all rulesets attached to an inbox
     * @param inboxId  (required)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInboxRulesetsAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageInboxRulesetDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInboxRulesetsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageInboxRulesetDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInboxTrackingPixels
     * @param inboxId  (required)
     * @param page Optional page index in inbox tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in inbox tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInboxTrackingPixelsCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/tracking-pixels"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInboxTrackingPixelsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling listInboxTrackingPixels(Async)");
        }
        

        okhttp3.Call localVarCall = listInboxTrackingPixelsCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * List inbox tracking pixels
     * List all tracking pixels sent from an inbox
     * @param inboxId  (required)
     * @param page Optional page index in inbox tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in inbox tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return PageTrackingPixelProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageTrackingPixelProjection listInboxTrackingPixels(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageTrackingPixelProjection> localVarResp = listInboxTrackingPixelsWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * List inbox tracking pixels
     * List all tracking pixels sent from an inbox
     * @param inboxId  (required)
     * @param page Optional page index in inbox tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in inbox tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @return ApiResponse&lt;PageTrackingPixelProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageTrackingPixelProjection> listInboxTrackingPixelsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = listInboxTrackingPixelsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List inbox tracking pixels (asynchronously)
     * List all tracking pixels sent from an inbox
     * @param inboxId  (required)
     * @param page Optional page index in inbox tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in inbox tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Optional filter by created after given date time (optional)
     * @param before Optional filter by created before given date time (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInboxTrackingPixelsAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageTrackingPixelProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInboxTrackingPixelsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEmail
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendEmailOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEmailValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmail(Async)");
        }
        
        // verify the required parameter 'sendEmailOptions' is set
        if (sendEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'sendEmailOptions' when calling sendEmail(Async)");
        }
        

        okhttp3.Call localVarCall = sendEmailCall(inboxId, sendEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Send Email
     * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public void sendEmail(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        sendEmailWithHttpInfo(inboxId, sendEmailOptions);
    }

    /**
     * Send Email
     * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> sendEmailWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = sendEmailValidateBeforeCall(inboxId, sendEmailOptions, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Send Email (asynchronously)
     * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailAsync(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEmailValidateBeforeCall(inboxId, sendEmailOptions, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEmailAndConfirm
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailAndConfirmCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendEmailOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/confirm"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEmailAndConfirmValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmailAndConfirm(Async)");
        }
        
        // verify the required parameter 'sendEmailOptions' is set
        if (sendEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'sendEmailOptions' when calling sendEmailAndConfirm(Async)");
        }
        

        okhttp3.Call localVarCall = sendEmailAndConfirmCall(inboxId, sendEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Send email and return sent confirmation
     * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with a link to the sent object created for it.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto sendEmailAndConfirm(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = sendEmailAndConfirmWithHttpInfo(inboxId, sendEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Send email and return sent confirmation
     * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with a link to the sent object created for it.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> sendEmailAndConfirmWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = sendEmailAndConfirmValidateBeforeCall(inboxId, sendEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Send email and return sent confirmation (asynchronously)
     * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with a link to the sent object created for it.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailAndConfirmAsync(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEmailAndConfirmValidateBeforeCall(inboxId, sendEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendSmtpEnvelope
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendSMTPEnvelopeOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendSmtpEnvelopeCall(UUID inboxId, SendSMTPEnvelopeOptions sendSMTPEnvelopeOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendSMTPEnvelopeOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/smtp-envelope"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendSmtpEnvelopeValidateBeforeCall(UUID inboxId, SendSMTPEnvelopeOptions sendSMTPEnvelopeOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendSmtpEnvelope(Async)");
        }
        
        // verify the required parameter 'sendSMTPEnvelopeOptions' is set
        if (sendSMTPEnvelopeOptions == null) {
            throw new ApiException("Missing the required parameter 'sendSMTPEnvelopeOptions' when calling sendSmtpEnvelope(Async)");
        }
        

        okhttp3.Call localVarCall = sendSmtpEnvelopeCall(inboxId, sendSMTPEnvelopeOptions, _callback);
        return localVarCall;

    }

    /**
     * Send email using an SMTP mail envelope and message body and return sent confirmation
     * Send email using an SMTP envelope containing RCPT TO, MAIL FROM, and a SMTP BODY.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendSMTPEnvelopeOptions  (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto sendSmtpEnvelope(UUID inboxId, SendSMTPEnvelopeOptions sendSMTPEnvelopeOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = sendSmtpEnvelopeWithHttpInfo(inboxId, sendSMTPEnvelopeOptions);
        return localVarResp.getData();
    }

    /**
     * Send email using an SMTP mail envelope and message body and return sent confirmation
     * Send email using an SMTP envelope containing RCPT TO, MAIL FROM, and a SMTP BODY.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendSMTPEnvelopeOptions  (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> sendSmtpEnvelopeWithHttpInfo(UUID inboxId, SendSMTPEnvelopeOptions sendSMTPEnvelopeOptions) throws ApiException {
        okhttp3.Call localVarCall = sendSmtpEnvelopeValidateBeforeCall(inboxId, sendSMTPEnvelopeOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Send email using an SMTP mail envelope and message body and return sent confirmation (asynchronously)
     * Send email using an SMTP envelope containing RCPT TO, MAIL FROM, and a SMTP BODY.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendSMTPEnvelopeOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendSmtpEnvelopeAsync(UUID inboxId, SendSMTPEnvelopeOptions sendSMTPEnvelopeOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendSmtpEnvelopeValidateBeforeCall(inboxId, sendSMTPEnvelopeOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendTestEmail
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendTestEmailCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/send-test-email"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendTestEmailValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendTestEmail(Async)");
        }
        

        okhttp3.Call localVarCall = sendTestEmailCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Send a test email to inbox
     * Send an inbox a test email to test email receiving is working
     * @param inboxId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void sendTestEmail(UUID inboxId) throws ApiException {
        sendTestEmailWithHttpInfo(inboxId);
    }

    /**
     * Send a test email to inbox
     * Send an inbox a test email to test email receiving is working
     * @param inboxId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> sendTestEmailWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = sendTestEmailValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Send a test email to inbox (asynchronously)
     * Send an inbox a test email to test email receiving is working
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendTestEmailAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendTestEmailValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setInboxFavourited
     * @param inboxId  (required)
     * @param setInboxFavouritedOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setInboxFavouritedCall(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setInboxFavouritedOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/favourite"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setInboxFavouritedValidateBeforeCall(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling setInboxFavourited(Async)");
        }
        
        // verify the required parameter 'setInboxFavouritedOptions' is set
        if (setInboxFavouritedOptions == null) {
            throw new ApiException("Missing the required parameter 'setInboxFavouritedOptions' when calling setInboxFavourited(Async)");
        }
        

        okhttp3.Call localVarCall = setInboxFavouritedCall(inboxId, setInboxFavouritedOptions, _callback);
        return localVarCall;

    }

    /**
     * Set inbox favourited state
     * Set and return new favourite state for an inbox
     * @param inboxId  (required)
     * @param setInboxFavouritedOptions  (required)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto setInboxFavourited(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions) throws ApiException {
        ApiResponse<InboxDto> localVarResp = setInboxFavouritedWithHttpInfo(inboxId, setInboxFavouritedOptions);
        return localVarResp.getData();
    }

    /**
     * Set inbox favourited state
     * Set and return new favourite state for an inbox
     * @param inboxId  (required)
     * @param setInboxFavouritedOptions  (required)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> setInboxFavouritedWithHttpInfo(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions) throws ApiException {
        okhttp3.Call localVarCall = setInboxFavouritedValidateBeforeCall(inboxId, setInboxFavouritedOptions, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set inbox favourited state (asynchronously)
     * Set and return new favourite state for an inbox
     * @param inboxId  (required)
     * @param setInboxFavouritedOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setInboxFavouritedAsync(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setInboxFavouritedValidateBeforeCall(inboxId, setInboxFavouritedOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateInbox
     * @param inboxId  (required)
     * @param updateInboxOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateInboxCall(UUID inboxId, UpdateInboxOptions updateInboxOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = updateInboxOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateInboxValidateBeforeCall(UUID inboxId, UpdateInboxOptions updateInboxOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling updateInbox(Async)");
        }
        
        // verify the required parameter 'updateInboxOptions' is set
        if (updateInboxOptions == null) {
            throw new ApiException("Missing the required parameter 'updateInboxOptions' when calling updateInbox(Async)");
        }
        

        okhttp3.Call localVarCall = updateInboxCall(inboxId, updateInboxOptions, _callback);
        return localVarCall;

    }

    /**
     * Update Inbox. Change name and description. Email address is not editable.
     * Update editable fields on an inbox
     * @param inboxId  (required)
     * @param updateInboxOptions  (required)
     * @return InboxDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxDto updateInbox(UUID inboxId, UpdateInboxOptions updateInboxOptions) throws ApiException {
        ApiResponse<InboxDto> localVarResp = updateInboxWithHttpInfo(inboxId, updateInboxOptions);
        return localVarResp.getData();
    }

    /**
     * Update Inbox. Change name and description. Email address is not editable.
     * Update editable fields on an inbox
     * @param inboxId  (required)
     * @param updateInboxOptions  (required)
     * @return ApiResponse&lt;InboxDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxDto> updateInboxWithHttpInfo(UUID inboxId, UpdateInboxOptions updateInboxOptions) throws ApiException {
        okhttp3.Call localVarCall = updateInboxValidateBeforeCall(inboxId, updateInboxOptions, null);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Inbox. Change name and description. Email address is not editable. (asynchronously)
     * Update editable fields on an inbox
     * @param inboxId  (required)
     * @param updateInboxOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateInboxAsync(UUID inboxId, UpdateInboxOptions updateInboxOptions, final ApiCallback<InboxDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateInboxValidateBeforeCall(inboxId, updateInboxOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
