/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.CreateInboxForwarderOptions;
import com.mailslurp.models.InboxForwarderDto;
import com.mailslurp.models.InboxForwarderTestOptions;
import com.mailslurp.models.InboxForwarderTestResult;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageInboxForwarderDto;
import com.mailslurp.models.TestNewInboxForwarderOptions;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxForwarderControllerApi {
    private ApiClient localVarApiClient;

    public InboxForwarderControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboxForwarderControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createNewInboxForwarder
     * @param inboxId Inbox id to attach forwarder to (required)
     * @param createInboxForwarderOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createNewInboxForwarderCall(UUID inboxId, CreateInboxForwarderOptions createInboxForwarderOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createInboxForwarderOptions;

        // create path and map variables
        String localVarPath = "/forwarders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createNewInboxForwarderValidateBeforeCall(UUID inboxId, CreateInboxForwarderOptions createInboxForwarderOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling createNewInboxForwarder(Async)");
        }
        
        // verify the required parameter 'createInboxForwarderOptions' is set
        if (createInboxForwarderOptions == null) {
            throw new ApiException("Missing the required parameter 'createInboxForwarderOptions' when calling createNewInboxForwarder(Async)");
        }
        

        okhttp3.Call localVarCall = createNewInboxForwarderCall(inboxId, createInboxForwarderOptions, _callback);
        return localVarCall;

    }

    /**
     * Create an inbox forwarder
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId Inbox id to attach forwarder to (required)
     * @param createInboxForwarderOptions  (required)
     * @return InboxForwarderDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxForwarderDto createNewInboxForwarder(UUID inboxId, CreateInboxForwarderOptions createInboxForwarderOptions) throws ApiException {
        ApiResponse<InboxForwarderDto> localVarResp = createNewInboxForwarderWithHttpInfo(inboxId, createInboxForwarderOptions);
        return localVarResp.getData();
    }

    /**
     * Create an inbox forwarder
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId Inbox id to attach forwarder to (required)
     * @param createInboxForwarderOptions  (required)
     * @return ApiResponse&lt;InboxForwarderDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxForwarderDto> createNewInboxForwarderWithHttpInfo(UUID inboxId, CreateInboxForwarderOptions createInboxForwarderOptions) throws ApiException {
        okhttp3.Call localVarCall = createNewInboxForwarderValidateBeforeCall(inboxId, createInboxForwarderOptions, null);
        Type localVarReturnType = new TypeToken<InboxForwarderDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox forwarder (asynchronously)
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId Inbox id to attach forwarder to (required)
     * @param createInboxForwarderOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createNewInboxForwarderAsync(UUID inboxId, CreateInboxForwarderOptions createInboxForwarderOptions, final ApiCallback<InboxForwarderDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createNewInboxForwarderValidateBeforeCall(inboxId, createInboxForwarderOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxForwarderDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInboxForwarder
     * @param id ID of inbox forwarder (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxForwarderCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/forwarders/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInboxForwarderValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteInboxForwarder(Async)");
        }
        

        okhttp3.Call localVarCall = deleteInboxForwarderCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete an inbox forwarder
     * Delete inbox forwarder
     * @param id ID of inbox forwarder (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInboxForwarder(UUID id) throws ApiException {
        deleteInboxForwarderWithHttpInfo(id);
    }

    /**
     * Delete an inbox forwarder
     * Delete inbox forwarder
     * @param id ID of inbox forwarder (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInboxForwarderWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = deleteInboxForwarderValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an inbox forwarder (asynchronously)
     * Delete inbox forwarder
     * @param id ID of inbox forwarder (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxForwarderAsync(UUID id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInboxForwarderValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInboxForwarders
     * @param inboxId Optional inbox id to attach forwarder to (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxForwardersCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/forwarders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInboxForwardersValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteInboxForwardersCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Delete inbox forwarders
     * Delete inbox forwarders. Accepts optional inboxId filter.
     * @param inboxId Optional inbox id to attach forwarder to (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInboxForwarders(UUID inboxId) throws ApiException {
        deleteInboxForwardersWithHttpInfo(inboxId);
    }

    /**
     * Delete inbox forwarders
     * Delete inbox forwarders. Accepts optional inboxId filter.
     * @param inboxId Optional inbox id to attach forwarder to (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInboxForwardersWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = deleteInboxForwardersValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete inbox forwarders (asynchronously)
     * Delete inbox forwarders. Accepts optional inboxId filter.
     * @param inboxId Optional inbox id to attach forwarder to (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxForwardersAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInboxForwardersValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxForwarder
     * @param id ID of inbox forwarder (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxForwarderCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/forwarders/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxForwarderValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getInboxForwarder(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxForwarderCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get an inbox forwarder
     * Get inbox ruleset
     * @param id ID of inbox forwarder (required)
     * @return InboxForwarderDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxForwarderDto getInboxForwarder(UUID id) throws ApiException {
        ApiResponse<InboxForwarderDto> localVarResp = getInboxForwarderWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get an inbox forwarder
     * Get inbox ruleset
     * @param id ID of inbox forwarder (required)
     * @return ApiResponse&lt;InboxForwarderDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxForwarderDto> getInboxForwarderWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getInboxForwarderValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<InboxForwarderDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an inbox forwarder (asynchronously)
     * Get inbox ruleset
     * @param id ID of inbox forwarder (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxForwarderAsync(UUID id, final ApiCallback<InboxForwarderDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxForwarderValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<InboxForwarderDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxForwarders
     * @param inboxId Optional inbox id to get forwarders from (optional)
     * @param page Optional page index in inbox forwarder list pagination (optional, default to 0)
     * @param size Optional page size in inbox forwarder list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxForwardersCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/forwarders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxForwardersValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxForwardersCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * List inbox forwarders
     * List all forwarders attached to an inbox
     * @param inboxId Optional inbox id to get forwarders from (optional)
     * @param page Optional page index in inbox forwarder list pagination (optional, default to 0)
     * @param size Optional page size in inbox forwarder list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageInboxForwarderDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageInboxForwarderDto getInboxForwarders(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageInboxForwarderDto> localVarResp = getInboxForwardersWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * List inbox forwarders
     * List all forwarders attached to an inbox
     * @param inboxId Optional inbox id to get forwarders from (optional)
     * @param page Optional page index in inbox forwarder list pagination (optional, default to 0)
     * @param size Optional page size in inbox forwarder list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageInboxForwarderDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageInboxForwarderDto> getInboxForwardersWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getInboxForwardersValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageInboxForwarderDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List inbox forwarders (asynchronously)
     * List all forwarders attached to an inbox
     * @param inboxId Optional inbox id to get forwarders from (optional)
     * @param page Optional page index in inbox forwarder list pagination (optional, default to 0)
     * @param size Optional page size in inbox forwarder list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxForwardersAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageInboxForwarderDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxForwardersValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageInboxForwarderDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for testInboxForwarder
     * @param id ID of inbox forwarder (required)
     * @param inboxForwarderTestOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxForwarderCall(UUID id, InboxForwarderTestOptions inboxForwarderTestOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = inboxForwarderTestOptions;

        // create path and map variables
        String localVarPath = "/forwarders/{id}/test"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call testInboxForwarderValidateBeforeCall(UUID id, InboxForwarderTestOptions inboxForwarderTestOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling testInboxForwarder(Async)");
        }
        
        // verify the required parameter 'inboxForwarderTestOptions' is set
        if (inboxForwarderTestOptions == null) {
            throw new ApiException("Missing the required parameter 'inboxForwarderTestOptions' when calling testInboxForwarder(Async)");
        }
        

        okhttp3.Call localVarCall = testInboxForwarderCall(id, inboxForwarderTestOptions, _callback);
        return localVarCall;

    }

    /**
     * Test an inbox forwarder
     * Test an inbox forwarder
     * @param id ID of inbox forwarder (required)
     * @param inboxForwarderTestOptions  (required)
     * @return InboxForwarderTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxForwarderTestResult testInboxForwarder(UUID id, InboxForwarderTestOptions inboxForwarderTestOptions) throws ApiException {
        ApiResponse<InboxForwarderTestResult> localVarResp = testInboxForwarderWithHttpInfo(id, inboxForwarderTestOptions);
        return localVarResp.getData();
    }

    /**
     * Test an inbox forwarder
     * Test an inbox forwarder
     * @param id ID of inbox forwarder (required)
     * @param inboxForwarderTestOptions  (required)
     * @return ApiResponse&lt;InboxForwarderTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxForwarderTestResult> testInboxForwarderWithHttpInfo(UUID id, InboxForwarderTestOptions inboxForwarderTestOptions) throws ApiException {
        okhttp3.Call localVarCall = testInboxForwarderValidateBeforeCall(id, inboxForwarderTestOptions, null);
        Type localVarReturnType = new TypeToken<InboxForwarderTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Test an inbox forwarder (asynchronously)
     * Test an inbox forwarder
     * @param id ID of inbox forwarder (required)
     * @param inboxForwarderTestOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxForwarderAsync(UUID id, InboxForwarderTestOptions inboxForwarderTestOptions, final ApiCallback<InboxForwarderTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = testInboxForwarderValidateBeforeCall(id, inboxForwarderTestOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxForwarderTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for testInboxForwardersForInbox
     * @param inboxId ID of inbox (required)
     * @param inboxForwarderTestOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxForwardersForInboxCall(UUID inboxId, InboxForwarderTestOptions inboxForwarderTestOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = inboxForwarderTestOptions;

        // create path and map variables
        String localVarPath = "/forwarders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call testInboxForwardersForInboxValidateBeforeCall(UUID inboxId, InboxForwarderTestOptions inboxForwarderTestOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling testInboxForwardersForInbox(Async)");
        }
        
        // verify the required parameter 'inboxForwarderTestOptions' is set
        if (inboxForwarderTestOptions == null) {
            throw new ApiException("Missing the required parameter 'inboxForwarderTestOptions' when calling testInboxForwardersForInbox(Async)");
        }
        

        okhttp3.Call localVarCall = testInboxForwardersForInboxCall(inboxId, inboxForwarderTestOptions, _callback);
        return localVarCall;

    }

    /**
     * Test inbox forwarders for inbox
     * Test inbox forwarders for inbox
     * @param inboxId ID of inbox (required)
     * @param inboxForwarderTestOptions  (required)
     * @return InboxForwarderTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxForwarderTestResult testInboxForwardersForInbox(UUID inboxId, InboxForwarderTestOptions inboxForwarderTestOptions) throws ApiException {
        ApiResponse<InboxForwarderTestResult> localVarResp = testInboxForwardersForInboxWithHttpInfo(inboxId, inboxForwarderTestOptions);
        return localVarResp.getData();
    }

    /**
     * Test inbox forwarders for inbox
     * Test inbox forwarders for inbox
     * @param inboxId ID of inbox (required)
     * @param inboxForwarderTestOptions  (required)
     * @return ApiResponse&lt;InboxForwarderTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxForwarderTestResult> testInboxForwardersForInboxWithHttpInfo(UUID inboxId, InboxForwarderTestOptions inboxForwarderTestOptions) throws ApiException {
        okhttp3.Call localVarCall = testInboxForwardersForInboxValidateBeforeCall(inboxId, inboxForwarderTestOptions, null);
        Type localVarReturnType = new TypeToken<InboxForwarderTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Test inbox forwarders for inbox (asynchronously)
     * Test inbox forwarders for inbox
     * @param inboxId ID of inbox (required)
     * @param inboxForwarderTestOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxForwardersForInboxAsync(UUID inboxId, InboxForwarderTestOptions inboxForwarderTestOptions, final ApiCallback<InboxForwarderTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = testInboxForwardersForInboxValidateBeforeCall(inboxId, inboxForwarderTestOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxForwarderTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for testNewInboxForwarder
     * @param testNewInboxForwarderOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testNewInboxForwarderCall(TestNewInboxForwarderOptions testNewInboxForwarderOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = testNewInboxForwarderOptions;

        // create path and map variables
        String localVarPath = "/forwarders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call testNewInboxForwarderValidateBeforeCall(TestNewInboxForwarderOptions testNewInboxForwarderOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'testNewInboxForwarderOptions' is set
        if (testNewInboxForwarderOptions == null) {
            throw new ApiException("Missing the required parameter 'testNewInboxForwarderOptions' when calling testNewInboxForwarder(Async)");
        }
        

        okhttp3.Call localVarCall = testNewInboxForwarderCall(testNewInboxForwarderOptions, _callback);
        return localVarCall;

    }

    /**
     * Test new inbox forwarder
     * Test new inbox forwarder
     * @param testNewInboxForwarderOptions  (required)
     * @return InboxForwarderTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxForwarderTestResult testNewInboxForwarder(TestNewInboxForwarderOptions testNewInboxForwarderOptions) throws ApiException {
        ApiResponse<InboxForwarderTestResult> localVarResp = testNewInboxForwarderWithHttpInfo(testNewInboxForwarderOptions);
        return localVarResp.getData();
    }

    /**
     * Test new inbox forwarder
     * Test new inbox forwarder
     * @param testNewInboxForwarderOptions  (required)
     * @return ApiResponse&lt;InboxForwarderTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxForwarderTestResult> testNewInboxForwarderWithHttpInfo(TestNewInboxForwarderOptions testNewInboxForwarderOptions) throws ApiException {
        okhttp3.Call localVarCall = testNewInboxForwarderValidateBeforeCall(testNewInboxForwarderOptions, null);
        Type localVarReturnType = new TypeToken<InboxForwarderTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Test new inbox forwarder (asynchronously)
     * Test new inbox forwarder
     * @param testNewInboxForwarderOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testNewInboxForwarderAsync(TestNewInboxForwarderOptions testNewInboxForwarderOptions, final ApiCallback<InboxForwarderTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = testNewInboxForwarderValidateBeforeCall(testNewInboxForwarderOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxForwarderTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
